<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JourneyPriceClassType StructType
 * Meta information extracted from the WSDL
 * - documentation: Price class information per Journey.
 * @subpackage Structs
 */
class JourneyPriceClassType extends AbstractStructBase
{
    /**
     * The PaxJourneyRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger Journey within the context of this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxJourneyRefID;
    /**
     * The PriceClassRefID
     * Meta information extracted from the WSDL
     * - documentation: Itinerary level Price Class ref | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceClassRefID;
    /**
     * Constructor method for JourneyPriceClassType
     * @uses JourneyPriceClassType::setPaxJourneyRefID()
     * @uses JourneyPriceClassType::setPriceClassRefID()
     * @param string $paxJourneyRefID
     * @param string $priceClassRefID
     */
    public function __construct($paxJourneyRefID = null, $priceClassRefID = null)
    {
        $this
            ->setPaxJourneyRefID($paxJourneyRefID)
            ->setPriceClassRefID($priceClassRefID);
    }
    /**
     * Get PaxJourneyRefID value
     * @return string
     */
    public function getPaxJourneyRefID()
    {
        return $this->PaxJourneyRefID;
    }
    /**
     * Set PaxJourneyRefID value
     * @param string $paxJourneyRefID
     * @return \StructType\JourneyPriceClassType
     */
    public function setPaxJourneyRefID($paxJourneyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxJourneyRefID) && !is_string($paxJourneyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxJourneyRefID, true), gettype($paxJourneyRefID)), __LINE__);
        }
        $this->PaxJourneyRefID = $paxJourneyRefID;
        return $this;
    }
    /**
     * Get PriceClassRefID value
     * @return string|null
     */
    public function getPriceClassRefID()
    {
        return $this->PriceClassRefID;
    }
    /**
     * Set PriceClassRefID value
     * @param string $priceClassRefID
     * @return \StructType\JourneyPriceClassType
     */
    public function setPriceClassRefID($priceClassRefID = null)
    {
        // validation for constraint: string
        if (!is_null($priceClassRefID) && !is_string($priceClassRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceClassRefID, true), gettype($priceClassRefID)), __LINE__);
        }
        $this->PriceClassRefID = $priceClassRefID;
        return $this;
    }
}
