<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlineServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Interline Service specialization of the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a
 * service can be sold to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
 * @subpackage Structs
 */
class InterlineServiceType extends AbstractStructBase
{
    /**
     * The InterlineOrderServiceAssociation
     * Meta information extracted from the WSDL
     * - documentation: Interline Order Service Association
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\InterlineOrderServiceAssociationType
     */
    public $InterlineOrderServiceAssociation;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID within this message | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxRefID;
    /**
     * The PaxSegmentRef
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID . This will be a reference to a single passenger segment that will be defined in a data list or pax segment list in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxSegmentRefType
     */
    public $PaxSegmentRef;
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a Service within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceID;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\BookingRefType[]
     */
    public $BookingRef;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Free text for textual description. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The ResponsibleAirline
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $ResponsibleAirline;
    /**
     * The ServiceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to another service instance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceRefID;
    /**
     * The SettlementInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to the value of a product or service as it pertains to interline transactions.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SettlementInfoType
     */
    public $SettlementInfo;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Service Status instance. See ATSB Codeset OrderService for possible values. | The possible statuses of an Order Service {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Service
     * Status,coded{/codeListName} {codeListIdentifier}ORDERSERVICE{/codeListIdentifier} | represents the statuses of an Order Service
     * - base: OrderServiceStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The UnchangedInd
     * Meta information extracted from the WSDL
     * - documentation: Indicated that this service is unchanged after reshopping. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $UnchangedInd;
    /**
     * The ValidatingCarrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $ValidatingCarrier;
    /**
     * Constructor method for InterlineServiceType
     * @uses InterlineServiceType::setInterlineOrderServiceAssociation()
     * @uses InterlineServiceType::setPaxRefID()
     * @uses InterlineServiceType::setPaxSegmentRef()
     * @uses InterlineServiceType::setServiceID()
     * @uses InterlineServiceType::setBookingRef()
     * @uses InterlineServiceType::setDescText()
     * @uses InterlineServiceType::setResponsibleAirline()
     * @uses InterlineServiceType::setServiceRefID()
     * @uses InterlineServiceType::setSettlementInfo()
     * @uses InterlineServiceType::setStatusCode()
     * @uses InterlineServiceType::setUnchangedInd()
     * @uses InterlineServiceType::setValidatingCarrier()
     * @param \StructType\InterlineOrderServiceAssociationType $interlineOrderServiceAssociation
     * @param string $paxRefID
     * @param \StructType\PaxSegmentRefType $paxSegmentRef
     * @param string $serviceID
     * @param \StructType\BookingRefType[] $bookingRef
     * @param string $descText
     * @param \StructType\CarrierType $responsibleAirline
     * @param string $serviceRefID
     * @param \StructType\SettlementInfoType $settlementInfo
     * @param string $statusCode
     * @param bool $unchangedInd
     * @param \StructType\CarrierType $validatingCarrier
     */
    public function __construct(\StructType\InterlineOrderServiceAssociationType $interlineOrderServiceAssociation = null, $paxRefID = null, \StructType\PaxSegmentRefType $paxSegmentRef = null, $serviceID = null, array $bookingRef = array(), $descText = null, \StructType\CarrierType $responsibleAirline = null, $serviceRefID = null, \StructType\SettlementInfoType $settlementInfo = null, $statusCode = null, $unchangedInd = null, \StructType\CarrierType $validatingCarrier = null)
    {
        $this
            ->setInterlineOrderServiceAssociation($interlineOrderServiceAssociation)
            ->setPaxRefID($paxRefID)
            ->setPaxSegmentRef($paxSegmentRef)
            ->setServiceID($serviceID)
            ->setBookingRef($bookingRef)
            ->setDescText($descText)
            ->setResponsibleAirline($responsibleAirline)
            ->setServiceRefID($serviceRefID)
            ->setSettlementInfo($settlementInfo)
            ->setStatusCode($statusCode)
            ->setUnchangedInd($unchangedInd)
            ->setValidatingCarrier($validatingCarrier);
    }
    /**
     * Get InterlineOrderServiceAssociation value
     * @return \StructType\InterlineOrderServiceAssociationType
     */
    public function getInterlineOrderServiceAssociation()
    {
        return $this->InterlineOrderServiceAssociation;
    }
    /**
     * Set InterlineOrderServiceAssociation value
     * @param \StructType\InterlineOrderServiceAssociationType $interlineOrderServiceAssociation
     * @return \StructType\InterlineServiceType
     */
    public function setInterlineOrderServiceAssociation(\StructType\InterlineOrderServiceAssociationType $interlineOrderServiceAssociation = null)
    {
        $this->InterlineOrderServiceAssociation = $interlineOrderServiceAssociation;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\InterlineServiceType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get PaxSegmentRef value
     * @return \StructType\PaxSegmentRefType
     */
    public function getPaxSegmentRef()
    {
        return $this->PaxSegmentRef;
    }
    /**
     * Set PaxSegmentRef value
     * @param \StructType\PaxSegmentRefType $paxSegmentRef
     * @return \StructType\InterlineServiceType
     */
    public function setPaxSegmentRef(\StructType\PaxSegmentRefType $paxSegmentRef = null)
    {
        $this->PaxSegmentRef = $paxSegmentRef;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return string
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \StructType\InterlineServiceType
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return \StructType\BookingRefType[]|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingRefForArrayConstraintsFromSetBookingRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineServiceTypeBookingRefItem) {
            // validation for constraint: itemType
            if (!$interlineServiceTypeBookingRefItem instanceof \StructType\BookingRefType) {
                $invalidValues[] = is_object($interlineServiceTypeBookingRefItem) ? get_class($interlineServiceTypeBookingRefItem) : sprintf('%s(%s)', gettype($interlineServiceTypeBookingRefItem), var_export($interlineServiceTypeBookingRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType[] $bookingRef
     * @return \StructType\InterlineServiceType
     */
    public function setBookingRef(array $bookingRef = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingRefArrayErrorMessage = self::validateBookingRefForArrayConstraintsFromSetBookingRef($bookingRef))) {
            throw new \InvalidArgumentException($bookingRefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($bookingRef) && count($bookingRef) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($bookingRef)), __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Add item to BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType $item
     * @return \StructType\InterlineServiceType
     */
    public function addToBookingRef(\StructType\BookingRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingRefType) {
            throw new \InvalidArgumentException(sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->BookingRef) && count($this->BookingRef) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->BookingRef)), __LINE__);
        }
        $this->BookingRef[] = $item;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\InterlineServiceType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get ResponsibleAirline value
     * @return \StructType\CarrierType|null
     */
    public function getResponsibleAirline()
    {
        return $this->ResponsibleAirline;
    }
    /**
     * Set ResponsibleAirline value
     * @param \StructType\CarrierType $responsibleAirline
     * @return \StructType\InterlineServiceType
     */
    public function setResponsibleAirline(\StructType\CarrierType $responsibleAirline = null)
    {
        $this->ResponsibleAirline = $responsibleAirline;
        return $this;
    }
    /**
     * Get ServiceRefID value
     * @return string|null
     */
    public function getServiceRefID()
    {
        return $this->ServiceRefID;
    }
    /**
     * Set ServiceRefID value
     * @param string $serviceRefID
     * @return \StructType\InterlineServiceType
     */
    public function setServiceRefID($serviceRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRefID) && !is_string($serviceRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRefID, true), gettype($serviceRefID)), __LINE__);
        }
        $this->ServiceRefID = $serviceRefID;
        return $this;
    }
    /**
     * Get SettlementInfo value
     * @return \StructType\SettlementInfoType|null
     */
    public function getSettlementInfo()
    {
        return $this->SettlementInfo;
    }
    /**
     * Set SettlementInfo value
     * @param \StructType\SettlementInfoType $settlementInfo
     * @return \StructType\InterlineServiceType
     */
    public function setSettlementInfo(\StructType\SettlementInfoType $settlementInfo = null)
    {
        $this->SettlementInfo = $settlementInfo;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\InterlineServiceType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get UnchangedInd value
     * @return bool|null
     */
    public function getUnchangedInd()
    {
        return $this->UnchangedInd;
    }
    /**
     * Set UnchangedInd value
     * @param bool $unchangedInd
     * @return \StructType\InterlineServiceType
     */
    public function setUnchangedInd($unchangedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($unchangedInd) && !is_bool($unchangedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unchangedInd, true), gettype($unchangedInd)), __LINE__);
        }
        $this->UnchangedInd = $unchangedInd;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return \StructType\CarrierType|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param \StructType\CarrierType $validatingCarrier
     * @return \StructType\InterlineServiceType
     */
    public function setValidatingCarrier(\StructType\CarrierType $validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
}
