<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlinePaxSegmentCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Transportation of a passenger on a Dated Operating Segment. - [Dated Marketing Segment] (All identifying fields) - [Order] Order ID - [Individual] (no identifier available)
 * @subpackage Structs
 */
class InterlinePaxSegmentCriteriaType extends AbstractStructBase
{
    /**
     * The Arrival
     * Meta information extracted from the WSDL
     * - documentation: This is a transport point location.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TransportPointType
     */
    public $Arrival;
    /**
     * The Dep
     * Meta information extracted from the WSDL
     * - documentation: This is a transport point location.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TransportPointType
     */
    public $Dep;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The ARNK_Ind
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, indicates an ARNK (ARrival uNKown) condition, i.e. a gap between current segment departure and previous segment arrival location, implying an unknown passenger movement. | An indicator is a list of two mutually exclusive
     * Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ARNK_Ind;
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CabinTypeType
     */
    public $CabinType;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Total segment time including the combined air time and connection times of any legs. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time units (Year, Month,
     * Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Duration;
    /**
     * The MarketingSegmentCriteria
     * Meta information extracted from the WSDL
     * - documentation: A set of attributes of a marketed carrier used in search criteria
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MarketingCarrierInfoType
     */
    public $MarketingSegmentCriteria;
    /**
     * The OperatingSegmentCriteria
     * Meta information extracted from the WSDL
     * - documentation: A set of attributes of an operating carrier used in search criteria
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OperatingSegmentCriteriaType
     */
    public $OperatingSegmentCriteria;
    /**
     * The SecureFlightInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, this segment is subject to US TSA 'Secure Flight' passenger prescreening program. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SecureFlightInd;
    /**
     * Constructor method for InterlinePaxSegmentCriteriaType
     * @uses InterlinePaxSegmentCriteriaType::setArrival()
     * @uses InterlinePaxSegmentCriteriaType::setDep()
     * @uses InterlinePaxSegmentCriteriaType::setAirlineTaxonomy()
     * @uses InterlinePaxSegmentCriteriaType::setARNK_Ind()
     * @uses InterlinePaxSegmentCriteriaType::setCabinType()
     * @uses InterlinePaxSegmentCriteriaType::setDuration()
     * @uses InterlinePaxSegmentCriteriaType::setMarketingSegmentCriteria()
     * @uses InterlinePaxSegmentCriteriaType::setOperatingSegmentCriteria()
     * @uses InterlinePaxSegmentCriteriaType::setSecureFlightInd()
     * @param \StructType\TransportPointType $arrival
     * @param \StructType\TransportPointType $dep
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param bool $aRNK_Ind
     * @param \StructType\CabinTypeType $cabinType
     * @param string $duration
     * @param \StructType\MarketingCarrierInfoType $marketingSegmentCriteria
     * @param \StructType\OperatingSegmentCriteriaType $operatingSegmentCriteria
     * @param bool $secureFlightInd
     */
    public function __construct(\StructType\TransportPointType $arrival = null, \StructType\TransportPointType $dep = null, array $airlineTaxonomy = array(), $aRNK_Ind = null, \StructType\CabinTypeType $cabinType = null, $duration = null, \StructType\MarketingCarrierInfoType $marketingSegmentCriteria = null, \StructType\OperatingSegmentCriteriaType $operatingSegmentCriteria = null, $secureFlightInd = null)
    {
        $this
            ->setArrival($arrival)
            ->setDep($dep)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setARNK_Ind($aRNK_Ind)
            ->setCabinType($cabinType)
            ->setDuration($duration)
            ->setMarketingSegmentCriteria($marketingSegmentCriteria)
            ->setOperatingSegmentCriteria($operatingSegmentCriteria)
            ->setSecureFlightInd($secureFlightInd);
    }
    /**
     * Get Arrival value
     * @return \StructType\TransportPointType
     */
    public function getArrival()
    {
        return $this->Arrival;
    }
    /**
     * Set Arrival value
     * @param \StructType\TransportPointType $arrival
     * @return \StructType\InterlinePaxSegmentCriteriaType
     */
    public function setArrival(\StructType\TransportPointType $arrival = null)
    {
        $this->Arrival = $arrival;
        return $this;
    }
    /**
     * Get Dep value
     * @return \StructType\TransportPointType
     */
    public function getDep()
    {
        return $this->Dep;
    }
    /**
     * Set Dep value
     * @param \StructType\TransportPointType $dep
     * @return \StructType\InterlinePaxSegmentCriteriaType
     */
    public function setDep(\StructType\TransportPointType $dep = null)
    {
        $this->Dep = $dep;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlinePaxSegmentCriteriaTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$interlinePaxSegmentCriteriaTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($interlinePaxSegmentCriteriaTypeAirlineTaxonomyItem) ? get_class($interlinePaxSegmentCriteriaTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($interlinePaxSegmentCriteriaTypeAirlineTaxonomyItem), var_export($interlinePaxSegmentCriteriaTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\InterlinePaxSegmentCriteriaType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\InterlinePaxSegmentCriteriaType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get ARNK_Ind value
     * @return bool|null
     */
    public function getARNK_Ind()
    {
        return $this->ARNK_Ind;
    }
    /**
     * Set ARNK_Ind value
     * @param bool $aRNK_Ind
     * @return \StructType\InterlinePaxSegmentCriteriaType
     */
    public function setARNK_Ind($aRNK_Ind = null)
    {
        // validation for constraint: boolean
        if (!is_null($aRNK_Ind) && !is_bool($aRNK_Ind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aRNK_Ind, true), gettype($aRNK_Ind)), __LINE__);
        }
        $this->ARNK_Ind = $aRNK_Ind;
        return $this;
    }
    /**
     * Get CabinType value
     * @return \StructType\CabinTypeType|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @param \StructType\CabinTypeType $cabinType
     * @return \StructType\InterlinePaxSegmentCriteriaType
     */
    public function setCabinType(\StructType\CabinTypeType $cabinType = null)
    {
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\InterlinePaxSegmentCriteriaType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get MarketingSegmentCriteria value
     * @return \StructType\MarketingCarrierInfoType|null
     */
    public function getMarketingSegmentCriteria()
    {
        return $this->MarketingSegmentCriteria;
    }
    /**
     * Set MarketingSegmentCriteria value
     * @param \StructType\MarketingCarrierInfoType $marketingSegmentCriteria
     * @return \StructType\InterlinePaxSegmentCriteriaType
     */
    public function setMarketingSegmentCriteria(\StructType\MarketingCarrierInfoType $marketingSegmentCriteria = null)
    {
        $this->MarketingSegmentCriteria = $marketingSegmentCriteria;
        return $this;
    }
    /**
     * Get OperatingSegmentCriteria value
     * @return \StructType\OperatingSegmentCriteriaType|null
     */
    public function getOperatingSegmentCriteria()
    {
        return $this->OperatingSegmentCriteria;
    }
    /**
     * Set OperatingSegmentCriteria value
     * @param \StructType\OperatingSegmentCriteriaType $operatingSegmentCriteria
     * @return \StructType\InterlinePaxSegmentCriteriaType
     */
    public function setOperatingSegmentCriteria(\StructType\OperatingSegmentCriteriaType $operatingSegmentCriteria = null)
    {
        $this->OperatingSegmentCriteria = $operatingSegmentCriteria;
        return $this;
    }
    /**
     * Get SecureFlightInd value
     * @return bool|null
     */
    public function getSecureFlightInd()
    {
        return $this->SecureFlightInd;
    }
    /**
     * Set SecureFlightInd value
     * @param bool $secureFlightInd
     * @return \StructType\InterlinePaxSegmentCriteriaType
     */
    public function setSecureFlightInd($secureFlightInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($secureFlightInd) && !is_bool($secureFlightInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($secureFlightInd, true), gettype($secureFlightInd)), __LINE__);
        }
        $this->SecureFlightInd = $secureFlightInd;
        return $this;
    }
}
