<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlineOrderServiceAssociationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Interline Order Service Association
 * @subpackage Structs
 */
class InterlineOrderServiceAssociationType extends AbstractStructBase
{
    /**
     * The PaxSegmentReferences
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID's - 1 or more pax segments references. These references will be to a data list or pax segment list in the contained message.
     * - choice: PaxSegmentReferences | SeatOnLeg | ServiceDefinitionRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxSegmentRefListType
     */
    public $PaxSegmentReferences;
    /**
     * The SeatOnLeg
     * Meta information extracted from the WSDL
     * - documentation: A sitting place for a passenger or crew in a cabin compartment on a Dated Operating Leg. Business Identifier Fields: - [Dated Operating Leg] (all identifier fields) - [Seat] (all identifier fields)
     * - choice: PaxSegmentReferences | SeatOnLeg | ServiceDefinitionRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeatOnLegType
     */
    public $SeatOnLeg;
    /**
     * The ServiceDefinitionRef
     * Meta information extracted from the WSDL
     * - documentation: Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
     * - choice: PaxSegmentReferences | SeatOnLeg | ServiceDefinitionRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderServiceDefinitionRefType
     */
    public $ServiceDefinitionRef;
    /**
     * Constructor method for InterlineOrderServiceAssociationType
     * @uses InterlineOrderServiceAssociationType::setPaxSegmentReferences()
     * @uses InterlineOrderServiceAssociationType::setSeatOnLeg()
     * @uses InterlineOrderServiceAssociationType::setServiceDefinitionRef()
     * @param \StructType\PaxSegmentRefListType $paxSegmentReferences
     * @param \StructType\SeatOnLegType $seatOnLeg
     * @param \StructType\OrderServiceDefinitionRefType $serviceDefinitionRef
     */
    public function __construct(\StructType\PaxSegmentRefListType $paxSegmentReferences = null, \StructType\SeatOnLegType $seatOnLeg = null, \StructType\OrderServiceDefinitionRefType $serviceDefinitionRef = null)
    {
        $this
            ->setPaxSegmentReferences($paxSegmentReferences)
            ->setSeatOnLeg($seatOnLeg)
            ->setServiceDefinitionRef($serviceDefinitionRef);
    }
    /**
     * Get PaxSegmentReferences value
     * @return \StructType\PaxSegmentRefListType
     */
    public function getPaxSegmentReferences()
    {
        return isset($this->PaxSegmentReferences) ? $this->PaxSegmentReferences : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaxSegmentReferences method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentReferences method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaxSegmentReferencesForChoiceConstraintsFromSetPaxSegmentReferences($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SeatOnLeg',
            'ServiceDefinitionRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaxSegmentReferences can\'t be set as the property %s is already set. Only one property must be set among these properties: PaxSegmentReferences, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaxSegmentReferences value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentRefListType $paxSegmentReferences
     * @return \StructType\InterlineOrderServiceAssociationType
     */
    public function setPaxSegmentReferences(\StructType\PaxSegmentRefListType $paxSegmentReferences = null)
    {
        // validation for constraint: choice(PaxSegmentReferences, SeatOnLeg, ServiceDefinitionRef)
        if ('' !== ($paxSegmentReferencesChoiceErrorMessage = self::validatePaxSegmentReferencesForChoiceConstraintsFromSetPaxSegmentReferences($paxSegmentReferences))) {
            throw new \InvalidArgumentException($paxSegmentReferencesChoiceErrorMessage, __LINE__);
        }
        if (is_null($paxSegmentReferences) || (is_array($paxSegmentReferences) && empty($paxSegmentReferences))) {
            unset($this->PaxSegmentReferences);
        } else {
            $this->PaxSegmentReferences = $paxSegmentReferences;
        }
        return $this;
    }
    /**
     * Get SeatOnLeg value
     * @return \StructType\SeatOnLegType
     */
    public function getSeatOnLeg()
    {
        return isset($this->SeatOnLeg) ? $this->SeatOnLeg : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSeatOnLeg method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatOnLeg method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSeatOnLegForChoiceConstraintsFromSetSeatOnLeg($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaxSegmentReferences',
            'ServiceDefinitionRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SeatOnLeg can\'t be set as the property %s is already set. Only one property must be set among these properties: SeatOnLeg, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SeatOnLeg value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SeatOnLegType $seatOnLeg
     * @return \StructType\InterlineOrderServiceAssociationType
     */
    public function setSeatOnLeg(\StructType\SeatOnLegType $seatOnLeg = null)
    {
        // validation for constraint: choice(PaxSegmentReferences, SeatOnLeg, ServiceDefinitionRef)
        if ('' !== ($seatOnLegChoiceErrorMessage = self::validateSeatOnLegForChoiceConstraintsFromSetSeatOnLeg($seatOnLeg))) {
            throw new \InvalidArgumentException($seatOnLegChoiceErrorMessage, __LINE__);
        }
        if (is_null($seatOnLeg) || (is_array($seatOnLeg) && empty($seatOnLeg))) {
            unset($this->SeatOnLeg);
        } else {
            $this->SeatOnLeg = $seatOnLeg;
        }
        return $this;
    }
    /**
     * Get ServiceDefinitionRef value
     * @return \StructType\OrderServiceDefinitionRefType
     */
    public function getServiceDefinitionRef()
    {
        return isset($this->ServiceDefinitionRef) ? $this->ServiceDefinitionRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceDefinitionRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceDefinitionRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceDefinitionRefForChoiceConstraintsFromSetServiceDefinitionRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaxSegmentReferences',
            'SeatOnLeg',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceDefinitionRef can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceDefinitionRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceDefinitionRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderServiceDefinitionRefType $serviceDefinitionRef
     * @return \StructType\InterlineOrderServiceAssociationType
     */
    public function setServiceDefinitionRef(\StructType\OrderServiceDefinitionRefType $serviceDefinitionRef = null)
    {
        // validation for constraint: choice(PaxSegmentReferences, SeatOnLeg, ServiceDefinitionRef)
        if ('' !== ($serviceDefinitionRefChoiceErrorMessage = self::validateServiceDefinitionRefForChoiceConstraintsFromSetServiceDefinitionRef($serviceDefinitionRef))) {
            throw new \InvalidArgumentException($serviceDefinitionRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceDefinitionRef) || (is_array($serviceDefinitionRef) && empty($serviceDefinitionRef))) {
            unset($this->ServiceDefinitionRef);
        } else {
            $this->ServiceDefinitionRef = $serviceDefinitionRef;
        }
        return $this;
    }
}
