<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Image StructType
 * Meta information extracted from the WSDL
 * - documentation: Encoded PDF image for the voucher
 * @subpackage Structs
 */
class Image extends AbstractStructBase
{
    /**
     * The Encoding
     * Meta information extracted from the WSDL
     * - documentation: Encoding method usedExample: base64
     * - use: required
     * @var string
     */
    public $Encoding;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - documentation: Image format usedExample: jpeg
     * - use: required
     * @var string
     */
    public $Format;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The Symbology
     * Meta information extracted from the WSDL
     * - documentation: Symbology appliedExample: PDF417
     * - use: optional
     * @var string
     */
    public $Symbology;
    /**
     * Constructor method for Image
     * @uses Image::setEncoding()
     * @uses Image::setFormat()
     * @uses Image::set_()
     * @uses Image::setSymbology()
     * @param string $encoding
     * @param string $format
     * @param string $_
     * @param string $symbology
     */
    public function __construct($encoding = null, $format = null, $_ = null, $symbology = null)
    {
        $this
            ->setEncoding($encoding)
            ->setFormat($format)
            ->set_($_)
            ->setSymbology($symbology);
    }
    /**
     * Get Encoding value
     * @return string
     */
    public function getEncoding()
    {
        return $this->Encoding;
    }
    /**
     * Set Encoding value
     * @param string $encoding
     * @return \StructType\Image
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: string
        if (!is_null($encoding) && !is_string($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encoding, true), gettype($encoding)), __LINE__);
        }
        $this->Encoding = $encoding;
        return $this;
    }
    /**
     * Get Format value
     * @return string
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\Image
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\Image
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Symbology value
     * @return string|null
     */
    public function getSymbology()
    {
        return $this->Symbology;
    }
    /**
     * Set Symbology value
     * @param string $symbology
     * @return \StructType\Image
     */
    public function setSymbology($symbology = null)
    {
        // validation for constraint: string
        if (!is_null($symbology) && !is_string($symbology)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($symbology, true), gettype($symbology)), __LINE__);
        }
        $this->Symbology = $symbology;
        return $this;
    }
}
