<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IATA_AirShoppingRS StructType
 * Meta information extracted from the WSDL
 * - documentation: The AirShopping transaction set supports both demanding and flexible shopping experiences for anonymous or personalized shopping.The combination of functionally-rich attribute and affinity shopping support date range or specific
 * month (calendar) shopping as an example.The response returns offers which may include branded offers or itinerary-priced offers with or without ancillary services. It also returns applicable rules for the integrated fares as well as for each
 * service.The message also returns multi-media content at message level as well as media references at the individual offer level.
 * @subpackage Structs
 */
class IATA_AirShoppingRS extends AbstractStructBase
{
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to errors detected during processing of the preceding request.
     * - choice: Error | Response
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ErrorType[]
     */
    public $Error;
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - documentation: AirShopping response information.
     * - choice: Error | Response
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AirShoppingResponseType
     */
    public $Response;
    /**
     * The AugmentationPoint
     * Meta information extracted from the WSDL
     * - documentation: Implementer-Augmented Structure.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AugmentationPointType
     */
    public $AugmentationPoint;
    /**
     * The DistributionChain
     * Meta information extracted from the WSDL
     * - documentation: An instance of a distribution channel, which is a chain of intermediaries through which a good or service passes until it reaches the final buyer or the end consumer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DistributionChainType
     */
    public $DistributionChain;
    /**
     * The PayloadAttributes
     * Meta information extracted from the WSDL
     * - documentation: IATA standard payload attributes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IATA_PayloadStandardAttributesType
     */
    public $PayloadAttributes;
    /**
     * Constructor method for IATA_AirShoppingRS
     * @uses IATA_AirShoppingRS::setError()
     * @uses IATA_AirShoppingRS::setResponse()
     * @uses IATA_AirShoppingRS::setAugmentationPoint()
     * @uses IATA_AirShoppingRS::setDistributionChain()
     * @uses IATA_AirShoppingRS::setPayloadAttributes()
     * @param \StructType\ErrorType[] $error
     * @param \StructType\AirShoppingResponseType $response
     * @param \StructType\AugmentationPointType $augmentationPoint
     * @param \StructType\DistributionChainType $distributionChain
     * @param \StructType\IATA_PayloadStandardAttributesType $payloadAttributes
     */
    public function __construct(array $error = array(), \StructType\AirShoppingResponseType $response = null, \StructType\AugmentationPointType $augmentationPoint = null, \StructType\DistributionChainType $distributionChain = null, \StructType\IATA_PayloadStandardAttributesType $payloadAttributes = null)
    {
        $this
            ->setError($error)
            ->setResponse($response)
            ->setAugmentationPoint($augmentationPoint)
            ->setDistributionChain($distributionChain)
            ->setPayloadAttributes($payloadAttributes);
    }
    /**
     * Get Error value
     * @return \StructType\ErrorType[]
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * This method is responsible for validating the values passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorForArrayConstraintsFromSetError(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $iATA_AirShoppingRSErrorItem) {
            // validation for constraint: itemType
            if (!$iATA_AirShoppingRSErrorItem instanceof \StructType\ErrorType) {
                $invalidValues[] = is_object($iATA_AirShoppingRSErrorItem) ? get_class($iATA_AirShoppingRSErrorItem) : sprintf('%s(%s)', gettype($iATA_AirShoppingRSErrorItem), var_export($iATA_AirShoppingRSErrorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Error property can only contain items of type \StructType\ErrorType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorForChoiceConstraintsFromSetError($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Response',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Error can\'t be set as the property %s is already set. Only one property must be set among these properties: Error, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Error value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorType[] $error
     * @return \StructType\IATA_AirShoppingRS
     */
    public function setError(array $error = array())
    {
        // validation for constraint: array
        if ('' !== ($errorArrayErrorMessage = self::validateErrorForArrayConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Error, Response)
        if ('' !== ($errorChoiceErrorMessage = self::validateErrorForChoiceConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorChoiceErrorMessage, __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToError method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToError method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToError($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Response',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Error can\'t be set as the property %s is already set. Only one property must be set among these properties: Error, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorType $item
     * @return \StructType\IATA_AirShoppingRS
     */
    public function addToError(\StructType\ErrorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErrorType) {
            throw new \InvalidArgumentException(sprintf('The Error property can only contain items of type \StructType\ErrorType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Error, Response)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToError($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Get Response value
     * @return \StructType\AirShoppingResponseType
     */
    public function getResponse()
    {
        return isset($this->Response) ? $this->Response : null;
    }
    /**
     * This method is responsible for validating the value passed to the setResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateResponseForChoiceConstraintsFromSetResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Error',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Response can\'t be set as the property %s is already set. Only one property must be set among these properties: Response, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Response value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AirShoppingResponseType $response
     * @return \StructType\IATA_AirShoppingRS
     */
    public function setResponse(\StructType\AirShoppingResponseType $response = null)
    {
        // validation for constraint: choice(Error, Response)
        if ('' !== ($responseChoiceErrorMessage = self::validateResponseForChoiceConstraintsFromSetResponse($response))) {
            throw new \InvalidArgumentException($responseChoiceErrorMessage, __LINE__);
        }
        if (is_null($response) || (is_array($response) && empty($response))) {
            unset($this->Response);
        } else {
            $this->Response = $response;
        }
        return $this;
    }
    /**
     * Get AugmentationPoint value
     * @return \StructType\AugmentationPointType|null
     */
    public function getAugmentationPoint()
    {
        return $this->AugmentationPoint;
    }
    /**
     * Set AugmentationPoint value
     * @param \StructType\AugmentationPointType $augmentationPoint
     * @return \StructType\IATA_AirShoppingRS
     */
    public function setAugmentationPoint(\StructType\AugmentationPointType $augmentationPoint = null)
    {
        $this->AugmentationPoint = $augmentationPoint;
        return $this;
    }
    /**
     * Get DistributionChain value
     * @return \StructType\DistributionChainType|null
     */
    public function getDistributionChain()
    {
        return $this->DistributionChain;
    }
    /**
     * Set DistributionChain value
     * @param \StructType\DistributionChainType $distributionChain
     * @return \StructType\IATA_AirShoppingRS
     */
    public function setDistributionChain(\StructType\DistributionChainType $distributionChain = null)
    {
        $this->DistributionChain = $distributionChain;
        return $this;
    }
    /**
     * Get PayloadAttributes value
     * @return \StructType\IATA_PayloadStandardAttributesType|null
     */
    public function getPayloadAttributes()
    {
        return $this->PayloadAttributes;
    }
    /**
     * Set PayloadAttributes value
     * @param \StructType\IATA_PayloadStandardAttributesType $payloadAttributes
     * @return \StructType\IATA_AirShoppingRS
     */
    public function setPayloadAttributes(\StructType\IATA_PayloadStandardAttributesType $payloadAttributes = null)
    {
        $this->PayloadAttributes = $payloadAttributes;
        return $this;
    }
}
