<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IATA_AirShoppingRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: The AirShopping transaction set supports both demanding and flexible shopping experiences for anonymous or personalized shopping.The combination of functionally-rich attribute and affinity shopping support date range or specific
 * month (calendar) shopping as an example.The response returns offers which may include branded offers or itinerary-priced offers with or without ancillary services. It also returns applicable rules for the integrated fares as well as for each
 * service.The message also returns multi-media content at message level as well as media references at the individual offer level.
 * @subpackage Structs
 */
class IATA_AirShoppingRQ extends AbstractStructBase
{
    /**
     * The DistributionChain
     * Meta information extracted from the WSDL
     * - documentation: An instance of a distribution channel. That is, the set of organizations involved in the development of the current transaction.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DistributionChainType
     */
    public $DistributionChain;
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - documentation: AirShoppingRQ request information.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AirShoppingRequestType
     */
    public $Request;
    /**
     * The AugmentationPoint
     * Meta information extracted from the WSDL
     * - documentation: Implementer-Augmented Structure.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AugmentationPointType
     */
    public $AugmentationPoint;
    /**
     * The PayloadAttributes
     * Meta information extracted from the WSDL
     * - documentation: IATA payload standard attributes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IATA_PayloadStandardAttributesType
     */
    public $PayloadAttributes;
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - documentation: Point of Sale Information
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * Constructor method for IATA_AirShoppingRQ
     * @uses IATA_AirShoppingRQ::setDistributionChain()
     * @uses IATA_AirShoppingRQ::setRequest()
     * @uses IATA_AirShoppingRQ::setAugmentationPoint()
     * @uses IATA_AirShoppingRQ::setPayloadAttributes()
     * @uses IATA_AirShoppingRQ::setPOS()
     * @param \StructType\DistributionChainType $distributionChain
     * @param \StructType\AirShoppingRequestType $request
     * @param \StructType\AugmentationPointType $augmentationPoint
     * @param \StructType\IATA_PayloadStandardAttributesType $payloadAttributes
     * @param \StructType\POS_Type $pOS
     */
    public function __construct(\StructType\DistributionChainType $distributionChain = null, \StructType\AirShoppingRequestType $request = null, \StructType\AugmentationPointType $augmentationPoint = null, \StructType\IATA_PayloadStandardAttributesType $payloadAttributes = null, \StructType\POS_Type $pOS = null)
    {
        $this
            ->setDistributionChain($distributionChain)
            ->setRequest($request)
            ->setAugmentationPoint($augmentationPoint)
            ->setPayloadAttributes($payloadAttributes)
            ->setPOS($pOS);
    }
    /**
     * Get DistributionChain value
     * @return \StructType\DistributionChainType
     */
    public function getDistributionChain()
    {
        return $this->DistributionChain;
    }
    /**
     * Set DistributionChain value
     * @param \StructType\DistributionChainType $distributionChain
     * @return \StructType\IATA_AirShoppingRQ
     */
    public function setDistributionChain(\StructType\DistributionChainType $distributionChain = null)
    {
        $this->DistributionChain = $distributionChain;
        return $this;
    }
    /**
     * Get Request value
     * @return \StructType\AirShoppingRequestType
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \StructType\AirShoppingRequestType $request
     * @return \StructType\IATA_AirShoppingRQ
     */
    public function setRequest(\StructType\AirShoppingRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get AugmentationPoint value
     * @return \StructType\AugmentationPointType|null
     */
    public function getAugmentationPoint()
    {
        return $this->AugmentationPoint;
    }
    /**
     * Set AugmentationPoint value
     * @param \StructType\AugmentationPointType $augmentationPoint
     * @return \StructType\IATA_AirShoppingRQ
     */
    public function setAugmentationPoint(\StructType\AugmentationPointType $augmentationPoint = null)
    {
        $this->AugmentationPoint = $augmentationPoint;
        return $this;
    }
    /**
     * Get PayloadAttributes value
     * @return \StructType\IATA_PayloadStandardAttributesType|null
     */
    public function getPayloadAttributes()
    {
        return $this->PayloadAttributes;
    }
    /**
     * Set PayloadAttributes value
     * @param \StructType\IATA_PayloadStandardAttributesType $payloadAttributes
     * @return \StructType\IATA_AirShoppingRQ
     */
    public function setPayloadAttributes(\StructType\IATA_PayloadStandardAttributesType $payloadAttributes = null)
    {
        $this->PayloadAttributes = $payloadAttributes;
        return $this;
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\IATA_AirShoppingRQ
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
}
