<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupFareCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Group Fare preferences by passenger type
 * @subpackage Structs
 */
class GroupFareCriteriaType extends AbstractStructBase
{
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: Fare basis code. Example: Y26 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FareBasisCode;
    /**
     * The PaxSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger Segment ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxSegmentRefID;
    /**
     * The PrefLevel
     * Meta information extracted from the WSDL
     * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrefLevelType
     */
    public $PrefLevel;
    /**
     * The PTC
     * Meta information extracted from the WSDL
     * - documentation: Type code applying to the Passenger which typically drives pricing (e.g. ADT, CHD, etc). | Additional BDT to specify the type code codeset applying to a Passenger.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PTC;
    /**
     * Constructor method for GroupFareCriteriaType
     * @uses GroupFareCriteriaType::setFareBasisCode()
     * @uses GroupFareCriteriaType::setPaxSegmentRefID()
     * @uses GroupFareCriteriaType::setPrefLevel()
     * @uses GroupFareCriteriaType::setPTC()
     * @param string[] $fareBasisCode
     * @param string[] $paxSegmentRefID
     * @param \StructType\PrefLevelType $prefLevel
     * @param string $pTC
     */
    public function __construct(array $fareBasisCode = array(), array $paxSegmentRefID = array(), \StructType\PrefLevelType $prefLevel = null, $pTC = null)
    {
        $this
            ->setFareBasisCode($fareBasisCode)
            ->setPaxSegmentRefID($paxSegmentRefID)
            ->setPrefLevel($prefLevel)
            ->setPTC($pTC);
    }
    /**
     * Get FareBasisCode value
     * @return string[]|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * This method is responsible for validating the values passed to the setFareBasisCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareBasisCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareBasisCodeForArrayConstraintsFromSetFareBasisCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $groupFareCriteriaTypeFareBasisCodeItem) {
            // validation for constraint: itemType
            if (!is_string($groupFareCriteriaTypeFareBasisCodeItem)) {
                $invalidValues[] = is_object($groupFareCriteriaTypeFareBasisCodeItem) ? get_class($groupFareCriteriaTypeFareBasisCodeItem) : sprintf('%s(%s)', gettype($groupFareCriteriaTypeFareBasisCodeItem), var_export($groupFareCriteriaTypeFareBasisCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareBasisCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareBasisCode value
     * @throws \InvalidArgumentException
     * @param string[] $fareBasisCode
     * @return \StructType\GroupFareCriteriaType
     */
    public function setFareBasisCode(array $fareBasisCode = array())
    {
        // validation for constraint: array
        if ('' !== ($fareBasisCodeArrayErrorMessage = self::validateFareBasisCodeForArrayConstraintsFromSetFareBasisCode($fareBasisCode))) {
            throw new \InvalidArgumentException($fareBasisCodeArrayErrorMessage, __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Add item to FareBasisCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GroupFareCriteriaType
     */
    public function addToFareBasisCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FareBasisCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareBasisCode[] = $item;
        return $this;
    }
    /**
     * Get PaxSegmentRefID value
     * @return string[]|null
     */
    public function getPaxSegmentRefID()
    {
        return $this->PaxSegmentRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxSegmentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxSegmentRefIDForArrayConstraintsFromSetPaxSegmentRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $groupFareCriteriaTypePaxSegmentRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($groupFareCriteriaTypePaxSegmentRefIDItem)) {
                $invalidValues[] = is_object($groupFareCriteriaTypePaxSegmentRefIDItem) ? get_class($groupFareCriteriaTypePaxSegmentRefIDItem) : sprintf('%s(%s)', gettype($groupFareCriteriaTypePaxSegmentRefIDItem), var_export($groupFareCriteriaTypePaxSegmentRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxSegmentRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxSegmentRefID
     * @return \StructType\GroupFareCriteriaType
     */
    public function setPaxSegmentRefID(array $paxSegmentRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxSegmentRefIDArrayErrorMessage = self::validatePaxSegmentRefIDForArrayConstraintsFromSetPaxSegmentRefID($paxSegmentRefID))) {
            throw new \InvalidArgumentException($paxSegmentRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxSegmentRefID = $paxSegmentRefID;
        return $this;
    }
    /**
     * Add item to PaxSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GroupFareCriteriaType
     */
    public function addToPaxSegmentRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxSegmentRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxSegmentRefID[] = $item;
        return $this;
    }
    /**
     * Get PrefLevel value
     * @return \StructType\PrefLevelType|null
     */
    public function getPrefLevel()
    {
        return $this->PrefLevel;
    }
    /**
     * Set PrefLevel value
     * @param \StructType\PrefLevelType $prefLevel
     * @return \StructType\GroupFareCriteriaType
     */
    public function setPrefLevel(\StructType\PrefLevelType $prefLevel = null)
    {
        $this->PrefLevel = $prefLevel;
        return $this;
    }
    /**
     * Get PTC value
     * @return string|null
     */
    public function getPTC()
    {
        return $this->PTC;
    }
    /**
     * Set PTC value
     * @param string $pTC
     * @return \StructType\GroupFareCriteriaType
     */
    public function setPTC($pTC = null)
    {
        // validation for constraint: string
        if (!is_null($pTC) && !is_string($pTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pTC, true), gettype($pTC)), __LINE__);
        }
        $this->PTC = $pTC;
        return $this;
    }
}
