<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightRequestOriginDestinationsCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a container for a flight request type which allow multiple Origin and Destination flight criteria to be input in this type of request.
 * @subpackage Structs
 */
class FlightRequestOriginDestinationsCriteriaType extends AbstractStructBase
{
    /**
     * The OriginDestCriteria
     * Meta information extracted from the WSDL
     * - documentation: The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight. Business Identifier Fields: - [Station] (Origin Station) IATA Location Code - [Station] (Destination Station) IATA Location Code
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OriginDestCriteriaType[]
     */
    public $OriginDestCriteria;
    /**
     * Constructor method for FlightRequestOriginDestinationsCriteriaType
     * @uses FlightRequestOriginDestinationsCriteriaType::setOriginDestCriteria()
     * @param \StructType\OriginDestCriteriaType[] $originDestCriteria
     */
    public function __construct(array $originDestCriteria = array())
    {
        $this
            ->setOriginDestCriteria($originDestCriteria);
    }
    /**
     * Get OriginDestCriteria value
     * @return \StructType\OriginDestCriteriaType[]
     */
    public function getOriginDestCriteria()
    {
        return $this->OriginDestCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginDestCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginDestCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginDestCriteriaForArrayConstraintsFromSetOriginDestCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightRequestOriginDestinationsCriteriaTypeOriginDestCriteriaItem) {
            // validation for constraint: itemType
            if (!$flightRequestOriginDestinationsCriteriaTypeOriginDestCriteriaItem instanceof \StructType\OriginDestCriteriaType) {
                $invalidValues[] = is_object($flightRequestOriginDestinationsCriteriaTypeOriginDestCriteriaItem) ? get_class($flightRequestOriginDestinationsCriteriaTypeOriginDestCriteriaItem) : sprintf('%s(%s)', gettype($flightRequestOriginDestinationsCriteriaTypeOriginDestCriteriaItem), var_export($flightRequestOriginDestinationsCriteriaTypeOriginDestCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginDestCriteria property can only contain items of type \StructType\OriginDestCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OriginDestCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\OriginDestCriteriaType[] $originDestCriteria
     * @return \StructType\FlightRequestOriginDestinationsCriteriaType
     */
    public function setOriginDestCriteria(array $originDestCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($originDestCriteriaArrayErrorMessage = self::validateOriginDestCriteriaForArrayConstraintsFromSetOriginDestCriteria($originDestCriteria))) {
            throw new \InvalidArgumentException($originDestCriteriaArrayErrorMessage, __LINE__);
        }
        $this->OriginDestCriteria = $originDestCriteria;
        return $this;
    }
    /**
     * Add item to OriginDestCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\OriginDestCriteriaType $item
     * @return \StructType\FlightRequestOriginDestinationsCriteriaType
     */
    public function addToOriginDestCriteria(\StructType\OriginDestCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OriginDestCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The OriginDestCriteria property can only contain items of type \StructType\OriginDestCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OriginDestCriteria[] = $item;
        return $this;
    }
}
