<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightOptions StructType
 * Meta information extracted from the WSDL
 * - documentation: Flight group | Alternate flights offered w/this service, such as stand by flight choices (or reaccommodation flights)
 * @subpackage Structs
 */
class FlightOptions extends AbstractStructBase
{
    /**
     * The DepartureCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - use: required
     * @var string
     */
    public $DepartureCode;
    /**
     * The ArrivalCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - use: required
     * @var string
     */
    public $ArrivalCode;
    /**
     * The Flight
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: Flight
     * @var \StructType\Flight[]
     */
    public $Flight;
    /**
     * Constructor method for FlightOptions
     * @uses FlightOptions::setDepartureCode()
     * @uses FlightOptions::setArrivalCode()
     * @uses FlightOptions::setFlight()
     * @param string $departureCode
     * @param string $arrivalCode
     * @param \StructType\Flight[] $flight
     */
    public function __construct($departureCode = null, $arrivalCode = null, array $flight = array())
    {
        $this
            ->setDepartureCode($departureCode)
            ->setArrivalCode($arrivalCode)
            ->setFlight($flight);
    }
    /**
     * Get DepartureCode value
     * @return string
     */
    public function getDepartureCode()
    {
        return $this->DepartureCode;
    }
    /**
     * Set DepartureCode value
     * @param string $departureCode
     * @return \StructType\FlightOptions
     */
    public function setDepartureCode($departureCode = null)
    {
        // validation for constraint: string
        if (!is_null($departureCode) && !is_string($departureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureCode, true), gettype($departureCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($departureCode) && mb_strlen($departureCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($departureCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($departureCode) && mb_strlen($departureCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($departureCode)), __LINE__);
        }
        $this->DepartureCode = $departureCode;
        return $this;
    }
    /**
     * Get ArrivalCode value
     * @return string
     */
    public function getArrivalCode()
    {
        return $this->ArrivalCode;
    }
    /**
     * Set ArrivalCode value
     * @param string $arrivalCode
     * @return \StructType\FlightOptions
     */
    public function setArrivalCode($arrivalCode = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalCode) && !is_string($arrivalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalCode, true), gettype($arrivalCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($arrivalCode) && mb_strlen($arrivalCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($arrivalCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($arrivalCode) && mb_strlen($arrivalCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($arrivalCode)), __LINE__);
        }
        $this->ArrivalCode = $arrivalCode;
        return $this;
    }
    /**
     * Get Flight value
     * @return \StructType\Flight[]|null
     */
    public function getFlight()
    {
        return $this->Flight;
    }
    /**
     * This method is responsible for validating the values passed to the setFlight method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlight method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightForArrayConstraintsFromSetFlight(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightOptionsFlightItem) {
            // validation for constraint: itemType
            if (!$flightOptionsFlightItem instanceof \StructType\Flight) {
                $invalidValues[] = is_object($flightOptionsFlightItem) ? get_class($flightOptionsFlightItem) : sprintf('%s(%s)', gettype($flightOptionsFlightItem), var_export($flightOptionsFlightItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Flight property can only contain items of type \StructType\Flight, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Flight value
     * @throws \InvalidArgumentException
     * @param \StructType\Flight[] $flight
     * @return \StructType\FlightOptions
     */
    public function setFlight(array $flight = array())
    {
        // validation for constraint: array
        if ('' !== ($flightArrayErrorMessage = self::validateFlightForArrayConstraintsFromSetFlight($flight))) {
            throw new \InvalidArgumentException($flightArrayErrorMessage, __LINE__);
        }
        $this->Flight = $flight;
        return $this;
    }
    /**
     * Add item to Flight value
     * @throws \InvalidArgumentException
     * @param \StructType\Flight $item
     * @return \StructType\FlightOptions
     */
    public function addToFlight(\StructType\Flight $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Flight) {
            throw new \InvalidArgumentException(sprintf('The Flight property can only contain items of type \StructType\Flight, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Flight[] = $item;
        return $this;
    }
}
