<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightFilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Filters based on Flight Number, Origin Destination, Segment, or Departure/Arrival.
 * @subpackage Structs
 */
class FlightFilterCriteriaType extends AbstractStructBase
{
    /**
     * The ArrivalFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Flight arrival information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ArrivalFilterCriteriaType
     */
    public $ArrivalFilterCriteria;
    /**
     * The CabinTypeFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CabinTypeType
     */
    public $CabinTypeFilterCriteria;
    /**
     * The DepFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Flight departure information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DepFilterCriteriaType
     */
    public $DepFilterCriteria;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: Fare Basis Code (ex: Y26). | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareBasisCode;
    /**
     * The MarketingCarrierInfoNEW
     * Meta information extracted from the WSDL
     * - documentation: A set of attributes of a marketed carrier used in search criteria
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MarketingCarrierInfoType
     */
    public $MarketingCarrierInfoNEW;
    /**
     * The OriginDestFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Filters results based on Origin Destination.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OriginDestFilterCriteriaType
     */
    public $OriginDestFilterCriteria;
    /**
     * The SegmentFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Filters results based on segment information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SegmentFilterCriteriaType[]
     */
    public $SegmentFilterCriteria;
    /**
     * Constructor method for FlightFilterCriteriaType
     * @uses FlightFilterCriteriaType::setArrivalFilterCriteria()
     * @uses FlightFilterCriteriaType::setCabinTypeFilterCriteria()
     * @uses FlightFilterCriteriaType::setDepFilterCriteria()
     * @uses FlightFilterCriteriaType::setFareBasisCode()
     * @uses FlightFilterCriteriaType::setMarketingCarrierInfoNEW()
     * @uses FlightFilterCriteriaType::setOriginDestFilterCriteria()
     * @uses FlightFilterCriteriaType::setSegmentFilterCriteria()
     * @param \StructType\ArrivalFilterCriteriaType $arrivalFilterCriteria
     * @param \StructType\CabinTypeType $cabinTypeFilterCriteria
     * @param \StructType\DepFilterCriteriaType $depFilterCriteria
     * @param string $fareBasisCode
     * @param \StructType\MarketingCarrierInfoType $marketingCarrierInfoNEW
     * @param \StructType\OriginDestFilterCriteriaType $originDestFilterCriteria
     * @param \StructType\SegmentFilterCriteriaType[] $segmentFilterCriteria
     */
    public function __construct(\StructType\ArrivalFilterCriteriaType $arrivalFilterCriteria = null, \StructType\CabinTypeType $cabinTypeFilterCriteria = null, \StructType\DepFilterCriteriaType $depFilterCriteria = null, $fareBasisCode = null, \StructType\MarketingCarrierInfoType $marketingCarrierInfoNEW = null, \StructType\OriginDestFilterCriteriaType $originDestFilterCriteria = null, array $segmentFilterCriteria = array())
    {
        $this
            ->setArrivalFilterCriteria($arrivalFilterCriteria)
            ->setCabinTypeFilterCriteria($cabinTypeFilterCriteria)
            ->setDepFilterCriteria($depFilterCriteria)
            ->setFareBasisCode($fareBasisCode)
            ->setMarketingCarrierInfoNEW($marketingCarrierInfoNEW)
            ->setOriginDestFilterCriteria($originDestFilterCriteria)
            ->setSegmentFilterCriteria($segmentFilterCriteria);
    }
    /**
     * Get ArrivalFilterCriteria value
     * @return \StructType\ArrivalFilterCriteriaType|null
     */
    public function getArrivalFilterCriteria()
    {
        return $this->ArrivalFilterCriteria;
    }
    /**
     * Set ArrivalFilterCriteria value
     * @param \StructType\ArrivalFilterCriteriaType $arrivalFilterCriteria
     * @return \StructType\FlightFilterCriteriaType
     */
    public function setArrivalFilterCriteria(\StructType\ArrivalFilterCriteriaType $arrivalFilterCriteria = null)
    {
        $this->ArrivalFilterCriteria = $arrivalFilterCriteria;
        return $this;
    }
    /**
     * Get CabinTypeFilterCriteria value
     * @return \StructType\CabinTypeType|null
     */
    public function getCabinTypeFilterCriteria()
    {
        return $this->CabinTypeFilterCriteria;
    }
    /**
     * Set CabinTypeFilterCriteria value
     * @param \StructType\CabinTypeType $cabinTypeFilterCriteria
     * @return \StructType\FlightFilterCriteriaType
     */
    public function setCabinTypeFilterCriteria(\StructType\CabinTypeType $cabinTypeFilterCriteria = null)
    {
        $this->CabinTypeFilterCriteria = $cabinTypeFilterCriteria;
        return $this;
    }
    /**
     * Get DepFilterCriteria value
     * @return \StructType\DepFilterCriteriaType|null
     */
    public function getDepFilterCriteria()
    {
        return $this->DepFilterCriteria;
    }
    /**
     * Set DepFilterCriteria value
     * @param \StructType\DepFilterCriteriaType $depFilterCriteria
     * @return \StructType\FlightFilterCriteriaType
     */
    public function setDepFilterCriteria(\StructType\DepFilterCriteriaType $depFilterCriteria = null)
    {
        $this->DepFilterCriteria = $depFilterCriteria;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\FlightFilterCriteriaType
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get MarketingCarrierInfoNEW value
     * @return \StructType\MarketingCarrierInfoType|null
     */
    public function getMarketingCarrierInfoNEW()
    {
        return $this->MarketingCarrierInfoNEW;
    }
    /**
     * Set MarketingCarrierInfoNEW value
     * @param \StructType\MarketingCarrierInfoType $marketingCarrierInfoNEW
     * @return \StructType\FlightFilterCriteriaType
     */
    public function setMarketingCarrierInfoNEW(\StructType\MarketingCarrierInfoType $marketingCarrierInfoNEW = null)
    {
        $this->MarketingCarrierInfoNEW = $marketingCarrierInfoNEW;
        return $this;
    }
    /**
     * Get OriginDestFilterCriteria value
     * @return \StructType\OriginDestFilterCriteriaType|null
     */
    public function getOriginDestFilterCriteria()
    {
        return $this->OriginDestFilterCriteria;
    }
    /**
     * Set OriginDestFilterCriteria value
     * @param \StructType\OriginDestFilterCriteriaType $originDestFilterCriteria
     * @return \StructType\FlightFilterCriteriaType
     */
    public function setOriginDestFilterCriteria(\StructType\OriginDestFilterCriteriaType $originDestFilterCriteria = null)
    {
        $this->OriginDestFilterCriteria = $originDestFilterCriteria;
        return $this;
    }
    /**
     * Get SegmentFilterCriteria value
     * @return \StructType\SegmentFilterCriteriaType[]|null
     */
    public function getSegmentFilterCriteria()
    {
        return $this->SegmentFilterCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setSegmentFilterCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSegmentFilterCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSegmentFilterCriteriaForArrayConstraintsFromSetSegmentFilterCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightFilterCriteriaTypeSegmentFilterCriteriaItem) {
            // validation for constraint: itemType
            if (!$flightFilterCriteriaTypeSegmentFilterCriteriaItem instanceof \StructType\SegmentFilterCriteriaType) {
                $invalidValues[] = is_object($flightFilterCriteriaTypeSegmentFilterCriteriaItem) ? get_class($flightFilterCriteriaTypeSegmentFilterCriteriaItem) : sprintf('%s(%s)', gettype($flightFilterCriteriaTypeSegmentFilterCriteriaItem), var_export($flightFilterCriteriaTypeSegmentFilterCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SegmentFilterCriteria property can only contain items of type \StructType\SegmentFilterCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SegmentFilterCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SegmentFilterCriteriaType[] $segmentFilterCriteria
     * @return \StructType\FlightFilterCriteriaType
     */
    public function setSegmentFilterCriteria(array $segmentFilterCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($segmentFilterCriteriaArrayErrorMessage = self::validateSegmentFilterCriteriaForArrayConstraintsFromSetSegmentFilterCriteria($segmentFilterCriteria))) {
            throw new \InvalidArgumentException($segmentFilterCriteriaArrayErrorMessage, __LINE__);
        }
        $this->SegmentFilterCriteria = $segmentFilterCriteria;
        return $this;
    }
    /**
     * Add item to SegmentFilterCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SegmentFilterCriteriaType $item
     * @return \StructType\FlightFilterCriteriaType
     */
    public function addToSegmentFilterCriteria(\StructType\SegmentFilterCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SegmentFilterCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The SegmentFilterCriteria property can only contain items of type \StructType\SegmentFilterCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SegmentFilterCriteria[] = $item;
        return $this;
    }
}
