<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FiledIn StructType
 * Meta information extracted from the WSDL
 * - documentation: This group represents fares filed in a currency different from the currency of a point of sale. The content elements represent the original currency and amount as filed.
 * @subpackage Structs
 */
class FiledIn extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Amount
     * @var \StructType\Amount
     */
    public $Amount;
    /**
     * The NUCAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NUCAmount
     */
    public $NUCAmount;
    /**
     * Constructor method for FiledIn
     * @uses FiledIn::setCurrencyCode()
     * @uses FiledIn::setAmount()
     * @uses FiledIn::setNUCAmount()
     * @param string $currencyCode
     * @param \StructType\Amount $amount
     * @param \StructType\NUCAmount $nUCAmount
     */
    public function __construct($currencyCode = null, \StructType\Amount $amount = null, \StructType\NUCAmount $nUCAmount = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setAmount($amount)
            ->setNUCAmount($nUCAmount);
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\FiledIn
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return \StructType\Amount|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\Amount $amount
     * @return \StructType\FiledIn
     */
    public function setAmount(\StructType\Amount $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get NUCAmount value
     * @return \StructType\NUCAmount|null
     */
    public function getNUCAmount()
    {
        return $this->NUCAmount;
    }
    /**
     * Set NUCAmount value
     * @param \StructType\NUCAmount $nUCAmount
     * @return \StructType\FiledIn
     */
    public function setNUCAmount(\StructType\NUCAmount $nUCAmount = null)
    {
        $this->NUCAmount = $nUCAmount;
        return $this;
    }
}
