<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Amount added on to a charge for a specific product, purpose, or service.
 * @subpackage Structs
 */
class FeeType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Fee Amount. Example: 500 USD
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The ApproximateInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this fee is approximate. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ApproximateInd;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Fee/ surcharge Description. Example: U.S Customs User Fee | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The DesigText
     * Meta information extracted from the WSDL
     * - documentation: Fee designator code. Example: USC
     * - base: xs:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $DesigText;
    /**
     * The GuaranteeTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time the fee of an offer item is guaranteed. In the absence of the fee guarantee time limit, the fee is not guaranteed. Upon expiry, the fee may no longer be guaranteed and either a new shopping process should begin, or
     * the offer should be repriced resulting in a new Offer. Should the fee guarantee time limit extend beyond Order creation, the remaining length of time persists into the corresponding Order Item. The airline can increase the remaining length of time
     * beyond the original time limit should they wish to. This field should only be used when the Airline indicates that a Price Guarantee is available.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GuaranteeTimeLimitDateTime;
    /**
     * The LocalAmount
     * Meta information extracted from the WSDL
     * - documentation: Fee amount specified in a local currency. Example: 7 CHF
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $LocalAmount;
    /**
     * The MaximumAmount
     * Meta information extracted from the WSDL
     * - documentation: Stores an Maximum fee amount which will be charged when a variable fee amount is effective.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $MaximumAmount;
    /**
     * The MinimumAmount
     * Meta information extracted from the WSDL
     * - documentation: Stores an Minimum fee amount which will be charged when a variable fee amount is effective.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $MinimumAmount;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: Stores a percentage which will be used to determine the Fee to be charged in conjunction or not with minimum and maximum amounts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Percent;
    /**
     * The RefundInd
     * Meta information extracted from the WSDL
     * - documentation: When true, fee amount is refundable. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RefundInd;
    /**
     * Constructor method for FeeType
     * @uses FeeType::setAmount()
     * @uses FeeType::setApproximateInd()
     * @uses FeeType::setDescText()
     * @uses FeeType::setDesigText()
     * @uses FeeType::setGuaranteeTimeLimitDateTime()
     * @uses FeeType::setLocalAmount()
     * @uses FeeType::setMaximumAmount()
     * @uses FeeType::setMinimumAmount()
     * @uses FeeType::setPercent()
     * @uses FeeType::setRefundInd()
     * @param \StructType\AmountType $amount
     * @param bool $approximateInd
     * @param string $descText
     * @param string $desigText
     * @param string $guaranteeTimeLimitDateTime
     * @param \StructType\AmountType $localAmount
     * @param \StructType\AmountType $maximumAmount
     * @param \StructType\AmountType $minimumAmount
     * @param float $percent
     * @param bool $refundInd
     */
    public function __construct(\StructType\AmountType $amount = null, $approximateInd = null, $descText = null, $desigText = null, $guaranteeTimeLimitDateTime = null, \StructType\AmountType $localAmount = null, \StructType\AmountType $maximumAmount = null, \StructType\AmountType $minimumAmount = null, $percent = null, $refundInd = null)
    {
        $this
            ->setAmount($amount)
            ->setApproximateInd($approximateInd)
            ->setDescText($descText)
            ->setDesigText($desigText)
            ->setGuaranteeTimeLimitDateTime($guaranteeTimeLimitDateTime)
            ->setLocalAmount($localAmount)
            ->setMaximumAmount($maximumAmount)
            ->setMinimumAmount($minimumAmount)
            ->setPercent($percent)
            ->setRefundInd($refundInd);
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\FeeType
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ApproximateInd value
     * @return bool|null
     */
    public function getApproximateInd()
    {
        return $this->ApproximateInd;
    }
    /**
     * Set ApproximateInd value
     * @param bool $approximateInd
     * @return \StructType\FeeType
     */
    public function setApproximateInd($approximateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($approximateInd) && !is_bool($approximateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approximateInd, true), gettype($approximateInd)), __LINE__);
        }
        $this->ApproximateInd = $approximateInd;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\FeeType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get DesigText value
     * @return string|null
     */
    public function getDesigText()
    {
        return $this->DesigText;
    }
    /**
     * Set DesigText value
     * @param string $desigText
     * @return \StructType\FeeType
     */
    public function setDesigText($desigText = null)
    {
        // validation for constraint: string
        if (!is_null($desigText) && !is_string($desigText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desigText, true), gettype($desigText)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($desigText) && mb_strlen($desigText) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($desigText)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($desigText) && mb_strlen($desigText) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($desigText)), __LINE__);
        }
        $this->DesigText = $desigText;
        return $this;
    }
    /**
     * Get GuaranteeTimeLimitDateTime value
     * @return string|null
     */
    public function getGuaranteeTimeLimitDateTime()
    {
        return $this->GuaranteeTimeLimitDateTime;
    }
    /**
     * Set GuaranteeTimeLimitDateTime value
     * @param string $guaranteeTimeLimitDateTime
     * @return \StructType\FeeType
     */
    public function setGuaranteeTimeLimitDateTime($guaranteeTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeTimeLimitDateTime) && !is_string($guaranteeTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeTimeLimitDateTime, true), gettype($guaranteeTimeLimitDateTime)), __LINE__);
        }
        $this->GuaranteeTimeLimitDateTime = $guaranteeTimeLimitDateTime;
        return $this;
    }
    /**
     * Get LocalAmount value
     * @return \StructType\AmountType|null
     */
    public function getLocalAmount()
    {
        return $this->LocalAmount;
    }
    /**
     * Set LocalAmount value
     * @param \StructType\AmountType $localAmount
     * @return \StructType\FeeType
     */
    public function setLocalAmount(\StructType\AmountType $localAmount = null)
    {
        $this->LocalAmount = $localAmount;
        return $this;
    }
    /**
     * Get MaximumAmount value
     * @return \StructType\AmountType|null
     */
    public function getMaximumAmount()
    {
        return $this->MaximumAmount;
    }
    /**
     * Set MaximumAmount value
     * @param \StructType\AmountType $maximumAmount
     * @return \StructType\FeeType
     */
    public function setMaximumAmount(\StructType\AmountType $maximumAmount = null)
    {
        $this->MaximumAmount = $maximumAmount;
        return $this;
    }
    /**
     * Get MinimumAmount value
     * @return \StructType\AmountType|null
     */
    public function getMinimumAmount()
    {
        return $this->MinimumAmount;
    }
    /**
     * Set MinimumAmount value
     * @param \StructType\AmountType $minimumAmount
     * @return \StructType\FeeType
     */
    public function setMinimumAmount(\StructType\AmountType $minimumAmount = null)
    {
        $this->MinimumAmount = $minimumAmount;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\FeeType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get RefundInd value
     * @return bool|null
     */
    public function getRefundInd()
    {
        return $this->RefundInd;
    }
    /**
     * Set RefundInd value
     * @param bool $refundInd
     * @return \StructType\FeeType
     */
    public function setRefundInd($refundInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($refundInd) && !is_bool($refundInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refundInd, true), gettype($refundInd)), __LINE__);
        }
        $this->RefundInd = $refundInd;
        return $this;
    }
}
