<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRuleType StructType
 * Meta information extracted from the WSDL
 * - documentation: Special purchasing rules and restrictions used to differentiate fare levels from one another.
 * @subpackage Structs
 */
class FareRuleType extends AbstractStructBase
{
    /**
     * The InstantPurchaseTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Instant purchase type code, Ex: CC (Ticketless purchase immediately charged to credit card) NO (Not an instant purchase) TT (Simultaneous with time of ticketing) Encoding scheme: IATA PADIS Codeset IPT - Instant Purchase Type | A
     * code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstantPurchaseTypeCode;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Supplementary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Remark[]
     */
    public $Remark;
    /**
     * The RuleCode
     * Meta information extracted from the WSDL
     * - documentation: Fare category number as defined by ATPCO. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RuleCode;
    /**
     * The TicketlessInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, the Fare can be purchased without issuing a ticket. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $TicketlessInd;
    /**
     * Constructor method for FareRuleType
     * @uses FareRuleType::setInstantPurchaseTypeCode()
     * @uses FareRuleType::setRemark()
     * @uses FareRuleType::setRuleCode()
     * @uses FareRuleType::setTicketlessInd()
     * @param string $instantPurchaseTypeCode
     * @param \StructType\Remark[] $remark
     * @param string $ruleCode
     * @param bool $ticketlessInd
     */
    public function __construct($instantPurchaseTypeCode = null, array $remark = array(), $ruleCode = null, $ticketlessInd = null)
    {
        $this
            ->setInstantPurchaseTypeCode($instantPurchaseTypeCode)
            ->setRemark($remark)
            ->setRuleCode($ruleCode)
            ->setTicketlessInd($ticketlessInd);
    }
    /**
     * Get InstantPurchaseTypeCode value
     * @return string|null
     */
    public function getInstantPurchaseTypeCode()
    {
        return $this->InstantPurchaseTypeCode;
    }
    /**
     * Set InstantPurchaseTypeCode value
     * @param string $instantPurchaseTypeCode
     * @return \StructType\FareRuleType
     */
    public function setInstantPurchaseTypeCode($instantPurchaseTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($instantPurchaseTypeCode) && !is_string($instantPurchaseTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instantPurchaseTypeCode, true), gettype($instantPurchaseTypeCode)), __LINE__);
        }
        $this->InstantPurchaseTypeCode = $instantPurchaseTypeCode;
        return $this;
    }
    /**
     * Get Remark value
     * @return \StructType\Remark[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareRuleTypeRemarkItem) {
            // validation for constraint: itemType
            if (!$fareRuleTypeRemarkItem instanceof \StructType\Remark) {
                $invalidValues[] = is_object($fareRuleTypeRemarkItem) ? get_class($fareRuleTypeRemarkItem) : sprintf('%s(%s)', gettype($fareRuleTypeRemarkItem), var_export($fareRuleTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type \StructType\Remark, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\Remark[] $remark
     * @return \StructType\FareRuleType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\Remark $item
     * @return \StructType\FareRuleType
     */
    public function addToRemark(\StructType\Remark $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Remark) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type \StructType\Remark, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Get RuleCode value
     * @return string|null
     */
    public function getRuleCode()
    {
        return $this->RuleCode;
    }
    /**
     * Set RuleCode value
     * @param string $ruleCode
     * @return \StructType\FareRuleType
     */
    public function setRuleCode($ruleCode = null)
    {
        // validation for constraint: string
        if (!is_null($ruleCode) && !is_string($ruleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleCode, true), gettype($ruleCode)), __LINE__);
        }
        $this->RuleCode = $ruleCode;
        return $this;
    }
    /**
     * Get TicketlessInd value
     * @return bool|null
     */
    public function getTicketlessInd()
    {
        return $this->TicketlessInd;
    }
    /**
     * Set TicketlessInd value
     * @param bool $ticketlessInd
     * @return \StructType\FareRuleType
     */
    public function setTicketlessInd($ticketlessInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($ticketlessInd) && !is_bool($ticketlessInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ticketlessInd, true), gettype($ticketlessInd)), __LINE__);
        }
        $this->TicketlessInd = $ticketlessInd;
        return $this;
    }
}
