<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: To be used when requesting filed fare information as part of this request.
 * @subpackage Structs
 */
class FareRefType extends AbstractStructBase
{
    /**
     * The AirlineDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $AirlineDesigCode;
    /**
     * The Arrival
     * Meta information extracted from the WSDL
     * - documentation: This is a transport point location.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TransportPointType
     */
    public $Arrival;
    /**
     * The Dep
     * Meta information extracted from the WSDL
     * - documentation: This is a transport point location.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TransportPointType
     */
    public $Dep;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: Fare basis code. Example: Y26 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FareBasisCode;
    /**
     * The FareBasisAppCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates how the fare basis was applied. E.g. Requested, Ticketed, Other. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareBasisAppCode;
    /**
     * The FareIndCode
     * Meta information extracted from the WSDL
     * - documentation: Fare indicator code. Example: 1 (SYSTEM PRICED WITHOUT MANUAL INTERVENTION) Encoding Scheme: IATA PADIS Code List for data element 5387 - Price Type Qualifier | A code is a character string of letters, numbers, special characters
     * (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareIndCode;
    /**
     * The FareQualifier
     * Meta information extracted from the WSDL
     * - documentation: A negotiated program identifier ( e.g. CLID, Corporate codes ) to be passed between seller and retailer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProgramCriteriaType[]
     */
    public $FareQualifier;
    /**
     * The FareRefText
     * Meta information extracted from the WSDL
     * - documentation: Fare reference key, ex: PQ123456 | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareRefText;
    /**
     * The FareRuleTextCriteria
     * Meta information extracted from the WSDL
     * - documentation: Special purchasing rules and restrictions used to differentiate fare levels from one another.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareRuleTextCriteriaType[]
     */
    public $FareRuleTextCriteria;
    /**
     * The FareTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Fare Amount Type Code, ex: ADC (Additional Charge), IT (Tour Inclusive), NOADC (No additional charge). | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareTypeCode;
    /**
     * Constructor method for FareRefType
     * @uses FareRefType::setAirlineDesigCode()
     * @uses FareRefType::setArrival()
     * @uses FareRefType::setDep()
     * @uses FareRefType::setFareBasisCode()
     * @uses FareRefType::setFareBasisAppCode()
     * @uses FareRefType::setFareIndCode()
     * @uses FareRefType::setFareQualifier()
     * @uses FareRefType::setFareRefText()
     * @uses FareRefType::setFareRuleTextCriteria()
     * @uses FareRefType::setFareTypeCode()
     * @param string $airlineDesigCode
     * @param \StructType\TransportPointType $arrival
     * @param \StructType\TransportPointType $dep
     * @param string $fareBasisCode
     * @param string $fareBasisAppCode
     * @param string $fareIndCode
     * @param \StructType\ProgramCriteriaType[] $fareQualifier
     * @param string $fareRefText
     * @param \StructType\FareRuleTextCriteriaType[] $fareRuleTextCriteria
     * @param string $fareTypeCode
     */
    public function __construct($airlineDesigCode = null, \StructType\TransportPointType $arrival = null, \StructType\TransportPointType $dep = null, $fareBasisCode = null, $fareBasisAppCode = null, $fareIndCode = null, array $fareQualifier = array(), $fareRefText = null, array $fareRuleTextCriteria = array(), $fareTypeCode = null)
    {
        $this
            ->setAirlineDesigCode($airlineDesigCode)
            ->setArrival($arrival)
            ->setDep($dep)
            ->setFareBasisCode($fareBasisCode)
            ->setFareBasisAppCode($fareBasisAppCode)
            ->setFareIndCode($fareIndCode)
            ->setFareQualifier($fareQualifier)
            ->setFareRefText($fareRefText)
            ->setFareRuleTextCriteria($fareRuleTextCriteria)
            ->setFareTypeCode($fareTypeCode);
    }
    /**
     * Get AirlineDesigCode value
     * @return string
     */
    public function getAirlineDesigCode()
    {
        return $this->AirlineDesigCode;
    }
    /**
     * Set AirlineDesigCode value
     * @param string $airlineDesigCode
     * @return \StructType\FareRefType
     */
    public function setAirlineDesigCode($airlineDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineDesigCode) && !is_string($airlineDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineDesigCode, true), gettype($airlineDesigCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($airlineDesigCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $airlineDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($airlineDesigCode, true)), __LINE__);
        }
        $this->AirlineDesigCode = $airlineDesigCode;
        return $this;
    }
    /**
     * Get Arrival value
     * @return \StructType\TransportPointType
     */
    public function getArrival()
    {
        return $this->Arrival;
    }
    /**
     * Set Arrival value
     * @param \StructType\TransportPointType $arrival
     * @return \StructType\FareRefType
     */
    public function setArrival(\StructType\TransportPointType $arrival = null)
    {
        $this->Arrival = $arrival;
        return $this;
    }
    /**
     * Get Dep value
     * @return \StructType\TransportPointType
     */
    public function getDep()
    {
        return $this->Dep;
    }
    /**
     * Set Dep value
     * @param \StructType\TransportPointType $dep
     * @return \StructType\FareRefType
     */
    public function setDep(\StructType\TransportPointType $dep = null)
    {
        $this->Dep = $dep;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\FareRefType
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get FareBasisAppCode value
     * @return string|null
     */
    public function getFareBasisAppCode()
    {
        return $this->FareBasisAppCode;
    }
    /**
     * Set FareBasisAppCode value
     * @param string $fareBasisAppCode
     * @return \StructType\FareRefType
     */
    public function setFareBasisAppCode($fareBasisAppCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisAppCode) && !is_string($fareBasisAppCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisAppCode, true), gettype($fareBasisAppCode)), __LINE__);
        }
        $this->FareBasisAppCode = $fareBasisAppCode;
        return $this;
    }
    /**
     * Get FareIndCode value
     * @return string|null
     */
    public function getFareIndCode()
    {
        return $this->FareIndCode;
    }
    /**
     * Set FareIndCode value
     * @param string $fareIndCode
     * @return \StructType\FareRefType
     */
    public function setFareIndCode($fareIndCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareIndCode) && !is_string($fareIndCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareIndCode, true), gettype($fareIndCode)), __LINE__);
        }
        $this->FareIndCode = $fareIndCode;
        return $this;
    }
    /**
     * Get FareQualifier value
     * @return \StructType\ProgramCriteriaType[]|null
     */
    public function getFareQualifier()
    {
        return $this->FareQualifier;
    }
    /**
     * This method is responsible for validating the values passed to the setFareQualifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareQualifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareQualifierForArrayConstraintsFromSetFareQualifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareRefTypeFareQualifierItem) {
            // validation for constraint: itemType
            if (!$fareRefTypeFareQualifierItem instanceof \StructType\ProgramCriteriaType) {
                $invalidValues[] = is_object($fareRefTypeFareQualifierItem) ? get_class($fareRefTypeFareQualifierItem) : sprintf('%s(%s)', gettype($fareRefTypeFareQualifierItem), var_export($fareRefTypeFareQualifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareQualifier property can only contain items of type \StructType\ProgramCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareQualifier value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgramCriteriaType[] $fareQualifier
     * @return \StructType\FareRefType
     */
    public function setFareQualifier(array $fareQualifier = array())
    {
        // validation for constraint: array
        if ('' !== ($fareQualifierArrayErrorMessage = self::validateFareQualifierForArrayConstraintsFromSetFareQualifier($fareQualifier))) {
            throw new \InvalidArgumentException($fareQualifierArrayErrorMessage, __LINE__);
        }
        $this->FareQualifier = $fareQualifier;
        return $this;
    }
    /**
     * Add item to FareQualifier value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgramCriteriaType $item
     * @return \StructType\FareRefType
     */
    public function addToFareQualifier(\StructType\ProgramCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProgramCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The FareQualifier property can only contain items of type \StructType\ProgramCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareQualifier[] = $item;
        return $this;
    }
    /**
     * Get FareRefText value
     * @return string|null
     */
    public function getFareRefText()
    {
        return $this->FareRefText;
    }
    /**
     * Set FareRefText value
     * @param string $fareRefText
     * @return \StructType\FareRefType
     */
    public function setFareRefText($fareRefText = null)
    {
        // validation for constraint: string
        if (!is_null($fareRefText) && !is_string($fareRefText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareRefText, true), gettype($fareRefText)), __LINE__);
        }
        $this->FareRefText = $fareRefText;
        return $this;
    }
    /**
     * Get FareRuleTextCriteria value
     * @return \StructType\FareRuleTextCriteriaType[]|null
     */
    public function getFareRuleTextCriteria()
    {
        return $this->FareRuleTextCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setFareRuleTextCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareRuleTextCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareRuleTextCriteriaForArrayConstraintsFromSetFareRuleTextCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareRefTypeFareRuleTextCriteriaItem) {
            // validation for constraint: itemType
            if (!$fareRefTypeFareRuleTextCriteriaItem instanceof \StructType\FareRuleTextCriteriaType) {
                $invalidValues[] = is_object($fareRefTypeFareRuleTextCriteriaItem) ? get_class($fareRefTypeFareRuleTextCriteriaItem) : sprintf('%s(%s)', gettype($fareRefTypeFareRuleTextCriteriaItem), var_export($fareRefTypeFareRuleTextCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareRuleTextCriteria property can only contain items of type \StructType\FareRuleTextCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareRuleTextCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRuleTextCriteriaType[] $fareRuleTextCriteria
     * @return \StructType\FareRefType
     */
    public function setFareRuleTextCriteria(array $fareRuleTextCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($fareRuleTextCriteriaArrayErrorMessage = self::validateFareRuleTextCriteriaForArrayConstraintsFromSetFareRuleTextCriteria($fareRuleTextCriteria))) {
            throw new \InvalidArgumentException($fareRuleTextCriteriaArrayErrorMessage, __LINE__);
        }
        $this->FareRuleTextCriteria = $fareRuleTextCriteria;
        return $this;
    }
    /**
     * Add item to FareRuleTextCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRuleTextCriteriaType $item
     * @return \StructType\FareRefType
     */
    public function addToFareRuleTextCriteria(\StructType\FareRuleTextCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareRuleTextCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The FareRuleTextCriteria property can only contain items of type \StructType\FareRuleTextCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareRuleTextCriteria[] = $item;
        return $this;
    }
    /**
     * Get FareTypeCode value
     * @return string|null
     */
    public function getFareTypeCode()
    {
        return $this->FareTypeCode;
    }
    /**
     * Set FareTypeCode value
     * @param string $fareTypeCode
     * @return \StructType\FareRefType
     */
    public function setFareTypeCode($fareTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareTypeCode) && !is_string($fareTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareTypeCode, true), gettype($fareTypeCode)), __LINE__);
        }
        $this->FareTypeCode = $fareTypeCode;
        return $this;
    }
}
