<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExistingOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: Existing Order is a uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and
 * services that are not necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each
 * passenger in an Order may hold different sets of order items at different prices.
 * @subpackage Structs
 */
class ExistingOrderType extends AbstractStructBase
{
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Order across several messages. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The AffectedOrderItem
     * Meta information extracted from the WSDL
     * - documentation: Contains affected existing order items and related services to retain that will be impacted by any new offers in the message. The primary use case is when an existing order item is to be deleted or partial deletion either with a
     * replacement in a new offer or a an offer to be used for the deletion.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AffectedOrderItemRequestType[]
     */
    public $AffectedOrderItem;
    /**
     * Constructor method for ExistingOrderType
     * @uses ExistingOrderType::setOrderID()
     * @uses ExistingOrderType::setOwnerCode()
     * @uses ExistingOrderType::setAffectedOrderItem()
     * @param string $orderID
     * @param string $ownerCode
     * @param \StructType\AffectedOrderItemRequestType[] $affectedOrderItem
     */
    public function __construct($orderID = null, $ownerCode = null, array $affectedOrderItem = array())
    {
        $this
            ->setOrderID($orderID)
            ->setOwnerCode($ownerCode)
            ->setAffectedOrderItem($affectedOrderItem);
    }
    /**
     * Get OrderID value
     * @return string
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\ExistingOrderType
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\ExistingOrderType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get AffectedOrderItem value
     * @return \StructType\AffectedOrderItemRequestType[]|null
     */
    public function getAffectedOrderItem()
    {
        return $this->AffectedOrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setAffectedOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffectedOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffectedOrderItemForArrayConstraintsFromSetAffectedOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $existingOrderTypeAffectedOrderItemItem) {
            // validation for constraint: itemType
            if (!$existingOrderTypeAffectedOrderItemItem instanceof \StructType\AffectedOrderItemRequestType) {
                $invalidValues[] = is_object($existingOrderTypeAffectedOrderItemItem) ? get_class($existingOrderTypeAffectedOrderItemItem) : sprintf('%s(%s)', gettype($existingOrderTypeAffectedOrderItemItem), var_export($existingOrderTypeAffectedOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AffectedOrderItem property can only contain items of type \StructType\AffectedOrderItemRequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AffectedOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedOrderItemRequestType[] $affectedOrderItem
     * @return \StructType\ExistingOrderType
     */
    public function setAffectedOrderItem(array $affectedOrderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($affectedOrderItemArrayErrorMessage = self::validateAffectedOrderItemForArrayConstraintsFromSetAffectedOrderItem($affectedOrderItem))) {
            throw new \InvalidArgumentException($affectedOrderItemArrayErrorMessage, __LINE__);
        }
        $this->AffectedOrderItem = $affectedOrderItem;
        return $this;
    }
    /**
     * Add item to AffectedOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedOrderItemRequestType $item
     * @return \StructType\ExistingOrderType
     */
    public function addToAffectedOrderItem(\StructType\AffectedOrderItemRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedOrderItemRequestType) {
            throw new \InvalidArgumentException(sprintf('The AffectedOrderItem property can only contain items of type \StructType\AffectedOrderItemRequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AffectedOrderItem[] = $item;
        return $this;
    }
}
