<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocNotifCouponType StructType
 * Meta information extracted from the WSDL
 * - documentation: The portion of the Passenger Ticket and Baggage Check or Excess Baggage Ticket that indicates particular places between which the coupon is good for carriage.
 * @subpackage Structs
 */
class DocNotifCouponType extends AbstractStructBase
{
    /**
     * The CouponNumber
     * Meta information extracted from the WSDL
     * - documentation: Number assigned to the issued coupon. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CouponNumber;
    /**
     * The CouponStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Current status of the flight/ value coupon. Example: E (Exchanged/Reissued) | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CouponStatusCode;
    /**
     * The FlightDetails
     * Meta information extracted from the WSDL
     * - documentation: Transportation of a passenger on a Dated Operating Segment. - [Dated Marketing Segment] (All identifying fields) - [Order] Order ID - [Individual] (no identifier available)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxSegmentType
     */
    public $FlightDetails;
    /**
     * The OrderItem
     * Meta information extracted from the WSDL
     * - documentation: An Interline individually priced item within an Interline Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterlineOrderItemType
     */
    public $OrderItem;
    /**
     * The RFIC
     * Meta information extracted from the WSDL
     * - documentation: Reason For Issuance Code Examples: A (Air Transportation) C (Baggage) E (Airport Services) F (Merchandise) G (In-flight Services) | Enumeration values for Reason for Issuance codes. {codeListAgencyName}PADIS{/codeListAgencyName}
     * {codeListName}Special condition{/codeListName} {codeListIdentifier}4183{/codeListIdentifier} | Additional BDT to specify the reason for issuance code.
     * - base: RFIC_CodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9A-Z]{1,3}
     * @var string
     */
    public $RFIC;
    /**
     * The RFISC
     * Meta information extracted from the WSDL
     * - documentation: Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge) | Enumeration values for Reason for Issuance sub codes. Examples: 0CC (First Checked Bag). 0B1 (In-flight Entertainment). 0BX
     * (Lounge). 0B3 (Meal/ Beverage). 0B5 (Pre-reserved Seat Assignment). 0G6 (Priority Boarding). {codeListAgencyName}ATPCo{/codeListAgencyName} {codeListName}Optional Services Industry Sub Codes{/codeListName} | Additional BDT to specify the reason for
     * issuance sub code.
     * - base: RFISC_CodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFISC;
    /**
     * The ServiceDate
     * Meta information extracted from the WSDL
     * - documentation: Service date. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceDate;
    /**
     * The ServiceName
     * Meta information extracted from the WSDL
     * - documentation: Service name. Example: Lounge Pass | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceName;
    /**
     * The ServiceQty
     * Meta information extracted from the WSDL
     * - documentation: Number of services of the same type that are included in an EMD coupon. | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ServiceQty;
    /**
     * The ServiceTypeText
     * Meta information extracted from the WSDL
     * - documentation: Type of service. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceTypeText;
    /**
     * Constructor method for DocNotifCouponType
     * @uses DocNotifCouponType::setCouponNumber()
     * @uses DocNotifCouponType::setCouponStatusCode()
     * @uses DocNotifCouponType::setFlightDetails()
     * @uses DocNotifCouponType::setOrderItem()
     * @uses DocNotifCouponType::setRFIC()
     * @uses DocNotifCouponType::setRFISC()
     * @uses DocNotifCouponType::setServiceDate()
     * @uses DocNotifCouponType::setServiceName()
     * @uses DocNotifCouponType::setServiceQty()
     * @uses DocNotifCouponType::setServiceTypeText()
     * @param float $couponNumber
     * @param string $couponStatusCode
     * @param \StructType\PaxSegmentType $flightDetails
     * @param \StructType\InterlineOrderItemType $orderItem
     * @param string $rFIC
     * @param string $rFISC
     * @param string $serviceDate
     * @param string $serviceName
     * @param float $serviceQty
     * @param string $serviceTypeText
     */
    public function __construct($couponNumber = null, $couponStatusCode = null, \StructType\PaxSegmentType $flightDetails = null, \StructType\InterlineOrderItemType $orderItem = null, $rFIC = null, $rFISC = null, $serviceDate = null, $serviceName = null, $serviceQty = null, $serviceTypeText = null)
    {
        $this
            ->setCouponNumber($couponNumber)
            ->setCouponStatusCode($couponStatusCode)
            ->setFlightDetails($flightDetails)
            ->setOrderItem($orderItem)
            ->setRFIC($rFIC)
            ->setRFISC($rFISC)
            ->setServiceDate($serviceDate)
            ->setServiceName($serviceName)
            ->setServiceQty($serviceQty)
            ->setServiceTypeText($serviceTypeText);
    }
    /**
     * Get CouponNumber value
     * @return float
     */
    public function getCouponNumber()
    {
        return $this->CouponNumber;
    }
    /**
     * Set CouponNumber value
     * @param float $couponNumber
     * @return \StructType\DocNotifCouponType
     */
    public function setCouponNumber($couponNumber = null)
    {
        // validation for constraint: float
        if (!is_null($couponNumber) && !(is_float($couponNumber) || is_numeric($couponNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($couponNumber, true), gettype($couponNumber)), __LINE__);
        }
        $this->CouponNumber = $couponNumber;
        return $this;
    }
    /**
     * Get CouponStatusCode value
     * @return string|null
     */
    public function getCouponStatusCode()
    {
        return $this->CouponStatusCode;
    }
    /**
     * Set CouponStatusCode value
     * @param string $couponStatusCode
     * @return \StructType\DocNotifCouponType
     */
    public function setCouponStatusCode($couponStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($couponStatusCode) && !is_string($couponStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponStatusCode, true), gettype($couponStatusCode)), __LINE__);
        }
        $this->CouponStatusCode = $couponStatusCode;
        return $this;
    }
    /**
     * Get FlightDetails value
     * @return \StructType\PaxSegmentType|null
     */
    public function getFlightDetails()
    {
        return $this->FlightDetails;
    }
    /**
     * Set FlightDetails value
     * @param \StructType\PaxSegmentType $flightDetails
     * @return \StructType\DocNotifCouponType
     */
    public function setFlightDetails(\StructType\PaxSegmentType $flightDetails = null)
    {
        $this->FlightDetails = $flightDetails;
        return $this;
    }
    /**
     * Get OrderItem value
     * @return \StructType\InterlineOrderItemType|null
     */
    public function getOrderItem()
    {
        return $this->OrderItem;
    }
    /**
     * Set OrderItem value
     * @param \StructType\InterlineOrderItemType $orderItem
     * @return \StructType\DocNotifCouponType
     */
    public function setOrderItem(\StructType\InterlineOrderItemType $orderItem = null)
    {
        $this->OrderItem = $orderItem;
        return $this;
    }
    /**
     * Get RFIC value
     * @return string|null
     */
    public function getRFIC()
    {
        return $this->RFIC;
    }
    /**
     * Set RFIC value
     * @param string $rFIC
     * @return \StructType\DocNotifCouponType
     */
    public function setRFIC($rFIC = null)
    {
        // validation for constraint: string
        if (!is_null($rFIC) && !is_string($rFIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFIC, true), gettype($rFIC)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3})
        if (!is_null($rFIC) && !preg_match('/[0-9A-Z]{1,3}/', $rFIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}', var_export($rFIC, true)), __LINE__);
        }
        $this->RFIC = $rFIC;
        return $this;
    }
    /**
     * Get RFISC value
     * @return string|null
     */
    public function getRFISC()
    {
        return $this->RFISC;
    }
    /**
     * Set RFISC value
     * @param string $rFISC
     * @return \StructType\DocNotifCouponType
     */
    public function setRFISC($rFISC = null)
    {
        // validation for constraint: string
        if (!is_null($rFISC) && !is_string($rFISC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFISC, true), gettype($rFISC)), __LINE__);
        }
        $this->RFISC = $rFISC;
        return $this;
    }
    /**
     * Get ServiceDate value
     * @return string|null
     */
    public function getServiceDate()
    {
        return $this->ServiceDate;
    }
    /**
     * Set ServiceDate value
     * @param string $serviceDate
     * @return \StructType\DocNotifCouponType
     */
    public function setServiceDate($serviceDate = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDate) && !is_string($serviceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDate, true), gettype($serviceDate)), __LINE__);
        }
        $this->ServiceDate = $serviceDate;
        return $this;
    }
    /**
     * Get ServiceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->ServiceName;
    }
    /**
     * Set ServiceName value
     * @param string $serviceName
     * @return \StructType\DocNotifCouponType
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        $this->ServiceName = $serviceName;
        return $this;
    }
    /**
     * Get ServiceQty value
     * @return float|null
     */
    public function getServiceQty()
    {
        return $this->ServiceQty;
    }
    /**
     * Set ServiceQty value
     * @param float $serviceQty
     * @return \StructType\DocNotifCouponType
     */
    public function setServiceQty($serviceQty = null)
    {
        // validation for constraint: float
        if (!is_null($serviceQty) && !(is_float($serviceQty) || is_numeric($serviceQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($serviceQty, true), gettype($serviceQty)), __LINE__);
        }
        $this->ServiceQty = $serviceQty;
        return $this;
    }
    /**
     * Get ServiceTypeText value
     * @return string|null
     */
    public function getServiceTypeText()
    {
        return $this->ServiceTypeText;
    }
    /**
     * Set ServiceTypeText value
     * @param string $serviceTypeText
     * @return \StructType\DocNotifCouponType
     */
    public function setServiceTypeText($serviceTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($serviceTypeText) && !is_string($serviceTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceTypeText, true), gettype($serviceTypeText)), __LINE__);
        }
        $this->ServiceTypeText = $serviceTypeText;
        return $this;
    }
}
