<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributionChainLinkType StructType
 * Meta information extracted from the WSDL
 * - documentation: An organization playing a participating role in an instance of a distribution channel.
 * @subpackage Structs
 */
class DistributionChainLinkType extends AbstractStructBase
{
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - documentation: The number defining the position of the distribution chain link in the distribution chain indicating the order in which the organization participated. | An ordinal number is an assigned mathematical number that represents order or
     * sequence.
     * - base: xs:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Ordinal;
    /**
     * The OrgRole
     * Meta information extracted from the WSDL
     * - documentation: The distribution chain role performed by the participating organization. That is, the Seller (end buyer facing), the Distributor (an intermediary), or the Carrier (the Responsible Supplier). For clarity this is different to the
     * business model used by the participating organization, and the Nature of Business typically registered during incorporation as one of the organization's business activities. | The list of allowable roles in a distribution chain.
     * - base: DistributionChainRoleCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrgRole;
    /**
     * The ParticipatingOrg
     * Meta information extracted from the WSDL
     * - documentation: An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ParticipatingOrgType
     */
    public $ParticipatingOrg;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - documentation: The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactInfoType
     */
    public $ContactInfo;
    /**
     * The SalesAgent
     * Meta information extracted from the WSDL
     * - documentation: An individual conducting sales activities on behalf of a sales branch or organization.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SalesAgentType
     */
    public $SalesAgent;
    /**
     * The SalesBranch
     * Meta information extracted from the WSDL
     * - documentation: An organizational unit with responsibility over sales in a market, for a product or service and under any other specified criteria.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SalesBranchType
     */
    public $SalesBranch;
    /**
     * The VerifiablePresentation
     * Meta information extracted from the WSDL
     * - documentation: The root mode of the IATA Verifiable Presentation schema structure based on w3c Verifiable Credential Schema | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VerifiablePresentation;
    /**
     * Constructor method for DistributionChainLinkType
     * @uses DistributionChainLinkType::setOrdinal()
     * @uses DistributionChainLinkType::setOrgRole()
     * @uses DistributionChainLinkType::setParticipatingOrg()
     * @uses DistributionChainLinkType::setContactInfo()
     * @uses DistributionChainLinkType::setSalesAgent()
     * @uses DistributionChainLinkType::setSalesBranch()
     * @uses DistributionChainLinkType::setVerifiablePresentation()
     * @param int $ordinal
     * @param string $orgRole
     * @param \StructType\ParticipatingOrgType $participatingOrg
     * @param \StructType\ContactInfoType $contactInfo
     * @param \StructType\SalesAgentType $salesAgent
     * @param \StructType\SalesBranchType $salesBranch
     * @param string $verifiablePresentation
     */
    public function __construct($ordinal = null, $orgRole = null, \StructType\ParticipatingOrgType $participatingOrg = null, \StructType\ContactInfoType $contactInfo = null, \StructType\SalesAgentType $salesAgent = null, \StructType\SalesBranchType $salesBranch = null, $verifiablePresentation = null)
    {
        $this
            ->setOrdinal($ordinal)
            ->setOrgRole($orgRole)
            ->setParticipatingOrg($participatingOrg)
            ->setContactInfo($contactInfo)
            ->setSalesAgent($salesAgent)
            ->setSalesBranch($salesBranch)
            ->setVerifiablePresentation($verifiablePresentation);
    }
    /**
     * Get Ordinal value
     * @return int
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \StructType\DistributionChainLinkType
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
    /**
     * Get OrgRole value
     * @return string
     */
    public function getOrgRole()
    {
        return $this->OrgRole;
    }
    /**
     * Set OrgRole value
     * @param string $orgRole
     * @return \StructType\DistributionChainLinkType
     */
    public function setOrgRole($orgRole = null)
    {
        // validation for constraint: string
        if (!is_null($orgRole) && !is_string($orgRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgRole, true), gettype($orgRole)), __LINE__);
        }
        $this->OrgRole = $orgRole;
        return $this;
    }
    /**
     * Get ParticipatingOrg value
     * @return \StructType\ParticipatingOrgType
     */
    public function getParticipatingOrg()
    {
        return $this->ParticipatingOrg;
    }
    /**
     * Set ParticipatingOrg value
     * @param \StructType\ParticipatingOrgType $participatingOrg
     * @return \StructType\DistributionChainLinkType
     */
    public function setParticipatingOrg(\StructType\ParticipatingOrgType $participatingOrg = null)
    {
        $this->ParticipatingOrg = $participatingOrg;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfoType|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\ContactInfoType $contactInfo
     * @return \StructType\DistributionChainLinkType
     */
    public function setContactInfo(\StructType\ContactInfoType $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get SalesAgent value
     * @return \StructType\SalesAgentType|null
     */
    public function getSalesAgent()
    {
        return $this->SalesAgent;
    }
    /**
     * Set SalesAgent value
     * @param \StructType\SalesAgentType $salesAgent
     * @return \StructType\DistributionChainLinkType
     */
    public function setSalesAgent(\StructType\SalesAgentType $salesAgent = null)
    {
        $this->SalesAgent = $salesAgent;
        return $this;
    }
    /**
     * Get SalesBranch value
     * @return \StructType\SalesBranchType|null
     */
    public function getSalesBranch()
    {
        return $this->SalesBranch;
    }
    /**
     * Set SalesBranch value
     * @param \StructType\SalesBranchType $salesBranch
     * @return \StructType\DistributionChainLinkType
     */
    public function setSalesBranch(\StructType\SalesBranchType $salesBranch = null)
    {
        $this->SalesBranch = $salesBranch;
        return $this;
    }
    /**
     * Get VerifiablePresentation value
     * @return string|null
     */
    public function getVerifiablePresentation()
    {
        return $this->VerifiablePresentation;
    }
    /**
     * Set VerifiablePresentation value
     * @param string $verifiablePresentation
     * @return \StructType\DistributionChainLinkType
     */
    public function setVerifiablePresentation($verifiablePresentation = null)
    {
        // validation for constraint: string
        if (!is_null($verifiablePresentation) && !is_string($verifiablePresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verifiablePresentation, true), gettype($verifiablePresentation)), __LINE__);
        }
        $this->VerifiablePresentation = $verifiablePresentation;
        return $this;
    }
}
