<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountContext StructType
 * Meta information extracted from the WSDL
 * - documentation: Contextual information to further describe something using a key-value pair.
 * @subpackage Structs
 */
class DiscountContext extends AbstractStructBase
{
    /**
     * The KeyText
     * Meta information extracted from the WSDL
     * - documentation: Name or ID of the Keyword. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * @var string
     */
    public $KeyText;
    /**
     * The PrefLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PrefLevel
     */
    public $PrefLevel;
    /**
     * The ValueText
     * Meta information extracted from the WSDL
     * - documentation: Value corresponding to the associated Keyword. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * @var string
     */
    public $ValueText;
    /**
     * Constructor method for DiscountContext
     * @uses DiscountContext::setKeyText()
     * @uses DiscountContext::setPrefLevel()
     * @uses DiscountContext::setValueText()
     * @param string $keyText
     * @param \StructType\PrefLevel $prefLevel
     * @param string $valueText
     */
    public function __construct($keyText = null, \StructType\PrefLevel $prefLevel = null, $valueText = null)
    {
        $this
            ->setKeyText($keyText)
            ->setPrefLevel($prefLevel)
            ->setValueText($valueText);
    }
    /**
     * Get KeyText value
     * @return string|null
     */
    public function getKeyText()
    {
        return $this->KeyText;
    }
    /**
     * Set KeyText value
     * @param string $keyText
     * @return \StructType\DiscountContext
     */
    public function setKeyText($keyText = null)
    {
        // validation for constraint: string
        if (!is_null($keyText) && !is_string($keyText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyText, true), gettype($keyText)), __LINE__);
        }
        $this->KeyText = $keyText;
        return $this;
    }
    /**
     * Get PrefLevel value
     * @return \StructType\PrefLevel|null
     */
    public function getPrefLevel()
    {
        return $this->PrefLevel;
    }
    /**
     * Set PrefLevel value
     * @param \StructType\PrefLevel $prefLevel
     * @return \StructType\DiscountContext
     */
    public function setPrefLevel(\StructType\PrefLevel $prefLevel = null)
    {
        $this->PrefLevel = $prefLevel;
        return $this;
    }
    /**
     * Get ValueText value
     * @return string|null
     */
    public function getValueText()
    {
        return $this->ValueText;
    }
    /**
     * Set ValueText value
     * @param string $valueText
     * @return \StructType\DiscountContext
     */
    public function setValueText($valueText = null)
    {
        // validation for constraint: string
        if (!is_null($valueText) && !is_string($valueText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueText, true), gettype($valueText)), __LINE__);
        }
        $this->ValueText = $valueText;
        return $this;
    }
}
