<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DisclosureType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information which should be made known.
 * @subpackage Structs
 */
class DisclosureType extends AbstractStructBase
{
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DescType[]
     */
    public $Desc;
    /**
     * The DisclosureID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a disclosure within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DisclosureID;
    /**
     * Constructor method for DisclosureType
     * @uses DisclosureType::setDesc()
     * @uses DisclosureType::setDisclosureID()
     * @param \StructType\DescType[] $desc
     * @param string $disclosureID
     */
    public function __construct(array $desc = array(), $disclosureID = null)
    {
        $this
            ->setDesc($desc)
            ->setDisclosureID($disclosureID);
    }
    /**
     * Get Desc value
     * @return \StructType\DescType[]
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * This method is responsible for validating the values passed to the setDesc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDesc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescForArrayConstraintsFromSetDesc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $disclosureTypeDescItem) {
            // validation for constraint: itemType
            if (!$disclosureTypeDescItem instanceof \StructType\DescType) {
                $invalidValues[] = is_object($disclosureTypeDescItem) ? get_class($disclosureTypeDescItem) : sprintf('%s(%s)', gettype($disclosureTypeDescItem), var_export($disclosureTypeDescItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType[] $desc
     * @return \StructType\DisclosureType
     */
    public function setDesc(array $desc = array())
    {
        // validation for constraint: array
        if ('' !== ($descArrayErrorMessage = self::validateDescForArrayConstraintsFromSetDesc($desc))) {
            throw new \InvalidArgumentException($descArrayErrorMessage, __LINE__);
        }
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Add item to Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType $item
     * @return \StructType\DisclosureType
     */
    public function addToDesc(\StructType\DescType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescType) {
            throw new \InvalidArgumentException(sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Desc[] = $item;
        return $this;
    }
    /**
     * Get DisclosureID value
     * @return string
     */
    public function getDisclosureID()
    {
        return $this->DisclosureID;
    }
    /**
     * Set DisclosureID value
     * @param string $disclosureID
     * @return \StructType\DisclosureType
     */
    public function setDisclosureID($disclosureID = null)
    {
        // validation for constraint: string
        if (!is_null($disclosureID) && !is_string($disclosureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disclosureID, true), gettype($disclosureID)), __LINE__);
        }
        $this->DisclosureID = $disclosureID;
        return $this;
    }
}
