<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DimensionAllowanceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Baggage dimension allowance with application information.
 * @subpackage Structs
 */
class DimensionAllowanceType extends AbstractStructBase
{
    /**
     * The LengthUnitOfMeasurement
     * Meta information extracted from the WSDL
     * - documentation: The unit of measurement of the bag defined as imperial or metric. | Specifies Length Unit code list.
     * - base: LengthUnitCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LengthUnitOfMeasurement;
    /**
     * The HeightMeasure
     * Meta information extracted from the WSDL
     * - documentation: The height of the bag defined in either imperial or metric. | A numeric value determining a length (linear dimension) along with the specified unit of measure.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $HeightMeasure;
    /**
     * The LengthMeasure
     * Meta information extracted from the WSDL
     * - documentation: The length of the bag defined in either imperial or metric. | A numeric value determining a length (linear dimension) along with the specified unit of measure.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $LengthMeasure;
    /**
     * The LinearMeasure
     * Meta information extracted from the WSDL
     * - documentation: Maximum dimensions value. Example: 62 Notes: Linear measurement = length + width + height | A numeric value determining a length (linear dimension) along with the specified unit of measure.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $LinearMeasure;
    /**
     * The WidthMeasure
     * Meta information extracted from the WSDL
     * - documentation: The width of the bag defined in either imperial or metric. | A numeric value determining a length (linear dimension) along with the specified unit of measure.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $WidthMeasure;
    /**
     * Constructor method for DimensionAllowanceType
     * @uses DimensionAllowanceType::setLengthUnitOfMeasurement()
     * @uses DimensionAllowanceType::setHeightMeasure()
     * @uses DimensionAllowanceType::setLengthMeasure()
     * @uses DimensionAllowanceType::setLinearMeasure()
     * @uses DimensionAllowanceType::setWidthMeasure()
     * @param string $lengthUnitOfMeasurement
     * @param float $heightMeasure
     * @param float $lengthMeasure
     * @param float $linearMeasure
     * @param float $widthMeasure
     */
    public function __construct($lengthUnitOfMeasurement = null, $heightMeasure = null, $lengthMeasure = null, $linearMeasure = null, $widthMeasure = null)
    {
        $this
            ->setLengthUnitOfMeasurement($lengthUnitOfMeasurement)
            ->setHeightMeasure($heightMeasure)
            ->setLengthMeasure($lengthMeasure)
            ->setLinearMeasure($linearMeasure)
            ->setWidthMeasure($widthMeasure);
    }
    /**
     * Get LengthUnitOfMeasurement value
     * @return string
     */
    public function getLengthUnitOfMeasurement()
    {
        return $this->LengthUnitOfMeasurement;
    }
    /**
     * Set LengthUnitOfMeasurement value
     * @param string $lengthUnitOfMeasurement
     * @return \StructType\DimensionAllowanceType
     */
    public function setLengthUnitOfMeasurement($lengthUnitOfMeasurement = null)
    {
        // validation for constraint: string
        if (!is_null($lengthUnitOfMeasurement) && !is_string($lengthUnitOfMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lengthUnitOfMeasurement, true), gettype($lengthUnitOfMeasurement)), __LINE__);
        }
        $this->LengthUnitOfMeasurement = $lengthUnitOfMeasurement;
        return $this;
    }
    /**
     * Get HeightMeasure value
     * @return float|null
     */
    public function getHeightMeasure()
    {
        return $this->HeightMeasure;
    }
    /**
     * Set HeightMeasure value
     * @param float $heightMeasure
     * @return \StructType\DimensionAllowanceType
     */
    public function setHeightMeasure($heightMeasure = null)
    {
        // validation for constraint: float
        if (!is_null($heightMeasure) && !(is_float($heightMeasure) || is_numeric($heightMeasure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($heightMeasure, true), gettype($heightMeasure)), __LINE__);
        }
        $this->HeightMeasure = $heightMeasure;
        return $this;
    }
    /**
     * Get LengthMeasure value
     * @return float|null
     */
    public function getLengthMeasure()
    {
        return $this->LengthMeasure;
    }
    /**
     * Set LengthMeasure value
     * @param float $lengthMeasure
     * @return \StructType\DimensionAllowanceType
     */
    public function setLengthMeasure($lengthMeasure = null)
    {
        // validation for constraint: float
        if (!is_null($lengthMeasure) && !(is_float($lengthMeasure) || is_numeric($lengthMeasure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lengthMeasure, true), gettype($lengthMeasure)), __LINE__);
        }
        $this->LengthMeasure = $lengthMeasure;
        return $this;
    }
    /**
     * Get LinearMeasure value
     * @return float|null
     */
    public function getLinearMeasure()
    {
        return $this->LinearMeasure;
    }
    /**
     * Set LinearMeasure value
     * @param float $linearMeasure
     * @return \StructType\DimensionAllowanceType
     */
    public function setLinearMeasure($linearMeasure = null)
    {
        // validation for constraint: float
        if (!is_null($linearMeasure) && !(is_float($linearMeasure) || is_numeric($linearMeasure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($linearMeasure, true), gettype($linearMeasure)), __LINE__);
        }
        $this->LinearMeasure = $linearMeasure;
        return $this;
    }
    /**
     * Get WidthMeasure value
     * @return float|null
     */
    public function getWidthMeasure()
    {
        return $this->WidthMeasure;
    }
    /**
     * Set WidthMeasure value
     * @param float $widthMeasure
     * @return \StructType\DimensionAllowanceType
     */
    public function setWidthMeasure($widthMeasure = null)
    {
        // validation for constraint: float
        if (!is_null($widthMeasure) && !(is_float($widthMeasure) || is_numeric($widthMeasure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($widthMeasure, true), gettype($widthMeasure)), __LINE__);
        }
        $this->WidthMeasure = $widthMeasure;
        return $this;
    }
}
