<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DifferentialFarePriceTypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: A differential specialization of an additional specified fare pricing such as 'Net' and 'Filed'. For 'Sell' or public amounts, use the Price in Fare Details.
 * @subpackage Structs
 */
class DifferentialFarePriceTypeType extends AbstractStructBase
{
    /**
     * The DifferentialPrice
     * Meta information extracted from the WSDL
     * - documentation: A specialization of price used for price differentials. Price is the amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DifferentialPriceType
     */
    public $DifferentialPrice;
    /**
     * The FarePriceTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the fare price provided is a filed amount, net amount, or a sell amount. | A fare price type.
     * - base: FarePriceTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FarePriceTypeCode;
    /**
     * Constructor method for DifferentialFarePriceTypeType
     * @uses DifferentialFarePriceTypeType::setDifferentialPrice()
     * @uses DifferentialFarePriceTypeType::setFarePriceTypeCode()
     * @param \StructType\DifferentialPriceType $differentialPrice
     * @param string $farePriceTypeCode
     */
    public function __construct(\StructType\DifferentialPriceType $differentialPrice = null, $farePriceTypeCode = null)
    {
        $this
            ->setDifferentialPrice($differentialPrice)
            ->setFarePriceTypeCode($farePriceTypeCode);
    }
    /**
     * Get DifferentialPrice value
     * @return \StructType\DifferentialPriceType
     */
    public function getDifferentialPrice()
    {
        return $this->DifferentialPrice;
    }
    /**
     * Set DifferentialPrice value
     * @param \StructType\DifferentialPriceType $differentialPrice
     * @return \StructType\DifferentialFarePriceTypeType
     */
    public function setDifferentialPrice(\StructType\DifferentialPriceType $differentialPrice = null)
    {
        $this->DifferentialPrice = $differentialPrice;
        return $this;
    }
    /**
     * Get FarePriceTypeCode value
     * @return string
     */
    public function getFarePriceTypeCode()
    {
        return $this->FarePriceTypeCode;
    }
    /**
     * Set FarePriceTypeCode value
     * @param string $farePriceTypeCode
     * @return \StructType\DifferentialFarePriceTypeType
     */
    public function setFarePriceTypeCode($farePriceTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($farePriceTypeCode) && !is_string($farePriceTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($farePriceTypeCode, true), gettype($farePriceTypeCode)), __LINE__);
        }
        $this->FarePriceTypeCode = $farePriceTypeCode;
        return $this;
    }
}
