<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Diagnostics StructType
 * Meta information extracted from the WSDL
 * - documentation: Offer diagnostics information.
 * @subpackage Structs
 */
class Diagnostics extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Diagnostic ID to track this offer. Example: 0D4E58C8
     * - use: required
     * @var string
     */
    public $ID;
    /**
     * The Diagnostic
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Diagnostic[]
     */
    public $Diagnostic;
    /**
     * Constructor method for Diagnostics
     * @uses Diagnostics::setID()
     * @uses Diagnostics::setDiagnostic()
     * @param string $iD
     * @param \StructType\Diagnostic[] $diagnostic
     */
    public function __construct($iD = null, array $diagnostic = array())
    {
        $this
            ->setID($iD)
            ->setDiagnostic($diagnostic);
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Diagnostics
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Diagnostic value
     * @return \StructType\Diagnostic[]|null
     */
    public function getDiagnostic()
    {
        return $this->Diagnostic;
    }
    /**
     * This method is responsible for validating the values passed to the setDiagnostic method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiagnostic method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiagnosticForArrayConstraintsFromSetDiagnostic(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $diagnosticsDiagnosticItem) {
            // validation for constraint: itemType
            if (!$diagnosticsDiagnosticItem instanceof \StructType\Diagnostic) {
                $invalidValues[] = is_object($diagnosticsDiagnosticItem) ? get_class($diagnosticsDiagnosticItem) : sprintf('%s(%s)', gettype($diagnosticsDiagnosticItem), var_export($diagnosticsDiagnosticItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Diagnostic property can only contain items of type \StructType\Diagnostic, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Diagnostic value
     * @throws \InvalidArgumentException
     * @param \StructType\Diagnostic[] $diagnostic
     * @return \StructType\Diagnostics
     */
    public function setDiagnostic(array $diagnostic = array())
    {
        // validation for constraint: array
        if ('' !== ($diagnosticArrayErrorMessage = self::validateDiagnosticForArrayConstraintsFromSetDiagnostic($diagnostic))) {
            throw new \InvalidArgumentException($diagnosticArrayErrorMessage, __LINE__);
        }
        $this->Diagnostic = $diagnostic;
        return $this;
    }
    /**
     * Add item to Diagnostic value
     * @throws \InvalidArgumentException
     * @param \StructType\Diagnostic $item
     * @return \StructType\Diagnostics
     */
    public function addToDiagnostic(\StructType\Diagnostic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Diagnostic) {
            throw new \InvalidArgumentException(sprintf('The Diagnostic property can only contain items of type \StructType\Diagnostic, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Diagnostic[] = $item;
        return $this;
    }
}
