<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Diagnostic StructType
 * @subpackage Structs
 */
class Diagnostic extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Unique ID. Example 6 | A data type for a Unique String Identifier constraint.
     * - base: xs:string
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The QueryDuration
     * Meta information extracted from the WSDL
     * - documentation: Denotes the time the query spent processing with pricing provider before response is returned
     * - minOccurs: 0
     * @var string
     */
    public $QueryDuration;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Pricing Provider Name
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Diagnostic
     * @uses Diagnostic::setID()
     * @uses Diagnostic::setQueryDuration()
     * @uses Diagnostic::setName()
     * @param string $iD
     * @param string $queryDuration
     * @param string $name
     */
    public function __construct($iD = null, $queryDuration = null, $name = null)
    {
        $this
            ->setID($iD)
            ->setQueryDuration($queryDuration)
            ->setName($name);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Diagnostic
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD) && mb_strlen($iD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get QueryDuration value
     * @return string|null
     */
    public function getQueryDuration()
    {
        return $this->QueryDuration;
    }
    /**
     * Set QueryDuration value
     * @param string $queryDuration
     * @return \StructType\Diagnostic
     */
    public function setQueryDuration($queryDuration = null)
    {
        // validation for constraint: string
        if (!is_null($queryDuration) && !is_string($queryDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryDuration, true), gettype($queryDuration)), __LINE__);
        }
        $this->QueryDuration = $queryDuration;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Diagnostic
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
