<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeviceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Device upon which the secure transaction will occur.
 * @subpackage Structs
 */
class DeviceType extends AbstractStructBase
{
    /**
     * The DeviceCode
     * Meta information extracted from the WSDL
     * - documentation: The device code from which the request was initiated. PADIS codeset TST. | The device from which the request was initiated. Examples: Agent Terminal, Web Browser, Mobile Device {codeListAgencyName}PADIS{/codeListAgencyName}
     * {codeListName}Touchpoint device type{/codeListName} {codeListIdentifier}TDT{/codeListIdentifier} | Touch Point Device Code BDT.
     * - base: TouchPointDeviceCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeviceCode;
    /**
     * The DeviceOwnerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the type of Owner. | Ownership Type Code
     * - base: OwnershipTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceOwnerTypeCode;
    /**
     * The PresenceTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the Presence of a customer. | Presence Type Code
     * - base: PresenceTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PresenceTypeCode;
    /**
     * Constructor method for DeviceType
     * @uses DeviceType::setDeviceCode()
     * @uses DeviceType::setDeviceOwnerTypeCode()
     * @uses DeviceType::setPresenceTypeCode()
     * @param string $deviceCode
     * @param string $deviceOwnerTypeCode
     * @param string $presenceTypeCode
     */
    public function __construct($deviceCode = null, $deviceOwnerTypeCode = null, $presenceTypeCode = null)
    {
        $this
            ->setDeviceCode($deviceCode)
            ->setDeviceOwnerTypeCode($deviceOwnerTypeCode)
            ->setPresenceTypeCode($presenceTypeCode);
    }
    /**
     * Get DeviceCode value
     * @return string
     */
    public function getDeviceCode()
    {
        return $this->DeviceCode;
    }
    /**
     * Set DeviceCode value
     * @param string $deviceCode
     * @return \StructType\DeviceType
     */
    public function setDeviceCode($deviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($deviceCode) && !is_string($deviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceCode, true), gettype($deviceCode)), __LINE__);
        }
        $this->DeviceCode = $deviceCode;
        return $this;
    }
    /**
     * Get DeviceOwnerTypeCode value
     * @return string|null
     */
    public function getDeviceOwnerTypeCode()
    {
        return $this->DeviceOwnerTypeCode;
    }
    /**
     * Set DeviceOwnerTypeCode value
     * @param string $deviceOwnerTypeCode
     * @return \StructType\DeviceType
     */
    public function setDeviceOwnerTypeCode($deviceOwnerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($deviceOwnerTypeCode) && !is_string($deviceOwnerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceOwnerTypeCode, true), gettype($deviceOwnerTypeCode)), __LINE__);
        }
        $this->DeviceOwnerTypeCode = $deviceOwnerTypeCode;
        return $this;
    }
    /**
     * Get PresenceTypeCode value
     * @return string|null
     */
    public function getPresenceTypeCode()
    {
        return $this->PresenceTypeCode;
    }
    /**
     * Set PresenceTypeCode value
     * @param string $presenceTypeCode
     * @return \StructType\DeviceType
     */
    public function setPresenceTypeCode($presenceTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($presenceTypeCode) && !is_string($presenceTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presenceTypeCode, true), gettype($presenceTypeCode)), __LINE__);
        }
        $this->PresenceTypeCode = $presenceTypeCode;
        return $this;
    }
}
