<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeviceLocationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Location of device
 * @subpackage Structs
 */
class DeviceLocationType extends AbstractStructBase
{
    /**
     * The City
     * Meta information extracted from the WSDL
     * - documentation: City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address, or metropolitan area)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CityType
     */
    public $City;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - documentation: A nation with its own government, occupying a particular territory.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CountryType
     */
    public $Country;
    /**
     * The GeospatialLocation
     * Meta information extracted from the WSDL
     * - documentation: A location with a spatial attribute, probably on the surface of the earth. For example: Longitude and Latitude
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeospatialLocationType
     */
    public $GeospatialLocation;
    /**
     * Constructor method for DeviceLocationType
     * @uses DeviceLocationType::setCity()
     * @uses DeviceLocationType::setCountry()
     * @uses DeviceLocationType::setGeospatialLocation()
     * @param \StructType\CityType $city
     * @param \StructType\CountryType $country
     * @param \StructType\GeospatialLocationType $geospatialLocation
     */
    public function __construct(\StructType\CityType $city = null, \StructType\CountryType $country = null, \StructType\GeospatialLocationType $geospatialLocation = null)
    {
        $this
            ->setCity($city)
            ->setCountry($country)
            ->setGeospatialLocation($geospatialLocation);
    }
    /**
     * Get City value
     * @return \StructType\CityType|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param \StructType\CityType $city
     * @return \StructType\DeviceLocationType
     */
    public function setCity(\StructType\CityType $city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\CountryType|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\CountryType $country
     * @return \StructType\DeviceLocationType
     */
    public function setCountry(\StructType\CountryType $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get GeospatialLocation value
     * @return \StructType\GeospatialLocationType|null
     */
    public function getGeospatialLocation()
    {
        return $this->GeospatialLocation;
    }
    /**
     * Set GeospatialLocation value
     * @param \StructType\GeospatialLocationType $geospatialLocation
     * @return \StructType\DeviceLocationType
     */
    public function setGeospatialLocation(\StructType\GeospatialLocationType $geospatialLocation = null)
    {
        $this->GeospatialLocation = $geospatialLocation;
        return $this;
    }
}
