<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestArrivalCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Customer's requested Destination arrival time and location.
 * @subpackage Structs
 */
class DestArrivalCriteriaType extends AbstractStructBase
{
    /**
     * The IATA_LocationCode
     * Meta information extracted from the WSDL
     * - documentation: IATA 3-letter code defining the city or airport code. | Enumeration set for the Location Code BDT. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Location code{/codeListName}
     * {enumerationURI}http://www.iata.org/publications/Pages/code-search.aspx{/enumerationURI} | Additional BDT to specify the codeset which defines the IATA airport or city codes.
     * - base: IATA_LocationCodeContentType
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IATA_LocationCode;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - documentation: The customer's requested arrival date. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Time
     * Meta information extracted from the WSDL
     * - documentation: The customer's requested departure time. | Time is a point in the 24 hour clock expressed in hours, minutes and seconds. It has no implicit reference to a time zone.
     * - base: xs:time
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Time;
    /**
     * The TimeAfterDuration
     * Meta information extracted from the WSDL
     * - documentation: Time tolerance measured in hours or days. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time units (Year, Month, Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeAfterDuration;
    /**
     * The TimeBeforeDuration
     * Meta information extracted from the WSDL
     * - documentation: Time tolerance measured in hours or days. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time units (Year, Month, Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeBeforeDuration;
    /**
     * Constructor method for DestArrivalCriteriaType
     * @uses DestArrivalCriteriaType::setIATA_LocationCode()
     * @uses DestArrivalCriteriaType::setDate()
     * @uses DestArrivalCriteriaType::setTime()
     * @uses DestArrivalCriteriaType::setTimeAfterDuration()
     * @uses DestArrivalCriteriaType::setTimeBeforeDuration()
     * @param string $iATA_LocationCode
     * @param string $date
     * @param string $time
     * @param string $timeAfterDuration
     * @param string $timeBeforeDuration
     */
    public function __construct($iATA_LocationCode = null, $date = null, $time = null, $timeAfterDuration = null, $timeBeforeDuration = null)
    {
        $this
            ->setIATA_LocationCode($iATA_LocationCode)
            ->setDate($date)
            ->setTime($time)
            ->setTimeAfterDuration($timeAfterDuration)
            ->setTimeBeforeDuration($timeBeforeDuration);
    }
    /**
     * Get IATA_LocationCode value
     * @return string
     */
    public function getIATA_LocationCode()
    {
        return $this->IATA_LocationCode;
    }
    /**
     * Set IATA_LocationCode value
     * @param string $iATA_LocationCode
     * @return \StructType\DestArrivalCriteriaType
     */
    public function setIATA_LocationCode($iATA_LocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($iATA_LocationCode) && !is_string($iATA_LocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA_LocationCode, true), gettype($iATA_LocationCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($iATA_LocationCode) && mb_strlen($iATA_LocationCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($iATA_LocationCode)), __LINE__);
        }
        $this->IATA_LocationCode = $iATA_LocationCode;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\DestArrivalCriteriaType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \StructType\DestArrivalCriteriaType
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get TimeAfterDuration value
     * @return string|null
     */
    public function getTimeAfterDuration()
    {
        return $this->TimeAfterDuration;
    }
    /**
     * Set TimeAfterDuration value
     * @param string $timeAfterDuration
     * @return \StructType\DestArrivalCriteriaType
     */
    public function setTimeAfterDuration($timeAfterDuration = null)
    {
        // validation for constraint: string
        if (!is_null($timeAfterDuration) && !is_string($timeAfterDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeAfterDuration, true), gettype($timeAfterDuration)), __LINE__);
        }
        $this->TimeAfterDuration = $timeAfterDuration;
        return $this;
    }
    /**
     * Get TimeBeforeDuration value
     * @return string|null
     */
    public function getTimeBeforeDuration()
    {
        return $this->TimeBeforeDuration;
    }
    /**
     * Set TimeBeforeDuration value
     * @param string $timeBeforeDuration
     * @return \StructType\DestArrivalCriteriaType
     */
    public function setTimeBeforeDuration($timeBeforeDuration = null)
    {
        // validation for constraint: string
        if (!is_null($timeBeforeDuration) && !is_string($timeBeforeDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeBeforeDuration, true), gettype($timeBeforeDuration)), __LINE__);
        }
        $this->TimeBeforeDuration = $timeBeforeDuration;
        return $this;
    }
}
