<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepType StructType
 * Meta information extracted from the WSDL
 * - documentation: Journey departure information related to the specified Order.
 * @subpackage Structs
 */
class DepType extends AbstractStructBase
{
    /**
     * The DepDate
     * Meta information extracted from the WSDL
     * - documentation: Departure date. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepDate;
    /**
     * The StationCode
     * Meta information extracted from the WSDL
     * - documentation: Departure station/airport. | An enumeration referring to iata publications. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Location code{/codeListName}
     * {enumerationURI}http://www.iata.org/publications/Pages/code-search.aspx{/enumerationURI} | An IATA Station code type
     * - base: IATA_StationCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StationCode;
    /**
     * Constructor method for DepType
     * @uses DepType::setDepDate()
     * @uses DepType::setStationCode()
     * @param string $depDate
     * @param string $stationCode
     */
    public function __construct($depDate = null, $stationCode = null)
    {
        $this
            ->setDepDate($depDate)
            ->setStationCode($stationCode);
    }
    /**
     * Get DepDate value
     * @return string
     */
    public function getDepDate()
    {
        return $this->DepDate;
    }
    /**
     * Set DepDate value
     * @param string $depDate
     * @return \StructType\DepType
     */
    public function setDepDate($depDate = null)
    {
        // validation for constraint: string
        if (!is_null($depDate) && !is_string($depDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depDate, true), gettype($depDate)), __LINE__);
        }
        $this->DepDate = $depDate;
        return $this;
    }
    /**
     * Get StationCode value
     * @return string
     */
    public function getStationCode()
    {
        return $this->StationCode;
    }
    /**
     * Set StationCode value
     * @param string $stationCode
     * @return \StructType\DepType
     */
    public function setStationCode($stationCode = null)
    {
        // validation for constraint: string
        if (!is_null($stationCode) && !is_string($stationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stationCode, true), gettype($stationCode)), __LINE__);
        }
        $this->StationCode = $stationCode;
        return $this;
    }
}
