<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedOperatingLegType StructType
 * Meta information extracted from the WSDL
 * - documentation: The nonstop operation of a transport vehicle between the departure station and the arrival station. Can be used for aircrafts as well as other transport vehicles such as train or bus etc.
 * @subpackage Structs
 */
class DatedOperatingLegType extends AbstractStructBase
{
    /**
     * The Arrival
     * Meta information extracted from the WSDL
     * - documentation: This is a transport point location.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TransportPointType
     */
    public $Arrival;
    /**
     * The DatedOperatingLegID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a leg within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DatedOperatingLegID;
    /**
     * The Dep
     * Meta information extracted from the WSDL
     * - documentation: This is a transport point location.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TransportPointType
     */
    public $Dep;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The CarrierAircraftType
     * Meta information extracted from the WSDL
     * - documentation: Carrier defined internal grouping of aircrafts with the same form, function and specification.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierAircraftTypeType
     */
    public $CarrierAircraftType;
    /**
     * The ChangeofGaugeInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, indicates a Change of Gauge will take place between the current leg and that which immediately precedes it. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a
     * property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ChangeofGaugeInd;
    /**
     * The DistanceMeasure
     * Meta information extracted from the WSDL
     * - documentation: Total distance between the beginning and end stations of a leg, measured by the great circle of the earth.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeasureType
     */
    public $DistanceMeasure;
    /**
     * The IATA_AircraftType
     * Meta information extracted from the WSDL
     * - documentation: Grouping of aircrafts with the same form, function and specification, currently flown, or soon to be flown. Possible types are defined in the IATA SSIM. The same type may include aircrafts with different technical specifications such
     * as engines, range, cockpit configuration. Business Identifier Fields: - IATA Aircraft Type Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IATA_AircraftTypeType
     */
    public $IATA_AircraftType;
    /**
     * The OnGroundDuration
     * Meta information extracted from the WSDL
     * - documentation: Total time the aircraft remains on the Ground between this leg and the leg which immediately precedes it. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time
     * units (Year, Month, Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OnGroundDuration;
    /**
     * The RichMedia
     * Meta information extracted from the WSDL
     * - documentation: An external resource such as an Image, Video, PDF or other which is available for display
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MediaResourceRefType[]
     */
    public $RichMedia;
    /**
     * Constructor method for DatedOperatingLegType
     * @uses DatedOperatingLegType::setArrival()
     * @uses DatedOperatingLegType::setDatedOperatingLegID()
     * @uses DatedOperatingLegType::setDep()
     * @uses DatedOperatingLegType::setAirlineTaxonomy()
     * @uses DatedOperatingLegType::setCarrierAircraftType()
     * @uses DatedOperatingLegType::setChangeofGaugeInd()
     * @uses DatedOperatingLegType::setDistanceMeasure()
     * @uses DatedOperatingLegType::setIATA_AircraftType()
     * @uses DatedOperatingLegType::setOnGroundDuration()
     * @uses DatedOperatingLegType::setRichMedia()
     * @param \StructType\TransportPointType $arrival
     * @param string $datedOperatingLegID
     * @param \StructType\TransportPointType $dep
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param \StructType\CarrierAircraftTypeType $carrierAircraftType
     * @param bool $changeofGaugeInd
     * @param \StructType\MeasureType $distanceMeasure
     * @param \StructType\IATA_AircraftTypeType $iATA_AircraftType
     * @param string $onGroundDuration
     * @param \StructType\MediaResourceRefType[] $richMedia
     */
    public function __construct(\StructType\TransportPointType $arrival = null, $datedOperatingLegID = null, \StructType\TransportPointType $dep = null, array $airlineTaxonomy = array(), \StructType\CarrierAircraftTypeType $carrierAircraftType = null, $changeofGaugeInd = null, \StructType\MeasureType $distanceMeasure = null, \StructType\IATA_AircraftTypeType $iATA_AircraftType = null, $onGroundDuration = null, array $richMedia = array())
    {
        $this
            ->setArrival($arrival)
            ->setDatedOperatingLegID($datedOperatingLegID)
            ->setDep($dep)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setCarrierAircraftType($carrierAircraftType)
            ->setChangeofGaugeInd($changeofGaugeInd)
            ->setDistanceMeasure($distanceMeasure)
            ->setIATA_AircraftType($iATA_AircraftType)
            ->setOnGroundDuration($onGroundDuration)
            ->setRichMedia($richMedia);
    }
    /**
     * Get Arrival value
     * @return \StructType\TransportPointType
     */
    public function getArrival()
    {
        return $this->Arrival;
    }
    /**
     * Set Arrival value
     * @param \StructType\TransportPointType $arrival
     * @return \StructType\DatedOperatingLegType
     */
    public function setArrival(\StructType\TransportPointType $arrival = null)
    {
        $this->Arrival = $arrival;
        return $this;
    }
    /**
     * Get DatedOperatingLegID value
     * @return string
     */
    public function getDatedOperatingLegID()
    {
        return $this->DatedOperatingLegID;
    }
    /**
     * Set DatedOperatingLegID value
     * @param string $datedOperatingLegID
     * @return \StructType\DatedOperatingLegType
     */
    public function setDatedOperatingLegID($datedOperatingLegID = null)
    {
        // validation for constraint: string
        if (!is_null($datedOperatingLegID) && !is_string($datedOperatingLegID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datedOperatingLegID, true), gettype($datedOperatingLegID)), __LINE__);
        }
        $this->DatedOperatingLegID = $datedOperatingLegID;
        return $this;
    }
    /**
     * Get Dep value
     * @return \StructType\TransportPointType
     */
    public function getDep()
    {
        return $this->Dep;
    }
    /**
     * Set Dep value
     * @param \StructType\TransportPointType $dep
     * @return \StructType\DatedOperatingLegType
     */
    public function setDep(\StructType\TransportPointType $dep = null)
    {
        $this->Dep = $dep;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $datedOperatingLegTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$datedOperatingLegTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($datedOperatingLegTypeAirlineTaxonomyItem) ? get_class($datedOperatingLegTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($datedOperatingLegTypeAirlineTaxonomyItem), var_export($datedOperatingLegTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\DatedOperatingLegType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\DatedOperatingLegType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get CarrierAircraftType value
     * @return \StructType\CarrierAircraftTypeType|null
     */
    public function getCarrierAircraftType()
    {
        return $this->CarrierAircraftType;
    }
    /**
     * Set CarrierAircraftType value
     * @param \StructType\CarrierAircraftTypeType $carrierAircraftType
     * @return \StructType\DatedOperatingLegType
     */
    public function setCarrierAircraftType(\StructType\CarrierAircraftTypeType $carrierAircraftType = null)
    {
        $this->CarrierAircraftType = $carrierAircraftType;
        return $this;
    }
    /**
     * Get ChangeofGaugeInd value
     * @return bool|null
     */
    public function getChangeofGaugeInd()
    {
        return $this->ChangeofGaugeInd;
    }
    /**
     * Set ChangeofGaugeInd value
     * @param bool $changeofGaugeInd
     * @return \StructType\DatedOperatingLegType
     */
    public function setChangeofGaugeInd($changeofGaugeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($changeofGaugeInd) && !is_bool($changeofGaugeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($changeofGaugeInd, true), gettype($changeofGaugeInd)), __LINE__);
        }
        $this->ChangeofGaugeInd = $changeofGaugeInd;
        return $this;
    }
    /**
     * Get DistanceMeasure value
     * @return \StructType\MeasureType|null
     */
    public function getDistanceMeasure()
    {
        return $this->DistanceMeasure;
    }
    /**
     * Set DistanceMeasure value
     * @param \StructType\MeasureType $distanceMeasure
     * @return \StructType\DatedOperatingLegType
     */
    public function setDistanceMeasure(\StructType\MeasureType $distanceMeasure = null)
    {
        $this->DistanceMeasure = $distanceMeasure;
        return $this;
    }
    /**
     * Get IATA_AircraftType value
     * @return \StructType\IATA_AircraftTypeType|null
     */
    public function getIATA_AircraftType()
    {
        return $this->IATA_AircraftType;
    }
    /**
     * Set IATA_AircraftType value
     * @param \StructType\IATA_AircraftTypeType $iATA_AircraftType
     * @return \StructType\DatedOperatingLegType
     */
    public function setIATA_AircraftType(\StructType\IATA_AircraftTypeType $iATA_AircraftType = null)
    {
        $this->IATA_AircraftType = $iATA_AircraftType;
        return $this;
    }
    /**
     * Get OnGroundDuration value
     * @return string|null
     */
    public function getOnGroundDuration()
    {
        return $this->OnGroundDuration;
    }
    /**
     * Set OnGroundDuration value
     * @param string $onGroundDuration
     * @return \StructType\DatedOperatingLegType
     */
    public function setOnGroundDuration($onGroundDuration = null)
    {
        // validation for constraint: string
        if (!is_null($onGroundDuration) && !is_string($onGroundDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onGroundDuration, true), gettype($onGroundDuration)), __LINE__);
        }
        $this->OnGroundDuration = $onGroundDuration;
        return $this;
    }
    /**
     * Get RichMedia value
     * @return \StructType\MediaResourceRefType[]|null
     */
    public function getRichMedia()
    {
        return $this->RichMedia;
    }
    /**
     * This method is responsible for validating the values passed to the setRichMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRichMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRichMediaForArrayConstraintsFromSetRichMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $datedOperatingLegTypeRichMediaItem) {
            // validation for constraint: itemType
            if (!$datedOperatingLegTypeRichMediaItem instanceof \StructType\MediaResourceRefType) {
                $invalidValues[] = is_object($datedOperatingLegTypeRichMediaItem) ? get_class($datedOperatingLegTypeRichMediaItem) : sprintf('%s(%s)', gettype($datedOperatingLegTypeRichMediaItem), var_export($datedOperatingLegTypeRichMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @return \StructType\DatedOperatingLegType
     */
    public function setRichMedia(array $richMedia = array())
    {
        // validation for constraint: array
        if ('' !== ($richMediaArrayErrorMessage = self::validateRichMediaForArrayConstraintsFromSetRichMedia($richMedia))) {
            throw new \InvalidArgumentException($richMediaArrayErrorMessage, __LINE__);
        }
        $this->RichMedia = $richMedia;
        return $this;
    }
    /**
     * Add item to RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType $item
     * @return \StructType\DatedOperatingLegType
     */
    public function addToRichMedia(\StructType\MediaResourceRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaResourceRefType) {
            throw new \InvalidArgumentException(sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RichMedia[] = $item;
        return $this;
    }
}
