<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedOperatingLegRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Reference to a Dated Operating Leg within this message
 * @subpackage Structs
 */
class DatedOperatingLegRefType extends AbstractStructBase
{
    /**
     * The DatedOperatingLegRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Dated Operating Legs. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $DatedOperatingLegRefID;
    /**
     * Constructor method for DatedOperatingLegRefType
     * @uses DatedOperatingLegRefType::setDatedOperatingLegRefID()
     * @param string[] $datedOperatingLegRefID
     */
    public function __construct(array $datedOperatingLegRefID = array())
    {
        $this
            ->setDatedOperatingLegRefID($datedOperatingLegRefID);
    }
    /**
     * Get DatedOperatingLegRefID value
     * @return string[]
     */
    public function getDatedOperatingLegRefID()
    {
        return $this->DatedOperatingLegRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingLegRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $datedOperatingLegRefTypeDatedOperatingLegRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($datedOperatingLegRefTypeDatedOperatingLegRefIDItem)) {
                $invalidValues[] = is_object($datedOperatingLegRefTypeDatedOperatingLegRefIDItem) ? get_class($datedOperatingLegRefTypeDatedOperatingLegRefIDItem) : sprintf('%s(%s)', gettype($datedOperatingLegRefTypeDatedOperatingLegRefIDItem), var_export($datedOperatingLegRefTypeDatedOperatingLegRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string[] $datedOperatingLegRefID
     * @return \StructType\DatedOperatingLegRefType
     */
    public function setDatedOperatingLegRefID(array $datedOperatingLegRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingLegRefIDArrayErrorMessage = self::validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID($datedOperatingLegRefID))) {
            throw new \InvalidArgumentException($datedOperatingLegRefIDArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingLegRefID = $datedOperatingLegRefID;
        return $this;
    }
    /**
     * Add item to DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DatedOperatingLegRefType
     */
    public function addToDatedOperatingLegRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingLegRefID[] = $item;
        return $this;
    }
}
