<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedOperatingLegListType StructType
 * Meta information extracted from the WSDL
 * - documentation: A list of dated operating legs used in the contained message.
 * @subpackage Structs
 */
class DatedOperatingLegListType extends AbstractStructBase
{
    /**
     * The DatedOperatingLeg
     * Meta information extracted from the WSDL
     * - documentation: The nonstop operation of a transport vehicle between the departure station and the arrival station. Can be used for aircrafts as well as other transport vehicles such as train or bus etc.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DatedOperatingLegType[]
     */
    public $DatedOperatingLeg;
    /**
     * Constructor method for DatedOperatingLegListType
     * @uses DatedOperatingLegListType::setDatedOperatingLeg()
     * @param \StructType\DatedOperatingLegType[] $datedOperatingLeg
     */
    public function __construct(array $datedOperatingLeg = array())
    {
        $this
            ->setDatedOperatingLeg($datedOperatingLeg);
    }
    /**
     * Get DatedOperatingLeg value
     * @return \StructType\DatedOperatingLegType[]
     */
    public function getDatedOperatingLeg()
    {
        return $this->DatedOperatingLeg;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingLeg method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLeg method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingLegForArrayConstraintsFromSetDatedOperatingLeg(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $datedOperatingLegListTypeDatedOperatingLegItem) {
            // validation for constraint: itemType
            if (!$datedOperatingLegListTypeDatedOperatingLegItem instanceof \StructType\DatedOperatingLegType) {
                $invalidValues[] = is_object($datedOperatingLegListTypeDatedOperatingLegItem) ? get_class($datedOperatingLegListTypeDatedOperatingLegItem) : sprintf('%s(%s)', gettype($datedOperatingLegListTypeDatedOperatingLegItem), var_export($datedOperatingLegListTypeDatedOperatingLegItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingLeg property can only contain items of type \StructType\DatedOperatingLegType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingLeg value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingLegType[] $datedOperatingLeg
     * @return \StructType\DatedOperatingLegListType
     */
    public function setDatedOperatingLeg(array $datedOperatingLeg = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingLegArrayErrorMessage = self::validateDatedOperatingLegForArrayConstraintsFromSetDatedOperatingLeg($datedOperatingLeg))) {
            throw new \InvalidArgumentException($datedOperatingLegArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingLeg = $datedOperatingLeg;
        return $this;
    }
    /**
     * Add item to DatedOperatingLeg value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingLegType $item
     * @return \StructType\DatedOperatingLegListType
     */
    public function addToDatedOperatingLeg(\StructType\DatedOperatingLegType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedOperatingLegType) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingLeg property can only contain items of type \StructType\DatedOperatingLegType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingLeg[] = $item;
        return $this;
    }
}
