<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedMarketingSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: The commercial designation under which a Dated Operating Segment can be booked, either under the operating carrier's designator or that of another carrier (codeshare).
 * @subpackage Structs
 */
class DatedMarketingSegmentType extends AbstractStructBase
{
    /**
     * The Arrival
     * Meta information extracted from the WSDL
     * - documentation: This is a transport point location.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TransportPointType
     */
    public $Arrival;
    /**
     * The CarrierDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $CarrierDesigCode;
    /**
     * The DatedMarketingSegmentId
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of a dated marketing segment used in a message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DatedMarketingSegmentId;
    /**
     * The DatedOperatingSegmentRefId
     * Meta information extracted from the WSDL
     * - documentation: Reference to a unique identifier of a dated operating segment used in a message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DatedOperatingSegmentRefId;
    /**
     * The Dep
     * Meta information extracted from the WSDL
     * - documentation: This is a transport point location.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TransportPointType
     */
    public $Dep;
    /**
     * The MarketingCarrierFlightNumberText
     * Meta information extracted from the WSDL
     * - documentation: The numerical designation of a flight as it is marketed by a carrier. | Identifies a flight number. 1 to 4 digits. May or may not have leading zeros when less than 4 digits. The use of leading zeros does not create a different Flight
     * Number. For example, Flight Numbers 123 and 0123 are the same.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{1,4}
     * @var string
     */
    public $MarketingCarrierFlightNumberText;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The CarrierName
     * Meta information extracted from the WSDL
     * - documentation: Commercial name of the carrier. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierName;
    /**
     * The OperationalSuffixText
     * Meta information extracted from the WSDL
     * - documentation: Used to distinguish two flights having the same flight number and departing from their respective Origin Stations on the same date. | Defines the Operational Suffix which is appended to a flight number.
     * - base: xs:string
     * - length: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperationalSuffixText;
    /**
     * The RichMedia
     * Meta information extracted from the WSDL
     * - documentation: An external resource such as an Image, Video, PDF or other which is available for display
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MediaResourceRefType[]
     */
    public $RichMedia;
    /**
     * The TicketlessInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, there are no ticket records, as defined by IATA Resolutions, expected to be issued for this segment. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $TicketlessInd;
    /**
     * Constructor method for DatedMarketingSegmentType
     * @uses DatedMarketingSegmentType::setArrival()
     * @uses DatedMarketingSegmentType::setCarrierDesigCode()
     * @uses DatedMarketingSegmentType::setDatedMarketingSegmentId()
     * @uses DatedMarketingSegmentType::setDatedOperatingSegmentRefId()
     * @uses DatedMarketingSegmentType::setDep()
     * @uses DatedMarketingSegmentType::setMarketingCarrierFlightNumberText()
     * @uses DatedMarketingSegmentType::setAirlineTaxonomy()
     * @uses DatedMarketingSegmentType::setCarrierName()
     * @uses DatedMarketingSegmentType::setOperationalSuffixText()
     * @uses DatedMarketingSegmentType::setRichMedia()
     * @uses DatedMarketingSegmentType::setTicketlessInd()
     * @param \StructType\TransportPointType $arrival
     * @param string $carrierDesigCode
     * @param string $datedMarketingSegmentId
     * @param string $datedOperatingSegmentRefId
     * @param \StructType\TransportPointType $dep
     * @param string $marketingCarrierFlightNumberText
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param string $carrierName
     * @param string $operationalSuffixText
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @param bool $ticketlessInd
     */
    public function __construct(\StructType\TransportPointType $arrival = null, $carrierDesigCode = null, $datedMarketingSegmentId = null, $datedOperatingSegmentRefId = null, \StructType\TransportPointType $dep = null, $marketingCarrierFlightNumberText = null, array $airlineTaxonomy = array(), $carrierName = null, $operationalSuffixText = null, array $richMedia = array(), $ticketlessInd = null)
    {
        $this
            ->setArrival($arrival)
            ->setCarrierDesigCode($carrierDesigCode)
            ->setDatedMarketingSegmentId($datedMarketingSegmentId)
            ->setDatedOperatingSegmentRefId($datedOperatingSegmentRefId)
            ->setDep($dep)
            ->setMarketingCarrierFlightNumberText($marketingCarrierFlightNumberText)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setCarrierName($carrierName)
            ->setOperationalSuffixText($operationalSuffixText)
            ->setRichMedia($richMedia)
            ->setTicketlessInd($ticketlessInd);
    }
    /**
     * Get Arrival value
     * @return \StructType\TransportPointType
     */
    public function getArrival()
    {
        return $this->Arrival;
    }
    /**
     * Set Arrival value
     * @param \StructType\TransportPointType $arrival
     * @return \StructType\DatedMarketingSegmentType
     */
    public function setArrival(\StructType\TransportPointType $arrival = null)
    {
        $this->Arrival = $arrival;
        return $this;
    }
    /**
     * Get CarrierDesigCode value
     * @return string
     */
    public function getCarrierDesigCode()
    {
        return $this->CarrierDesigCode;
    }
    /**
     * Set CarrierDesigCode value
     * @param string $carrierDesigCode
     * @return \StructType\DatedMarketingSegmentType
     */
    public function setCarrierDesigCode($carrierDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierDesigCode) && !is_string($carrierDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierDesigCode, true), gettype($carrierDesigCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($carrierDesigCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $carrierDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($carrierDesigCode, true)), __LINE__);
        }
        $this->CarrierDesigCode = $carrierDesigCode;
        return $this;
    }
    /**
     * Get DatedMarketingSegmentId value
     * @return string
     */
    public function getDatedMarketingSegmentId()
    {
        return $this->DatedMarketingSegmentId;
    }
    /**
     * Set DatedMarketingSegmentId value
     * @param string $datedMarketingSegmentId
     * @return \StructType\DatedMarketingSegmentType
     */
    public function setDatedMarketingSegmentId($datedMarketingSegmentId = null)
    {
        // validation for constraint: string
        if (!is_null($datedMarketingSegmentId) && !is_string($datedMarketingSegmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datedMarketingSegmentId, true), gettype($datedMarketingSegmentId)), __LINE__);
        }
        $this->DatedMarketingSegmentId = $datedMarketingSegmentId;
        return $this;
    }
    /**
     * Get DatedOperatingSegmentRefId value
     * @return string
     */
    public function getDatedOperatingSegmentRefId()
    {
        return $this->DatedOperatingSegmentRefId;
    }
    /**
     * Set DatedOperatingSegmentRefId value
     * @param string $datedOperatingSegmentRefId
     * @return \StructType\DatedMarketingSegmentType
     */
    public function setDatedOperatingSegmentRefId($datedOperatingSegmentRefId = null)
    {
        // validation for constraint: string
        if (!is_null($datedOperatingSegmentRefId) && !is_string($datedOperatingSegmentRefId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datedOperatingSegmentRefId, true), gettype($datedOperatingSegmentRefId)), __LINE__);
        }
        $this->DatedOperatingSegmentRefId = $datedOperatingSegmentRefId;
        return $this;
    }
    /**
     * Get Dep value
     * @return \StructType\TransportPointType
     */
    public function getDep()
    {
        return $this->Dep;
    }
    /**
     * Set Dep value
     * @param \StructType\TransportPointType $dep
     * @return \StructType\DatedMarketingSegmentType
     */
    public function setDep(\StructType\TransportPointType $dep = null)
    {
        $this->Dep = $dep;
        return $this;
    }
    /**
     * Get MarketingCarrierFlightNumberText value
     * @return string
     */
    public function getMarketingCarrierFlightNumberText()
    {
        return $this->MarketingCarrierFlightNumberText;
    }
    /**
     * Set MarketingCarrierFlightNumberText value
     * @param string $marketingCarrierFlightNumberText
     * @return \StructType\DatedMarketingSegmentType
     */
    public function setMarketingCarrierFlightNumberText($marketingCarrierFlightNumberText = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierFlightNumberText) && !is_string($marketingCarrierFlightNumberText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierFlightNumberText, true), gettype($marketingCarrierFlightNumberText)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,4})
        if (!is_null($marketingCarrierFlightNumberText) && !preg_match('/[0-9]{1,4}/', $marketingCarrierFlightNumberText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,4}', var_export($marketingCarrierFlightNumberText, true)), __LINE__);
        }
        $this->MarketingCarrierFlightNumberText = $marketingCarrierFlightNumberText;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $datedMarketingSegmentTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$datedMarketingSegmentTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($datedMarketingSegmentTypeAirlineTaxonomyItem) ? get_class($datedMarketingSegmentTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($datedMarketingSegmentTypeAirlineTaxonomyItem), var_export($datedMarketingSegmentTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\DatedMarketingSegmentType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\DatedMarketingSegmentType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \StructType\DatedMarketingSegmentType
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get OperationalSuffixText value
     * @return string|null
     */
    public function getOperationalSuffixText()
    {
        return $this->OperationalSuffixText;
    }
    /**
     * Set OperationalSuffixText value
     * @param string $operationalSuffixText
     * @return \StructType\DatedMarketingSegmentType
     */
    public function setOperationalSuffixText($operationalSuffixText = null)
    {
        // validation for constraint: string
        if (!is_null($operationalSuffixText) && !is_string($operationalSuffixText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationalSuffixText, true), gettype($operationalSuffixText)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($operationalSuffixText) && mb_strlen($operationalSuffixText) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($operationalSuffixText)), __LINE__);
        }
        $this->OperationalSuffixText = $operationalSuffixText;
        return $this;
    }
    /**
     * Get RichMedia value
     * @return \StructType\MediaResourceRefType[]|null
     */
    public function getRichMedia()
    {
        return $this->RichMedia;
    }
    /**
     * This method is responsible for validating the values passed to the setRichMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRichMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRichMediaForArrayConstraintsFromSetRichMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $datedMarketingSegmentTypeRichMediaItem) {
            // validation for constraint: itemType
            if (!$datedMarketingSegmentTypeRichMediaItem instanceof \StructType\MediaResourceRefType) {
                $invalidValues[] = is_object($datedMarketingSegmentTypeRichMediaItem) ? get_class($datedMarketingSegmentTypeRichMediaItem) : sprintf('%s(%s)', gettype($datedMarketingSegmentTypeRichMediaItem), var_export($datedMarketingSegmentTypeRichMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @return \StructType\DatedMarketingSegmentType
     */
    public function setRichMedia(array $richMedia = array())
    {
        // validation for constraint: array
        if ('' !== ($richMediaArrayErrorMessage = self::validateRichMediaForArrayConstraintsFromSetRichMedia($richMedia))) {
            throw new \InvalidArgumentException($richMediaArrayErrorMessage, __LINE__);
        }
        $this->RichMedia = $richMedia;
        return $this;
    }
    /**
     * Add item to RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType $item
     * @return \StructType\DatedMarketingSegmentType
     */
    public function addToRichMedia(\StructType\MediaResourceRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaResourceRefType) {
            throw new \InvalidArgumentException(sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RichMedia[] = $item;
        return $this;
    }
    /**
     * Get TicketlessInd value
     * @return bool|null
     */
    public function getTicketlessInd()
    {
        return $this->TicketlessInd;
    }
    /**
     * Set TicketlessInd value
     * @param bool $ticketlessInd
     * @return \StructType\DatedMarketingSegmentType
     */
    public function setTicketlessInd($ticketlessInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($ticketlessInd) && !is_bool($ticketlessInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ticketlessInd, true), gettype($ticketlessInd)), __LINE__);
        }
        $this->TicketlessInd = $ticketlessInd;
        return $this;
    }
}
