<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedMarketingSegmentListType StructType
 * Meta information extracted from the WSDL
 * - documentation: A list of dated marketing segments used in the contained message.
 * @subpackage Structs
 */
class DatedMarketingSegmentListType extends AbstractStructBase
{
    /**
     * The DatedMarketingSegment
     * Meta information extracted from the WSDL
     * - documentation: The commercial designation under which a Dated Operating Segment can be booked, either under the operating carrier's designator or that of another carrier (codeshare).
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DatedMarketingSegmentType[]
     */
    public $DatedMarketingSegment;
    /**
     * Constructor method for DatedMarketingSegmentListType
     * @uses DatedMarketingSegmentListType::setDatedMarketingSegment()
     * @param \StructType\DatedMarketingSegmentType[] $datedMarketingSegment
     */
    public function __construct(array $datedMarketingSegment = array())
    {
        $this
            ->setDatedMarketingSegment($datedMarketingSegment);
    }
    /**
     * Get DatedMarketingSegment value
     * @return \StructType\DatedMarketingSegmentType[]
     */
    public function getDatedMarketingSegment()
    {
        return $this->DatedMarketingSegment;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedMarketingSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedMarketingSegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedMarketingSegmentForArrayConstraintsFromSetDatedMarketingSegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $datedMarketingSegmentListTypeDatedMarketingSegmentItem) {
            // validation for constraint: itemType
            if (!$datedMarketingSegmentListTypeDatedMarketingSegmentItem instanceof \StructType\DatedMarketingSegmentType) {
                $invalidValues[] = is_object($datedMarketingSegmentListTypeDatedMarketingSegmentItem) ? get_class($datedMarketingSegmentListTypeDatedMarketingSegmentItem) : sprintf('%s(%s)', gettype($datedMarketingSegmentListTypeDatedMarketingSegmentItem), var_export($datedMarketingSegmentListTypeDatedMarketingSegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedMarketingSegment property can only contain items of type \StructType\DatedMarketingSegmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedMarketingSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedMarketingSegmentType[] $datedMarketingSegment
     * @return \StructType\DatedMarketingSegmentListType
     */
    public function setDatedMarketingSegment(array $datedMarketingSegment = array())
    {
        // validation for constraint: array
        if ('' !== ($datedMarketingSegmentArrayErrorMessage = self::validateDatedMarketingSegmentForArrayConstraintsFromSetDatedMarketingSegment($datedMarketingSegment))) {
            throw new \InvalidArgumentException($datedMarketingSegmentArrayErrorMessage, __LINE__);
        }
        $this->DatedMarketingSegment = $datedMarketingSegment;
        return $this;
    }
    /**
     * Add item to DatedMarketingSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedMarketingSegmentType $item
     * @return \StructType\DatedMarketingSegmentListType
     */
    public function addToDatedMarketingSegment(\StructType\DatedMarketingSegmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedMarketingSegmentType) {
            throw new \InvalidArgumentException(sprintf('The DatedMarketingSegment property can only contain items of type \StructType\DatedMarketingSegmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedMarketingSegment[] = $item;
        return $this;
    }
}
