<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrentCouponFlightInfoRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Current Coupon Flight Information Latest flight information as it relates to a coupon eg Current CheckedIn Flown.
 * @subpackage Structs
 */
class CurrentCouponFlightInfoRefType extends AbstractStructBase
{
    /**
     * The CheckedInAirlinePaxSegmentRef
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID's - 1 or more pax segments references. These references will be to a data list or pax segment list in the contained message.
     * - choice: CheckedInAirlinePaxSegmentRef | CurrentAirlinePaxSegmentRef | FlownAirlinePaxSegmentRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxSegmentRefListType
     */
    public $CheckedInAirlinePaxSegmentRef;
    /**
     * The CurrentAirlinePaxSegmentRef
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID's - 1 or more pax segments references. These references will be to a data list or pax segment list in the contained message.
     * - choice: CheckedInAirlinePaxSegmentRef | CurrentAirlinePaxSegmentRef | FlownAirlinePaxSegmentRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxSegmentRefListType
     */
    public $CurrentAirlinePaxSegmentRef;
    /**
     * The FlownAirlinePaxSegmentRef
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID's - 1 or more pax segments references. These references will be to a data list or pax segment list in the contained message.
     * - choice: CheckedInAirlinePaxSegmentRef | CurrentAirlinePaxSegmentRef | FlownAirlinePaxSegmentRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxSegmentRefListType
     */
    public $FlownAirlinePaxSegmentRef;
    /**
     * Constructor method for CurrentCouponFlightInfoRefType
     * @uses CurrentCouponFlightInfoRefType::setCheckedInAirlinePaxSegmentRef()
     * @uses CurrentCouponFlightInfoRefType::setCurrentAirlinePaxSegmentRef()
     * @uses CurrentCouponFlightInfoRefType::setFlownAirlinePaxSegmentRef()
     * @param \StructType\PaxSegmentRefListType $checkedInAirlinePaxSegmentRef
     * @param \StructType\PaxSegmentRefListType $currentAirlinePaxSegmentRef
     * @param \StructType\PaxSegmentRefListType $flownAirlinePaxSegmentRef
     */
    public function __construct(\StructType\PaxSegmentRefListType $checkedInAirlinePaxSegmentRef = null, \StructType\PaxSegmentRefListType $currentAirlinePaxSegmentRef = null, \StructType\PaxSegmentRefListType $flownAirlinePaxSegmentRef = null)
    {
        $this
            ->setCheckedInAirlinePaxSegmentRef($checkedInAirlinePaxSegmentRef)
            ->setCurrentAirlinePaxSegmentRef($currentAirlinePaxSegmentRef)
            ->setFlownAirlinePaxSegmentRef($flownAirlinePaxSegmentRef);
    }
    /**
     * Get CheckedInAirlinePaxSegmentRef value
     * @return \StructType\PaxSegmentRefListType
     */
    public function getCheckedInAirlinePaxSegmentRef()
    {
        return isset($this->CheckedInAirlinePaxSegmentRef) ? $this->CheckedInAirlinePaxSegmentRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCheckedInAirlinePaxSegmentRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCheckedInAirlinePaxSegmentRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCheckedInAirlinePaxSegmentRefForChoiceConstraintsFromSetCheckedInAirlinePaxSegmentRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CurrentAirlinePaxSegmentRef',
            'FlownAirlinePaxSegmentRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CheckedInAirlinePaxSegmentRef can\'t be set as the property %s is already set. Only one property must be set among these properties: CheckedInAirlinePaxSegmentRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CheckedInAirlinePaxSegmentRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentRefListType $checkedInAirlinePaxSegmentRef
     * @return \StructType\CurrentCouponFlightInfoRefType
     */
    public function setCheckedInAirlinePaxSegmentRef(\StructType\PaxSegmentRefListType $checkedInAirlinePaxSegmentRef = null)
    {
        // validation for constraint: choice(CheckedInAirlinePaxSegmentRef, CurrentAirlinePaxSegmentRef, FlownAirlinePaxSegmentRef)
        if ('' !== ($checkedInAirlinePaxSegmentRefChoiceErrorMessage = self::validateCheckedInAirlinePaxSegmentRefForChoiceConstraintsFromSetCheckedInAirlinePaxSegmentRef($checkedInAirlinePaxSegmentRef))) {
            throw new \InvalidArgumentException($checkedInAirlinePaxSegmentRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($checkedInAirlinePaxSegmentRef) || (is_array($checkedInAirlinePaxSegmentRef) && empty($checkedInAirlinePaxSegmentRef))) {
            unset($this->CheckedInAirlinePaxSegmentRef);
        } else {
            $this->CheckedInAirlinePaxSegmentRef = $checkedInAirlinePaxSegmentRef;
        }
        return $this;
    }
    /**
     * Get CurrentAirlinePaxSegmentRef value
     * @return \StructType\PaxSegmentRefListType
     */
    public function getCurrentAirlinePaxSegmentRef()
    {
        return isset($this->CurrentAirlinePaxSegmentRef) ? $this->CurrentAirlinePaxSegmentRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCurrentAirlinePaxSegmentRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrentAirlinePaxSegmentRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCurrentAirlinePaxSegmentRefForChoiceConstraintsFromSetCurrentAirlinePaxSegmentRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CheckedInAirlinePaxSegmentRef',
            'FlownAirlinePaxSegmentRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CurrentAirlinePaxSegmentRef can\'t be set as the property %s is already set. Only one property must be set among these properties: CurrentAirlinePaxSegmentRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CurrentAirlinePaxSegmentRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentRefListType $currentAirlinePaxSegmentRef
     * @return \StructType\CurrentCouponFlightInfoRefType
     */
    public function setCurrentAirlinePaxSegmentRef(\StructType\PaxSegmentRefListType $currentAirlinePaxSegmentRef = null)
    {
        // validation for constraint: choice(CheckedInAirlinePaxSegmentRef, CurrentAirlinePaxSegmentRef, FlownAirlinePaxSegmentRef)
        if ('' !== ($currentAirlinePaxSegmentRefChoiceErrorMessage = self::validateCurrentAirlinePaxSegmentRefForChoiceConstraintsFromSetCurrentAirlinePaxSegmentRef($currentAirlinePaxSegmentRef))) {
            throw new \InvalidArgumentException($currentAirlinePaxSegmentRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($currentAirlinePaxSegmentRef) || (is_array($currentAirlinePaxSegmentRef) && empty($currentAirlinePaxSegmentRef))) {
            unset($this->CurrentAirlinePaxSegmentRef);
        } else {
            $this->CurrentAirlinePaxSegmentRef = $currentAirlinePaxSegmentRef;
        }
        return $this;
    }
    /**
     * Get FlownAirlinePaxSegmentRef value
     * @return \StructType\PaxSegmentRefListType
     */
    public function getFlownAirlinePaxSegmentRef()
    {
        return isset($this->FlownAirlinePaxSegmentRef) ? $this->FlownAirlinePaxSegmentRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFlownAirlinePaxSegmentRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlownAirlinePaxSegmentRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFlownAirlinePaxSegmentRefForChoiceConstraintsFromSetFlownAirlinePaxSegmentRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CheckedInAirlinePaxSegmentRef',
            'CurrentAirlinePaxSegmentRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FlownAirlinePaxSegmentRef can\'t be set as the property %s is already set. Only one property must be set among these properties: FlownAirlinePaxSegmentRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FlownAirlinePaxSegmentRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentRefListType $flownAirlinePaxSegmentRef
     * @return \StructType\CurrentCouponFlightInfoRefType
     */
    public function setFlownAirlinePaxSegmentRef(\StructType\PaxSegmentRefListType $flownAirlinePaxSegmentRef = null)
    {
        // validation for constraint: choice(CheckedInAirlinePaxSegmentRef, CurrentAirlinePaxSegmentRef, FlownAirlinePaxSegmentRef)
        if ('' !== ($flownAirlinePaxSegmentRefChoiceErrorMessage = self::validateFlownAirlinePaxSegmentRefForChoiceConstraintsFromSetFlownAirlinePaxSegmentRef($flownAirlinePaxSegmentRef))) {
            throw new \InvalidArgumentException($flownAirlinePaxSegmentRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($flownAirlinePaxSegmentRef) || (is_array($flownAirlinePaxSegmentRef) && empty($flownAirlinePaxSegmentRef))) {
            unset($this->FlownAirlinePaxSegmentRef);
        } else {
            $this->FlownAirlinePaxSegmentRef = $flownAirlinePaxSegmentRef;
        }
        return $this;
    }
}
