<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurParameterType StructType
 * Meta information extracted from the WSDL
 * - documentation: Currency related parameters intended to influence which currency the shopping results are displayed in.
 * @subpackage Structs
 */
class CurParameterType extends AbstractStructBase
{
    /**
     * The CurCode
     * Meta information extracted from the WSDL
     * - documentation: Currency Code as per ISO 4217. | Currency Code enumeration information. {codeListAgencyName}ISO{/codeListAgencyName} {codeListIdentifier}4217{/codeListIdentifier} | Additional BDT to specify a currency code.
     * - base: CurCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CurCode;
    /**
     * The AppCode
     * Meta information extracted from the WSDL
     * - documentation: Currency code application. Examples: Actual, Display, Requested, Conversion, Other | Additional BDT to specify the currency code application. Examples: Actual, Display, Requested, Conversion, Other .
     * - base: CurAppCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppCode;
    /**
     * The DecimalsAllowedNumber
     * Meta information extracted from the WSDL
     * - documentation: Specifies how many numbers to be specified after the decimal in case of currency amounts. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $DecimalsAllowedNumber;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Currency name, e.g. US Dollars. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for CurParameterType
     * @uses CurParameterType::setCurCode()
     * @uses CurParameterType::setAppCode()
     * @uses CurParameterType::setDecimalsAllowedNumber()
     * @uses CurParameterType::setName()
     * @param string $curCode
     * @param string $appCode
     * @param float $decimalsAllowedNumber
     * @param string $name
     */
    public function __construct($curCode = null, $appCode = null, $decimalsAllowedNumber = null, $name = null)
    {
        $this
            ->setCurCode($curCode)
            ->setAppCode($appCode)
            ->setDecimalsAllowedNumber($decimalsAllowedNumber)
            ->setName($name);
    }
    /**
     * Get CurCode value
     * @return string
     */
    public function getCurCode()
    {
        return $this->CurCode;
    }
    /**
     * Set CurCode value
     * @param string $curCode
     * @return \StructType\CurParameterType
     */
    public function setCurCode($curCode = null)
    {
        // validation for constraint: string
        if (!is_null($curCode) && !is_string($curCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($curCode, true), gettype($curCode)), __LINE__);
        }
        $this->CurCode = $curCode;
        return $this;
    }
    /**
     * Get AppCode value
     * @return string|null
     */
    public function getAppCode()
    {
        return $this->AppCode;
    }
    /**
     * Set AppCode value
     * @param string $appCode
     * @return \StructType\CurParameterType
     */
    public function setAppCode($appCode = null)
    {
        // validation for constraint: string
        if (!is_null($appCode) && !is_string($appCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appCode, true), gettype($appCode)), __LINE__);
        }
        $this->AppCode = $appCode;
        return $this;
    }
    /**
     * Get DecimalsAllowedNumber value
     * @return float|null
     */
    public function getDecimalsAllowedNumber()
    {
        return $this->DecimalsAllowedNumber;
    }
    /**
     * Set DecimalsAllowedNumber value
     * @param float $decimalsAllowedNumber
     * @return \StructType\CurParameterType
     */
    public function setDecimalsAllowedNumber($decimalsAllowedNumber = null)
    {
        // validation for constraint: float
        if (!is_null($decimalsAllowedNumber) && !(is_float($decimalsAllowedNumber) || is_numeric($decimalsAllowedNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($decimalsAllowedNumber, true), gettype($decimalsAllowedNumber)), __LINE__);
        }
        $this->DecimalsAllowedNumber = $decimalsAllowedNumber;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CurParameterType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
