<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrderItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used for selling by value (long sells) rather than selling by reference.
 * @subpackage Structs
 */
class CreateOrderItemType extends AbstractStructBase
{
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes. Example: UA, BA Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code | The codelist
     * contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution
     * 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined
     * 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The OfferItemRefID
     * Meta information extracted from the WSDL
     * - documentation: The airline-assigned unique Offer Item ID. Example: OFFER769-A850-4EC4-8F46-02293F72D7E6 | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfferItemRefID;
    /**
     * The OfferItemTimeLimits
     * Meta information extracted from the WSDL
     * - documentation: A Time limit for an offer item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OfferItemTimeLimitsType[]
     */
    public $OfferItemTimeLimits;
    /**
     * The OfferItemType
     * Meta information extracted from the WSDL
     * - documentation: Offer Item type used for long sell transactions
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferItemTypeType
     */
    public $OfferItemType;
    /**
     * The WebAddressURI
     * Meta information extracted from the WSDL
     * - documentation: Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer. | A string of characters used to identify a resource. Such identification
     * enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddressURI;
    /**
     * Constructor method for CreateOrderItemType
     * @uses CreateOrderItemType::setOwnerCode()
     * @uses CreateOrderItemType::setOfferItemRefID()
     * @uses CreateOrderItemType::setOfferItemTimeLimits()
     * @uses CreateOrderItemType::setOfferItemType()
     * @uses CreateOrderItemType::setWebAddressURI()
     * @param string $ownerCode
     * @param string $offerItemRefID
     * @param \StructType\OfferItemTimeLimitsType[] $offerItemTimeLimits
     * @param \StructType\OfferItemTypeType $offerItemType
     * @param string $webAddressURI
     */
    public function __construct($ownerCode = null, $offerItemRefID = null, array $offerItemTimeLimits = array(), \StructType\OfferItemTypeType $offerItemType = null, $webAddressURI = null)
    {
        $this
            ->setOwnerCode($ownerCode)
            ->setOfferItemRefID($offerItemRefID)
            ->setOfferItemTimeLimits($offerItemTimeLimits)
            ->setOfferItemType($offerItemType)
            ->setWebAddressURI($webAddressURI);
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\CreateOrderItemType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get OfferItemRefID value
     * @return string|null
     */
    public function getOfferItemRefID()
    {
        return $this->OfferItemRefID;
    }
    /**
     * Set OfferItemRefID value
     * @param string $offerItemRefID
     * @return \StructType\CreateOrderItemType
     */
    public function setOfferItemRefID($offerItemRefID = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemRefID) && !is_string($offerItemRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemRefID, true), gettype($offerItemRefID)), __LINE__);
        }
        $this->OfferItemRefID = $offerItemRefID;
        return $this;
    }
    /**
     * Get OfferItemTimeLimits value
     * @return \StructType\OfferItemTimeLimitsType[]|null
     */
    public function getOfferItemTimeLimits()
    {
        return $this->OfferItemTimeLimits;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferItemTimeLimits method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferItemTimeLimits method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferItemTimeLimitsForArrayConstraintsFromSetOfferItemTimeLimits(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createOrderItemTypeOfferItemTimeLimitsItem) {
            // validation for constraint: itemType
            if (!$createOrderItemTypeOfferItemTimeLimitsItem instanceof \StructType\OfferItemTimeLimitsType) {
                $invalidValues[] = is_object($createOrderItemTypeOfferItemTimeLimitsItem) ? get_class($createOrderItemTypeOfferItemTimeLimitsItem) : sprintf('%s(%s)', gettype($createOrderItemTypeOfferItemTimeLimitsItem), var_export($createOrderItemTypeOfferItemTimeLimitsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferItemTimeLimits property can only contain items of type \StructType\OfferItemTimeLimitsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferItemTimeLimits value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferItemTimeLimitsType[] $offerItemTimeLimits
     * @return \StructType\CreateOrderItemType
     */
    public function setOfferItemTimeLimits(array $offerItemTimeLimits = array())
    {
        // validation for constraint: array
        if ('' !== ($offerItemTimeLimitsArrayErrorMessage = self::validateOfferItemTimeLimitsForArrayConstraintsFromSetOfferItemTimeLimits($offerItemTimeLimits))) {
            throw new \InvalidArgumentException($offerItemTimeLimitsArrayErrorMessage, __LINE__);
        }
        $this->OfferItemTimeLimits = $offerItemTimeLimits;
        return $this;
    }
    /**
     * Add item to OfferItemTimeLimits value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferItemTimeLimitsType $item
     * @return \StructType\CreateOrderItemType
     */
    public function addToOfferItemTimeLimits(\StructType\OfferItemTimeLimitsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OfferItemTimeLimitsType) {
            throw new \InvalidArgumentException(sprintf('The OfferItemTimeLimits property can only contain items of type \StructType\OfferItemTimeLimitsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OfferItemTimeLimits[] = $item;
        return $this;
    }
    /**
     * Get OfferItemType value
     * @return \StructType\OfferItemTypeType|null
     */
    public function getOfferItemType()
    {
        return $this->OfferItemType;
    }
    /**
     * Set OfferItemType value
     * @param \StructType\OfferItemTypeType $offerItemType
     * @return \StructType\CreateOrderItemType
     */
    public function setOfferItemType(\StructType\OfferItemTypeType $offerItemType = null)
    {
        $this->OfferItemType = $offerItemType;
        return $this;
    }
    /**
     * Get WebAddressURI value
     * @return string|null
     */
    public function getWebAddressURI()
    {
        return $this->WebAddressURI;
    }
    /**
     * Set WebAddressURI value
     * @param string $webAddressURI
     * @return \StructType\CreateOrderItemType
     */
    public function setWebAddressURI($webAddressURI = null)
    {
        // validation for constraint: string
        if (!is_null($webAddressURI) && !is_string($webAddressURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddressURI, true), gettype($webAddressURI)), __LINE__);
        }
        $this->WebAddressURI = $webAddressURI;
        return $this;
    }
}
