<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactInfoListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contact info data list definition.
 * @subpackage Structs
 */
class ContactInfoListType extends AbstractStructBase
{
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - documentation: The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ContactInfoType[]
     */
    public $ContactInfo;
    /**
     * Constructor method for ContactInfoListType
     * @uses ContactInfoListType::setContactInfo()
     * @param \StructType\ContactInfoType[] $contactInfo
     */
    public function __construct(array $contactInfo = array())
    {
        $this
            ->setContactInfo($contactInfo);
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfoType[]
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoForArrayConstraintsFromSetContactInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactInfoListTypeContactInfoItem) {
            // validation for constraint: itemType
            if (!$contactInfoListTypeContactInfoItem instanceof \StructType\ContactInfoType) {
                $invalidValues[] = is_object($contactInfoListTypeContactInfoItem) ? get_class($contactInfoListTypeContactInfoItem) : sprintf('%s(%s)', gettype($contactInfoListTypeContactInfoItem), var_export($contactInfoListTypeContactInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType[] $contactInfo
     * @return \StructType\ContactInfoListType
     */
    public function setContactInfo(array $contactInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoArrayErrorMessage = self::validateContactInfoForArrayConstraintsFromSetContactInfo($contactInfo))) {
            throw new \InvalidArgumentException($contactInfoArrayErrorMessage, __LINE__);
        }
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Add item to ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType $item
     * @return \StructType\ContactInfoListType
     */
    public function addToContactInfo(\StructType\ContactInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfo[] = $item;
        return $this;
    }
}
