<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Customer's requested connection information.
 * @subpackage Structs
 */
class ConnectionCriteriaType extends AbstractStructBase
{
    /**
     * The ConnectionCriteriaID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier assigned to this transfer preference. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ConnectionCriteriaID;
    /**
     * The InterlineInd
     * Meta information extracted from the WSDL
     * - documentation: When true, specifies the preference for a protected transfer (interline connection), as oppose to a self/non protected transfer. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states
     * of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $InterlineInd;
    /**
     * The MaximumConnectionDuration
     * Meta information extracted from the WSDL
     * - documentation: Maximum connection duration preference. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time units (Year, Month, Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaximumConnectionDuration;
    /**
     * The MaximumConnectionQty
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of connections. | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MaximumConnectionQty;
    /**
     * The MinimumConnectionDuration
     * Meta information extracted from the WSDL
     * - documentation: Minimum connection duration preference. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time units (Year, Month, Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MinimumConnectionDuration;
    /**
     * The StationCriteria
     * Meta information extracted from the WSDL
     * - documentation: The customer's requested Station criteria.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StationCriteriaType[]
     */
    public $StationCriteria;
    /**
     * Constructor method for ConnectionCriteriaType
     * @uses ConnectionCriteriaType::setConnectionCriteriaID()
     * @uses ConnectionCriteriaType::setInterlineInd()
     * @uses ConnectionCriteriaType::setMaximumConnectionDuration()
     * @uses ConnectionCriteriaType::setMaximumConnectionQty()
     * @uses ConnectionCriteriaType::setMinimumConnectionDuration()
     * @uses ConnectionCriteriaType::setStationCriteria()
     * @param string $connectionCriteriaID
     * @param bool $interlineInd
     * @param string $maximumConnectionDuration
     * @param float $maximumConnectionQty
     * @param string $minimumConnectionDuration
     * @param \StructType\StationCriteriaType[] $stationCriteria
     */
    public function __construct($connectionCriteriaID = null, $interlineInd = null, $maximumConnectionDuration = null, $maximumConnectionQty = null, $minimumConnectionDuration = null, array $stationCriteria = array())
    {
        $this
            ->setConnectionCriteriaID($connectionCriteriaID)
            ->setInterlineInd($interlineInd)
            ->setMaximumConnectionDuration($maximumConnectionDuration)
            ->setMaximumConnectionQty($maximumConnectionQty)
            ->setMinimumConnectionDuration($minimumConnectionDuration)
            ->setStationCriteria($stationCriteria);
    }
    /**
     * Get ConnectionCriteriaID value
     * @return string
     */
    public function getConnectionCriteriaID()
    {
        return $this->ConnectionCriteriaID;
    }
    /**
     * Set ConnectionCriteriaID value
     * @param string $connectionCriteriaID
     * @return \StructType\ConnectionCriteriaType
     */
    public function setConnectionCriteriaID($connectionCriteriaID = null)
    {
        // validation for constraint: string
        if (!is_null($connectionCriteriaID) && !is_string($connectionCriteriaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectionCriteriaID, true), gettype($connectionCriteriaID)), __LINE__);
        }
        $this->ConnectionCriteriaID = $connectionCriteriaID;
        return $this;
    }
    /**
     * Get InterlineInd value
     * @return bool|null
     */
    public function getInterlineInd()
    {
        return $this->InterlineInd;
    }
    /**
     * Set InterlineInd value
     * @param bool $interlineInd
     * @return \StructType\ConnectionCriteriaType
     */
    public function setInterlineInd($interlineInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($interlineInd) && !is_bool($interlineInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($interlineInd, true), gettype($interlineInd)), __LINE__);
        }
        $this->InterlineInd = $interlineInd;
        return $this;
    }
    /**
     * Get MaximumConnectionDuration value
     * @return string|null
     */
    public function getMaximumConnectionDuration()
    {
        return $this->MaximumConnectionDuration;
    }
    /**
     * Set MaximumConnectionDuration value
     * @param string $maximumConnectionDuration
     * @return \StructType\ConnectionCriteriaType
     */
    public function setMaximumConnectionDuration($maximumConnectionDuration = null)
    {
        // validation for constraint: string
        if (!is_null($maximumConnectionDuration) && !is_string($maximumConnectionDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumConnectionDuration, true), gettype($maximumConnectionDuration)), __LINE__);
        }
        $this->MaximumConnectionDuration = $maximumConnectionDuration;
        return $this;
    }
    /**
     * Get MaximumConnectionQty value
     * @return float|null
     */
    public function getMaximumConnectionQty()
    {
        return $this->MaximumConnectionQty;
    }
    /**
     * Set MaximumConnectionQty value
     * @param float $maximumConnectionQty
     * @return \StructType\ConnectionCriteriaType
     */
    public function setMaximumConnectionQty($maximumConnectionQty = null)
    {
        // validation for constraint: float
        if (!is_null($maximumConnectionQty) && !(is_float($maximumConnectionQty) || is_numeric($maximumConnectionQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumConnectionQty, true), gettype($maximumConnectionQty)), __LINE__);
        }
        $this->MaximumConnectionQty = $maximumConnectionQty;
        return $this;
    }
    /**
     * Get MinimumConnectionDuration value
     * @return string|null
     */
    public function getMinimumConnectionDuration()
    {
        return $this->MinimumConnectionDuration;
    }
    /**
     * Set MinimumConnectionDuration value
     * @param string $minimumConnectionDuration
     * @return \StructType\ConnectionCriteriaType
     */
    public function setMinimumConnectionDuration($minimumConnectionDuration = null)
    {
        // validation for constraint: string
        if (!is_null($minimumConnectionDuration) && !is_string($minimumConnectionDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumConnectionDuration, true), gettype($minimumConnectionDuration)), __LINE__);
        }
        $this->MinimumConnectionDuration = $minimumConnectionDuration;
        return $this;
    }
    /**
     * Get StationCriteria value
     * @return \StructType\StationCriteriaType[]|null
     */
    public function getStationCriteria()
    {
        return $this->StationCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setStationCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStationCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStationCriteriaForArrayConstraintsFromSetStationCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $connectionCriteriaTypeStationCriteriaItem) {
            // validation for constraint: itemType
            if (!$connectionCriteriaTypeStationCriteriaItem instanceof \StructType\StationCriteriaType) {
                $invalidValues[] = is_object($connectionCriteriaTypeStationCriteriaItem) ? get_class($connectionCriteriaTypeStationCriteriaItem) : sprintf('%s(%s)', gettype($connectionCriteriaTypeStationCriteriaItem), var_export($connectionCriteriaTypeStationCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StationCriteria property can only contain items of type \StructType\StationCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StationCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\StationCriteriaType[] $stationCriteria
     * @return \StructType\ConnectionCriteriaType
     */
    public function setStationCriteria(array $stationCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($stationCriteriaArrayErrorMessage = self::validateStationCriteriaForArrayConstraintsFromSetStationCriteria($stationCriteria))) {
            throw new \InvalidArgumentException($stationCriteriaArrayErrorMessage, __LINE__);
        }
        $this->StationCriteria = $stationCriteria;
        return $this;
    }
    /**
     * Add item to StationCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\StationCriteriaType $item
     * @return \StructType\ConnectionCriteriaType
     */
    public function addToStationCriteria(\StructType\StationCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StationCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The StationCriteria property can only contain items of type \StructType\StationCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StationCriteria[] = $item;
        return $this;
    }
}
