<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CollectionPointTaxType StructType
 * Meta information extracted from the WSDL
 * - documentation: Tax data breakdown by collection point for XF(Passenger Facility Fee) and ZP(federal tax segment) taxes.
 * @subpackage Structs
 */
class CollectionPointTaxType extends AbstractStructBase
{
    /**
     * The AirportAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount filed by the airport in the currency applicable to the geographical location of the airport.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $AirportAmount;
    /**
     * The Station
     * Meta information extracted from the WSDL
     * - documentation: Location or facility where air or surface transportation originates, stops and/or terminates, and where passengers and/or cargo can be taken on or off. Those of relevance to the airline industry are identified by an IATA Location
     * Identifier (3 letter location identifier). There are also additional airports without an IATA identifier that may be used in disruption scenarios that will be identified by an ICAO 4 letter code (assigned to every registered airport, military or
     * civil). Business Identifier Fields: - IATA Location Code
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\StationType
     */
    public $Station;
    /**
     * Constructor method for CollectionPointTaxType
     * @uses CollectionPointTaxType::setAirportAmount()
     * @uses CollectionPointTaxType::setStation()
     * @param \StructType\AmountType $airportAmount
     * @param \StructType\StationType $station
     */
    public function __construct(\StructType\AmountType $airportAmount = null, \StructType\StationType $station = null)
    {
        $this
            ->setAirportAmount($airportAmount)
            ->setStation($station);
    }
    /**
     * Get AirportAmount value
     * @return \StructType\AmountType
     */
    public function getAirportAmount()
    {
        return $this->AirportAmount;
    }
    /**
     * Set AirportAmount value
     * @param \StructType\AmountType $airportAmount
     * @return \StructType\CollectionPointTaxType
     */
    public function setAirportAmount(\StructType\AmountType $airportAmount = null)
    {
        $this->AirportAmount = $airportAmount;
        return $this;
    }
    /**
     * Get Station value
     * @return \StructType\StationType
     */
    public function getStation()
    {
        return $this->Station;
    }
    /**
     * Set Station value
     * @param \StructType\StationType $station
     * @return \StructType\CollectionPointTaxType
     */
    public function setStation(\StructType\StationType $station = null)
    {
        $this->Station = $station;
        return $this;
    }
}
