<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CollectionPoint StructType
 * Meta information extracted from the WSDL
 * - documentation: For XF and ZP taxes. Tax data break down for each collection point. The sum of individual amounts entered here must be equal to the Amount entered in the Tax element.
 * @subpackage Structs
 */
class CollectionPoint extends AbstractStructBase
{
    /**
     * The AirportCode
     * Meta information extracted from the WSDL
     * - documentation: Airport code. Example: MIA
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - ref: AirportCode
     * @var string
     */
    public $AirportCode;
    /**
     * The AirportAmount
     * Meta information extracted from the WSDL
     * - documentation: The amount actually filed by the airport in the currency applicable to the geographical location of the airport(same as shown in FareCalculation line)
     * @var int
     */
    public $AirportAmount;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Individual amount for collection point. Example: 2500
     * @var int
     */
    public $Amount;
    /**
     * Constructor method for CollectionPoint
     * @uses CollectionPoint::setAirportCode()
     * @uses CollectionPoint::setAirportAmount()
     * @uses CollectionPoint::setCurrencyCode()
     * @uses CollectionPoint::setAmount()
     * @param string $airportCode
     * @param int $airportAmount
     * @param string $currencyCode
     * @param int $amount
     */
    public function __construct($airportCode = null, $airportAmount = null, $currencyCode = null, $amount = null)
    {
        $this
            ->setAirportCode($airportCode)
            ->setAirportAmount($airportAmount)
            ->setCurrencyCode($currencyCode)
            ->setAmount($amount);
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \StructType\CollectionPoint
     */
    public function setAirportCode($airportCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportCode) && !is_string($airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportCode, true), gettype($airportCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($airportCode) && mb_strlen($airportCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($airportCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($airportCode) && mb_strlen($airportCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($airportCode)), __LINE__);
        }
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get AirportAmount value
     * @return int|null
     */
    public function getAirportAmount()
    {
        return $this->AirportAmount;
    }
    /**
     * Set AirportAmount value
     * @param int $airportAmount
     * @return \StructType\CollectionPoint
     */
    public function setAirportAmount($airportAmount = null)
    {
        // validation for constraint: int
        if (!is_null($airportAmount) && !(is_int($airportAmount) || ctype_digit($airportAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($airportAmount, true), gettype($airportAmount)), __LINE__);
        }
        $this->AirportAmount = $airportAmount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CollectionPoint
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\CollectionPoint
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
