<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Code StructType
 * Meta information extracted from the WSDL
 * - documentation: Error code or equipment type code. Example: 0104 (error code), 747 (equipment code) | Class of Service Code. Example: B | Service Sub-Group Code(s).Group BG: CT (Container), PP (Pre-Paid Excess Baggage)Group IE: IT (Internet Access),
 * TV (Television) | Service Group code.BD (BUNDLED SERVICE)BG (BAGGAGE)IE (IN-FLIGHT ENTERTAINMENT)LG (LOUNGE)
 * - type: xs:string
 * @subpackage Structs
 */
class Code extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The SeatsLeft
     * Meta information extracted from the WSDL
     * - documentation: Inidcates how many seats are still available in this class of service.
     * @var int
     */
    public $SeatsLeft;
    /**
     * Constructor method for Code
     * @uses Code::set_()
     * @uses Code::setSeatsLeft()
     * @param string $_
     * @param int $seatsLeft
     */
    public function __construct($_ = null, $seatsLeft = null)
    {
        $this
            ->set_($_)
            ->setSeatsLeft($seatsLeft);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\Code
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get SeatsLeft value
     * @return int|null
     */
    public function getSeatsLeft()
    {
        return $this->SeatsLeft;
    }
    /**
     * Set SeatsLeft value
     * @param int $seatsLeft
     * @return \StructType\Code
     */
    public function setSeatsLeft($seatsLeft = null)
    {
        // validation for constraint: int
        if (!is_null($seatsLeft) && !(is_int($seatsLeft) || ctype_digit($seatsLeft))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatsLeft, true), gettype($seatsLeft)), __LINE__);
        }
        $this->SeatsLeft = $seatsLeft;
        return $this;
    }
}
