<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearanceDataType StructType
 * Meta information extracted from the WSDL
 * - documentation: set of data, either signed or not, that delivers all that is necessary for a clearance of funds to take place when using the SwO Standard and Process. It supplies the data needed to execute the clearance using the SwO Standard and
 * Process. It is the core data required by the Clearance Manager to process a Clearance. Optionally, it can be agreed by the Clearance Payer and the Clearance Payee of the clearance
 * @subpackage Structs
 */
class ClearanceDataType extends AbstractStructBase
{
    /**
     * The ClearanceID
     * Meta information extracted from the WSDL
     * - documentation: this is an identifier generated by the party requesting the clearance that uniquely identifies the clearance transaction. It provides the necessary link for financial audit connecting the sale to the financial records. This field is
     * required because no other existing data elements could be used by the financial systems or could provide unique identification. The identifier is globally unique for the settlement by design. | Clearance identifier is a character string managed by a
     * carrier.
     * - base: xs:token
     * - length: 15
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{7}[A-Za-z0-9]{8})
     * @var string
     */
    public $ClearanceID;
    /**
     * The ClearancePayeeData
     * Meta information extracted from the WSDL
     * - documentation: Data defining the Clearance Payee and relevant to its operations.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ClearancePayeeDataType
     */
    public $ClearancePayeeData;
    /**
     * The ClearancePayerData
     * Meta information extracted from the WSDL
     * - documentation: Data defining the Clearance Payer and relevant to its operations.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ClearancePayerDataType
     */
    public $ClearancePayerData;
    /**
     * The NetClearanceAmount
     * Meta information extracted from the WSDL
     * - documentation: The funds to be cleared as a result of the payment commitment, the selected payment method, and the date when the funds must be remitted. It is the amount the Clearance Payer must pay to the Clearance Payee on a given Remittance Date
     * taking into consideration any funds due to the Clearance Payer by the Clearance Payee as a result of the same payment commitment.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $NetClearanceAmount;
    /**
     * The PaymentCommitmentDateTime
     * Meta information extracted from the WSDL
     * - documentation: Defines the date when the PaymentProcessingSummary, with information about amount and payment method, is accepted by ORA to be sufficient to lead to successful payment. This is the date when the status in the 'Payment Status Code' is
     * set to 'SUCCESSFUL' | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentCommitmentDateTime;
    /**
     * The ProcessRuleCode
     * Meta information extracted from the WSDL
     * - documentation: defines under what governing rules, process and reporting standard the Clearance Manager processes the clearance. Example: IATAC00 or BLTRL00 or NDCLNK0 | Character string of letters and numbers to describe the governance for the
     * Clearance process.
     * - base: xs:token
     * - length: 7
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (IATAC|BLTRL)[A-Za-z0-9]{2}
     * @var string
     */
    public $ProcessRuleCode;
    /**
     * The ClearancePayeeSignature
     * Meta information extracted from the WSDL
     * - documentation: Method of ensuring data integrity and authenticity of the Clearance Data. Clearance Payee and the Clearance Payer Data will be signed already. If the Clearance Payee Data has been signed then this data structure is for the signature
     * of the counterparty. If Clearance Payer Data has been signed then here is the signature of the entity countersigning the entire Clearance data structure.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DigitalSignatureType
     */
    public $ClearancePayeeSignature;
    /**
     * The ClearancePayerSignature
     * Meta information extracted from the WSDL
     * - documentation: Method of ensuring data integrity and authenticity of the Clearance Data. Clearance Payee and the Clearance Payer Data will be signed already. If the Clearance Payer Data has been signed then this data structure is for the signature
     * of the counterparty. If Clearance Payee Data has been signed then here is the signature of the entity countersigning the entire Clearance Data structure.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DigitalSignatureType
     */
    public $ClearancePayerSignature;
    /**
     * The RemittanceDate
     * Meta information extracted from the WSDL
     * - documentation: The date when the amount in the clearance request that is paid by the Clearance Payer will have to reach the settlement manager's bank account | A date is a Gregorian calendar representation in various common resolutions: year,
     * month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RemittanceDate;
    /**
     * Constructor method for ClearanceDataType
     * @uses ClearanceDataType::setClearanceID()
     * @uses ClearanceDataType::setClearancePayeeData()
     * @uses ClearanceDataType::setClearancePayerData()
     * @uses ClearanceDataType::setNetClearanceAmount()
     * @uses ClearanceDataType::setPaymentCommitmentDateTime()
     * @uses ClearanceDataType::setProcessRuleCode()
     * @uses ClearanceDataType::setClearancePayeeSignature()
     * @uses ClearanceDataType::setClearancePayerSignature()
     * @uses ClearanceDataType::setRemittanceDate()
     * @param string $clearanceID
     * @param \StructType\ClearancePayeeDataType $clearancePayeeData
     * @param \StructType\ClearancePayerDataType $clearancePayerData
     * @param \StructType\AmountType $netClearanceAmount
     * @param string $paymentCommitmentDateTime
     * @param string $processRuleCode
     * @param \StructType\DigitalSignatureType $clearancePayeeSignature
     * @param \StructType\DigitalSignatureType $clearancePayerSignature
     * @param string $remittanceDate
     */
    public function __construct($clearanceID = null, \StructType\ClearancePayeeDataType $clearancePayeeData = null, \StructType\ClearancePayerDataType $clearancePayerData = null, \StructType\AmountType $netClearanceAmount = null, $paymentCommitmentDateTime = null, $processRuleCode = null, \StructType\DigitalSignatureType $clearancePayeeSignature = null, \StructType\DigitalSignatureType $clearancePayerSignature = null, $remittanceDate = null)
    {
        $this
            ->setClearanceID($clearanceID)
            ->setClearancePayeeData($clearancePayeeData)
            ->setClearancePayerData($clearancePayerData)
            ->setNetClearanceAmount($netClearanceAmount)
            ->setPaymentCommitmentDateTime($paymentCommitmentDateTime)
            ->setProcessRuleCode($processRuleCode)
            ->setClearancePayeeSignature($clearancePayeeSignature)
            ->setClearancePayerSignature($clearancePayerSignature)
            ->setRemittanceDate($remittanceDate);
    }
    /**
     * Get ClearanceID value
     * @return string
     */
    public function getClearanceID()
    {
        return $this->ClearanceID;
    }
    /**
     * Set ClearanceID value
     * @param string $clearanceID
     * @return \StructType\ClearanceDataType
     */
    public function setClearanceID($clearanceID = null)
    {
        // validation for constraint: string
        if (!is_null($clearanceID) && !is_string($clearanceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clearanceID, true), gettype($clearanceID)), __LINE__);
        }
        // validation for constraint: length(15)
        if (!is_null($clearanceID) && mb_strlen($clearanceID) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 15', mb_strlen($clearanceID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{7}[A-Za-z0-9]{8}))
        if (!is_null($clearanceID) && !preg_match('/([0-9]{7}[A-Za-z0-9]{8})/', $clearanceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{7}[A-Za-z0-9]{8})', var_export($clearanceID, true)), __LINE__);
        }
        $this->ClearanceID = $clearanceID;
        return $this;
    }
    /**
     * Get ClearancePayeeData value
     * @return \StructType\ClearancePayeeDataType
     */
    public function getClearancePayeeData()
    {
        return $this->ClearancePayeeData;
    }
    /**
     * Set ClearancePayeeData value
     * @param \StructType\ClearancePayeeDataType $clearancePayeeData
     * @return \StructType\ClearanceDataType
     */
    public function setClearancePayeeData(\StructType\ClearancePayeeDataType $clearancePayeeData = null)
    {
        $this->ClearancePayeeData = $clearancePayeeData;
        return $this;
    }
    /**
     * Get ClearancePayerData value
     * @return \StructType\ClearancePayerDataType
     */
    public function getClearancePayerData()
    {
        return $this->ClearancePayerData;
    }
    /**
     * Set ClearancePayerData value
     * @param \StructType\ClearancePayerDataType $clearancePayerData
     * @return \StructType\ClearanceDataType
     */
    public function setClearancePayerData(\StructType\ClearancePayerDataType $clearancePayerData = null)
    {
        $this->ClearancePayerData = $clearancePayerData;
        return $this;
    }
    /**
     * Get NetClearanceAmount value
     * @return \StructType\AmountType
     */
    public function getNetClearanceAmount()
    {
        return $this->NetClearanceAmount;
    }
    /**
     * Set NetClearanceAmount value
     * @param \StructType\AmountType $netClearanceAmount
     * @return \StructType\ClearanceDataType
     */
    public function setNetClearanceAmount(\StructType\AmountType $netClearanceAmount = null)
    {
        $this->NetClearanceAmount = $netClearanceAmount;
        return $this;
    }
    /**
     * Get PaymentCommitmentDateTime value
     * @return string
     */
    public function getPaymentCommitmentDateTime()
    {
        return $this->PaymentCommitmentDateTime;
    }
    /**
     * Set PaymentCommitmentDateTime value
     * @param string $paymentCommitmentDateTime
     * @return \StructType\ClearanceDataType
     */
    public function setPaymentCommitmentDateTime($paymentCommitmentDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCommitmentDateTime) && !is_string($paymentCommitmentDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCommitmentDateTime, true), gettype($paymentCommitmentDateTime)), __LINE__);
        }
        $this->PaymentCommitmentDateTime = $paymentCommitmentDateTime;
        return $this;
    }
    /**
     * Get ProcessRuleCode value
     * @return string
     */
    public function getProcessRuleCode()
    {
        return $this->ProcessRuleCode;
    }
    /**
     * Set ProcessRuleCode value
     * @param string $processRuleCode
     * @return \StructType\ClearanceDataType
     */
    public function setProcessRuleCode($processRuleCode = null)
    {
        // validation for constraint: string
        if (!is_null($processRuleCode) && !is_string($processRuleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processRuleCode, true), gettype($processRuleCode)), __LINE__);
        }
        // validation for constraint: length(7)
        if (!is_null($processRuleCode) && mb_strlen($processRuleCode) !== 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 7', mb_strlen($processRuleCode)), __LINE__);
        }
        // validation for constraint: pattern((IATAC|BLTRL)[A-Za-z0-9]{2})
        if (!is_null($processRuleCode) && !preg_match('/(IATAC|BLTRL)[A-Za-z0-9]{2}/', $processRuleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (IATAC|BLTRL)[A-Za-z0-9]{2}', var_export($processRuleCode, true)), __LINE__);
        }
        $this->ProcessRuleCode = $processRuleCode;
        return $this;
    }
    /**
     * Get ClearancePayeeSignature value
     * @return \StructType\DigitalSignatureType|null
     */
    public function getClearancePayeeSignature()
    {
        return $this->ClearancePayeeSignature;
    }
    /**
     * Set ClearancePayeeSignature value
     * @param \StructType\DigitalSignatureType $clearancePayeeSignature
     * @return \StructType\ClearanceDataType
     */
    public function setClearancePayeeSignature(\StructType\DigitalSignatureType $clearancePayeeSignature = null)
    {
        $this->ClearancePayeeSignature = $clearancePayeeSignature;
        return $this;
    }
    /**
     * Get ClearancePayerSignature value
     * @return \StructType\DigitalSignatureType|null
     */
    public function getClearancePayerSignature()
    {
        return $this->ClearancePayerSignature;
    }
    /**
     * Set ClearancePayerSignature value
     * @param \StructType\DigitalSignatureType $clearancePayerSignature
     * @return \StructType\ClearanceDataType
     */
    public function setClearancePayerSignature(\StructType\DigitalSignatureType $clearancePayerSignature = null)
    {
        $this->ClearancePayerSignature = $clearancePayerSignature;
        return $this;
    }
    /**
     * Get RemittanceDate value
     * @return string|null
     */
    public function getRemittanceDate()
    {
        return $this->RemittanceDate;
    }
    /**
     * Set RemittanceDate value
     * @param string $remittanceDate
     * @return \StructType\ClearanceDataType
     */
    public function setRemittanceDate($remittanceDate = null)
    {
        // validation for constraint: string
        if (!is_null($remittanceDate) && !is_string($remittanceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remittanceDate, true), gettype($remittanceDate)), __LINE__);
        }
        $this->RemittanceDate = $remittanceDate;
        return $this;
    }
}
