<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearanceCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: communication of preference for using stated clearance process and reporting standard such as the 'SwO Standard and Process' with or without a specific Remittance Date. It supplies information about preference for given clearance
 * process and reporting standard at the time of requesting an offer or additional information about an offer, an item, or an order. It is part of the 'Payment Method Criteria', and it is relevant whenever the method of payment will require clearance of
 * funds between the partners of the sale.
 * @subpackage Structs
 */
class ClearanceCriteriaType extends AbstractStructBase
{
    /**
     * The ProcessRuleCode
     * Meta information extracted from the WSDL
     * - documentation: defines under what governing rules, process and reporting standard the Clearance Manager processes the clearance. Example: IATAC00 or BLTRL00 or NDCLNK0 | Character string of letters and numbers to describe the governance for the
     * Clearance process.
     * - base: xs:token
     * - length: 7
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (IATAC|BLTRL)[A-Za-z0-9]{2}
     * @var string
     */
    public $ProcessRuleCode;
    /**
     * The RemittanceDate
     * Meta information extracted from the WSDL
     * - documentation: The date when the amount in the clearance request that is paid by the Clearance Payer will have to reach the settlement manager's bank account | A date is a Gregorian calendar representation in various common resolutions: year,
     * month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RemittanceDate;
    /**
     * Constructor method for ClearanceCriteriaType
     * @uses ClearanceCriteriaType::setProcessRuleCode()
     * @uses ClearanceCriteriaType::setRemittanceDate()
     * @param string $processRuleCode
     * @param string $remittanceDate
     */
    public function __construct($processRuleCode = null, $remittanceDate = null)
    {
        $this
            ->setProcessRuleCode($processRuleCode)
            ->setRemittanceDate($remittanceDate);
    }
    /**
     * Get ProcessRuleCode value
     * @return string
     */
    public function getProcessRuleCode()
    {
        return $this->ProcessRuleCode;
    }
    /**
     * Set ProcessRuleCode value
     * @param string $processRuleCode
     * @return \StructType\ClearanceCriteriaType
     */
    public function setProcessRuleCode($processRuleCode = null)
    {
        // validation for constraint: string
        if (!is_null($processRuleCode) && !is_string($processRuleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processRuleCode, true), gettype($processRuleCode)), __LINE__);
        }
        // validation for constraint: length(7)
        if (!is_null($processRuleCode) && mb_strlen($processRuleCode) !== 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 7', mb_strlen($processRuleCode)), __LINE__);
        }
        // validation for constraint: pattern((IATAC|BLTRL)[A-Za-z0-9]{2})
        if (!is_null($processRuleCode) && !preg_match('/(IATAC|BLTRL)[A-Za-z0-9]{2}/', $processRuleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (IATAC|BLTRL)[A-Za-z0-9]{2}', var_export($processRuleCode, true)), __LINE__);
        }
        $this->ProcessRuleCode = $processRuleCode;
        return $this;
    }
    /**
     * Get RemittanceDate value
     * @return string|null
     */
    public function getRemittanceDate()
    {
        return $this->RemittanceDate;
    }
    /**
     * Set RemittanceDate value
     * @param string $remittanceDate
     * @return \StructType\ClearanceCriteriaType
     */
    public function setRemittanceDate($remittanceDate = null)
    {
        // validation for constraint: string
        if (!is_null($remittanceDate) && !is_string($remittanceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remittanceDate, true), gettype($remittanceDate)), __LINE__);
        }
        $this->RemittanceDate = $remittanceDate;
        return $this;
    }
}
