<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangesToOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: History Order is a uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and
 * services that are not necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each
 * passenger in an Order may hold different sets of order items at different prices.
 * @subpackage Structs
 */
class ChangesToOrderType extends AbstractStructBase
{
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Order across several messages. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderID;
    /**
     * The BilateralTimeLimit
     * Meta information extracted from the WSDL
     * - documentation: A bilaterally agreed limitation or restriction of time.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BilateralTimeLimitType[]
     */
    public $BilateralTimeLimit;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BookingRefType[]
     */
    public $BookingRef;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date time by which the order is created. Examples: 2018-09-05T15:52:01Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTime;
    /**
     * The DepositTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date by which a deposit must be paid for an order Examples: 2015-01-13T13:59:38Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepositTimeLimitDateTime;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date time by which the order is modified. Examples: 2018-09-05T15:52:01Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastModifiedDateTime;
    /**
     * The NamingTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The time by which an Order must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second,
     * and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NamingTimeLimitDateTime;
    /**
     * The OrderItem
     * Meta information extracted from the WSDL
     * - documentation: A changed individually priced item within an Ordered Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangesToOrderItemType[]
     */
    public $OrderItem;
    /**
     * The OrderPenaltyInfoList
     * Meta information extracted from the WSDL
     * - documentation: list of Order Penalty Information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderPenaltyInfoListType
     */
    public $OrderPenaltyInfoList;
    /**
     * The OrderVersionNumber
     * Meta information extracted from the WSDL
     * - documentation: Version of the Order used to track the evolution of an Order and the changes made to it. | Order version number BDT.
     * - base: xs:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OrderVersionNumber;
    /**
     * The OriginalOrderID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Order across several messages. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginalOrderID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The PaxGroup
     * Meta information extracted from the WSDL
     * - documentation: A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency. Group bookings are subject to special booking rules and may be
     * eligible for special fare rules. Usage and nature of groups is left to bilateral agreements.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxGroupType
     */
    public $PaxGroup;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Status instance. See ATSB Codeset OrderStatus for possible values. | The possible statuses of an Order {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Status, coded{/codeListName}
     * {codeListIdentifier}ORDERSTATUS{/codeListIdentifier} | represents the statuses of an Order
     * - base: OrderStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceType
     */
    public $TotalPrice;
    /**
     * The WebAddressURI
     * Meta information extracted from the WSDL
     * - documentation: Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer. | A string of characters used to identify a resource. Such identification
     * enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddressURI;
    /**
     * Constructor method for ChangesToOrderType
     * @uses ChangesToOrderType::setOrderID()
     * @uses ChangesToOrderType::setBilateralTimeLimit()
     * @uses ChangesToOrderType::setBookingRef()
     * @uses ChangesToOrderType::setCommission()
     * @uses ChangesToOrderType::setCreationDateTime()
     * @uses ChangesToOrderType::setDepositTimeLimitDateTime()
     * @uses ChangesToOrderType::setLastModifiedDateTime()
     * @uses ChangesToOrderType::setNamingTimeLimitDateTime()
     * @uses ChangesToOrderType::setOrderItem()
     * @uses ChangesToOrderType::setOrderPenaltyInfoList()
     * @uses ChangesToOrderType::setOrderVersionNumber()
     * @uses ChangesToOrderType::setOriginalOrderID()
     * @uses ChangesToOrderType::setOwnerCode()
     * @uses ChangesToOrderType::setPaxGroup()
     * @uses ChangesToOrderType::setStatusCode()
     * @uses ChangesToOrderType::setTotalPrice()
     * @uses ChangesToOrderType::setWebAddressURI()
     * @param string $orderID
     * @param \StructType\BilateralTimeLimitType[] $bilateralTimeLimit
     * @param \StructType\BookingRefType[] $bookingRef
     * @param \StructType\CommissionType[] $commission
     * @param string $creationDateTime
     * @param string $depositTimeLimitDateTime
     * @param string $lastModifiedDateTime
     * @param string $namingTimeLimitDateTime
     * @param \StructType\ChangesToOrderItemType[] $orderItem
     * @param \StructType\OrderPenaltyInfoListType $orderPenaltyInfoList
     * @param int $orderVersionNumber
     * @param string $originalOrderID
     * @param string $ownerCode
     * @param \StructType\PaxGroupType $paxGroup
     * @param string $statusCode
     * @param \StructType\PriceType $totalPrice
     * @param string $webAddressURI
     */
    public function __construct($orderID = null, array $bilateralTimeLimit = array(), array $bookingRef = array(), array $commission = array(), $creationDateTime = null, $depositTimeLimitDateTime = null, $lastModifiedDateTime = null, $namingTimeLimitDateTime = null, array $orderItem = array(), \StructType\OrderPenaltyInfoListType $orderPenaltyInfoList = null, $orderVersionNumber = null, $originalOrderID = null, $ownerCode = null, \StructType\PaxGroupType $paxGroup = null, $statusCode = null, \StructType\PriceType $totalPrice = null, $webAddressURI = null)
    {
        $this
            ->setOrderID($orderID)
            ->setBilateralTimeLimit($bilateralTimeLimit)
            ->setBookingRef($bookingRef)
            ->setCommission($commission)
            ->setCreationDateTime($creationDateTime)
            ->setDepositTimeLimitDateTime($depositTimeLimitDateTime)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setNamingTimeLimitDateTime($namingTimeLimitDateTime)
            ->setOrderItem($orderItem)
            ->setOrderPenaltyInfoList($orderPenaltyInfoList)
            ->setOrderVersionNumber($orderVersionNumber)
            ->setOriginalOrderID($originalOrderID)
            ->setOwnerCode($ownerCode)
            ->setPaxGroup($paxGroup)
            ->setStatusCode($statusCode)
            ->setTotalPrice($totalPrice)
            ->setWebAddressURI($webAddressURI);
    }
    /**
     * Get OrderID value
     * @return string
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\ChangesToOrderType
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get BilateralTimeLimit value
     * @return \StructType\BilateralTimeLimitType[]|null
     */
    public function getBilateralTimeLimit()
    {
        return $this->BilateralTimeLimit;
    }
    /**
     * This method is responsible for validating the values passed to the setBilateralTimeLimit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBilateralTimeLimit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBilateralTimeLimitForArrayConstraintsFromSetBilateralTimeLimit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderTypeBilateralTimeLimitItem) {
            // validation for constraint: itemType
            if (!$changesToOrderTypeBilateralTimeLimitItem instanceof \StructType\BilateralTimeLimitType) {
                $invalidValues[] = is_object($changesToOrderTypeBilateralTimeLimitItem) ? get_class($changesToOrderTypeBilateralTimeLimitItem) : sprintf('%s(%s)', gettype($changesToOrderTypeBilateralTimeLimitItem), var_export($changesToOrderTypeBilateralTimeLimitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BilateralTimeLimit property can only contain items of type \StructType\BilateralTimeLimitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BilateralTimeLimit value
     * @throws \InvalidArgumentException
     * @param \StructType\BilateralTimeLimitType[] $bilateralTimeLimit
     * @return \StructType\ChangesToOrderType
     */
    public function setBilateralTimeLimit(array $bilateralTimeLimit = array())
    {
        // validation for constraint: array
        if ('' !== ($bilateralTimeLimitArrayErrorMessage = self::validateBilateralTimeLimitForArrayConstraintsFromSetBilateralTimeLimit($bilateralTimeLimit))) {
            throw new \InvalidArgumentException($bilateralTimeLimitArrayErrorMessage, __LINE__);
        }
        $this->BilateralTimeLimit = $bilateralTimeLimit;
        return $this;
    }
    /**
     * Add item to BilateralTimeLimit value
     * @throws \InvalidArgumentException
     * @param \StructType\BilateralTimeLimitType $item
     * @return \StructType\ChangesToOrderType
     */
    public function addToBilateralTimeLimit(\StructType\BilateralTimeLimitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BilateralTimeLimitType) {
            throw new \InvalidArgumentException(sprintf('The BilateralTimeLimit property can only contain items of type \StructType\BilateralTimeLimitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BilateralTimeLimit[] = $item;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return \StructType\BookingRefType[]|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingRefForArrayConstraintsFromSetBookingRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderTypeBookingRefItem) {
            // validation for constraint: itemType
            if (!$changesToOrderTypeBookingRefItem instanceof \StructType\BookingRefType) {
                $invalidValues[] = is_object($changesToOrderTypeBookingRefItem) ? get_class($changesToOrderTypeBookingRefItem) : sprintf('%s(%s)', gettype($changesToOrderTypeBookingRefItem), var_export($changesToOrderTypeBookingRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType[] $bookingRef
     * @return \StructType\ChangesToOrderType
     */
    public function setBookingRef(array $bookingRef = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingRefArrayErrorMessage = self::validateBookingRefForArrayConstraintsFromSetBookingRef($bookingRef))) {
            throw new \InvalidArgumentException($bookingRefArrayErrorMessage, __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Add item to BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType $item
     * @return \StructType\ChangesToOrderType
     */
    public function addToBookingRef(\StructType\BookingRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingRefType) {
            throw new \InvalidArgumentException(sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BookingRef[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$changesToOrderTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($changesToOrderTypeCommissionItem) ? get_class($changesToOrderTypeCommissionItem) : sprintf('%s(%s)', gettype($changesToOrderTypeCommissionItem), var_export($changesToOrderTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\ChangesToOrderType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\ChangesToOrderType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get CreationDateTime value
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\ChangesToOrderType
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get DepositTimeLimitDateTime value
     * @return string|null
     */
    public function getDepositTimeLimitDateTime()
    {
        return $this->DepositTimeLimitDateTime;
    }
    /**
     * Set DepositTimeLimitDateTime value
     * @param string $depositTimeLimitDateTime
     * @return \StructType\ChangesToOrderType
     */
    public function setDepositTimeLimitDateTime($depositTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($depositTimeLimitDateTime) && !is_string($depositTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositTimeLimitDateTime, true), gettype($depositTimeLimitDateTime)), __LINE__);
        }
        $this->DepositTimeLimitDateTime = $depositTimeLimitDateTime;
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * @return string|null
     */
    public function getLastModifiedDateTime()
    {
        return $this->LastModifiedDateTime;
    }
    /**
     * Set LastModifiedDateTime value
     * @param string $lastModifiedDateTime
     * @return \StructType\ChangesToOrderType
     */
    public function setLastModifiedDateTime($lastModifiedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDateTime) && !is_string($lastModifiedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDateTime, true), gettype($lastModifiedDateTime)), __LINE__);
        }
        $this->LastModifiedDateTime = $lastModifiedDateTime;
        return $this;
    }
    /**
     * Get NamingTimeLimitDateTime value
     * @return string|null
     */
    public function getNamingTimeLimitDateTime()
    {
        return $this->NamingTimeLimitDateTime;
    }
    /**
     * Set NamingTimeLimitDateTime value
     * @param string $namingTimeLimitDateTime
     * @return \StructType\ChangesToOrderType
     */
    public function setNamingTimeLimitDateTime($namingTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($namingTimeLimitDateTime) && !is_string($namingTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namingTimeLimitDateTime, true), gettype($namingTimeLimitDateTime)), __LINE__);
        }
        $this->NamingTimeLimitDateTime = $namingTimeLimitDateTime;
        return $this;
    }
    /**
     * Get OrderItem value
     * @return \StructType\ChangesToOrderItemType[]|null
     */
    public function getOrderItem()
    {
        return $this->OrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemForArrayConstraintsFromSetOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderTypeOrderItemItem) {
            // validation for constraint: itemType
            if (!$changesToOrderTypeOrderItemItem instanceof \StructType\ChangesToOrderItemType) {
                $invalidValues[] = is_object($changesToOrderTypeOrderItemItem) ? get_class($changesToOrderTypeOrderItemItem) : sprintf('%s(%s)', gettype($changesToOrderTypeOrderItemItem), var_export($changesToOrderTypeOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderItem property can only contain items of type \StructType\ChangesToOrderItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangesToOrderItemType[] $orderItem
     * @return \StructType\ChangesToOrderType
     */
    public function setOrderItem(array $orderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemArrayErrorMessage = self::validateOrderItemForArrayConstraintsFromSetOrderItem($orderItem))) {
            throw new \InvalidArgumentException($orderItemArrayErrorMessage, __LINE__);
        }
        $this->OrderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to OrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangesToOrderItemType $item
     * @return \StructType\ChangesToOrderType
     */
    public function addToOrderItem(\StructType\ChangesToOrderItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangesToOrderItemType) {
            throw new \InvalidArgumentException(sprintf('The OrderItem property can only contain items of type \StructType\ChangesToOrderItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderItem[] = $item;
        return $this;
    }
    /**
     * Get OrderPenaltyInfoList value
     * @return \StructType\OrderPenaltyInfoListType|null
     */
    public function getOrderPenaltyInfoList()
    {
        return $this->OrderPenaltyInfoList;
    }
    /**
     * Set OrderPenaltyInfoList value
     * @param \StructType\OrderPenaltyInfoListType $orderPenaltyInfoList
     * @return \StructType\ChangesToOrderType
     */
    public function setOrderPenaltyInfoList(\StructType\OrderPenaltyInfoListType $orderPenaltyInfoList = null)
    {
        $this->OrderPenaltyInfoList = $orderPenaltyInfoList;
        return $this;
    }
    /**
     * Get OrderVersionNumber value
     * @return int|null
     */
    public function getOrderVersionNumber()
    {
        return $this->OrderVersionNumber;
    }
    /**
     * Set OrderVersionNumber value
     * @param int $orderVersionNumber
     * @return \StructType\ChangesToOrderType
     */
    public function setOrderVersionNumber($orderVersionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderVersionNumber) && !(is_int($orderVersionNumber) || ctype_digit($orderVersionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderVersionNumber, true), gettype($orderVersionNumber)), __LINE__);
        }
        $this->OrderVersionNumber = $orderVersionNumber;
        return $this;
    }
    /**
     * Get OriginalOrderID value
     * @return string|null
     */
    public function getOriginalOrderID()
    {
        return $this->OriginalOrderID;
    }
    /**
     * Set OriginalOrderID value
     * @param string $originalOrderID
     * @return \StructType\ChangesToOrderType
     */
    public function setOriginalOrderID($originalOrderID = null)
    {
        // validation for constraint: string
        if (!is_null($originalOrderID) && !is_string($originalOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalOrderID, true), gettype($originalOrderID)), __LINE__);
        }
        $this->OriginalOrderID = $originalOrderID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string|null
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\ChangesToOrderType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get PaxGroup value
     * @return \StructType\PaxGroupType|null
     */
    public function getPaxGroup()
    {
        return $this->PaxGroup;
    }
    /**
     * Set PaxGroup value
     * @param \StructType\PaxGroupType $paxGroup
     * @return \StructType\ChangesToOrderType
     */
    public function setPaxGroup(\StructType\PaxGroupType $paxGroup = null)
    {
        $this->PaxGroup = $paxGroup;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\ChangesToOrderType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \StructType\PriceType|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \StructType\PriceType $totalPrice
     * @return \StructType\ChangesToOrderType
     */
    public function setTotalPrice(\StructType\PriceType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get WebAddressURI value
     * @return string|null
     */
    public function getWebAddressURI()
    {
        return $this->WebAddressURI;
    }
    /**
     * Set WebAddressURI value
     * @param string $webAddressURI
     * @return \StructType\ChangesToOrderType
     */
    public function setWebAddressURI($webAddressURI = null)
    {
        // validation for constraint: string
        if (!is_null($webAddressURI) && !is_string($webAddressURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddressURI, true), gettype($webAddressURI)), __LINE__);
        }
        $this->WebAddressURI = $webAddressURI;
        return $this;
    }
}
