<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangesToOrderItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: A changed individually priced item within an Ordered Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
 * @subpackage Structs
 */
class ChangesToOrderItemType extends AbstractStructBase
{
    /**
     * The OrderItemID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Order. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderItemID;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The BilateralTimeLimit
     * Meta information extracted from the WSDL
     * - documentation: A bilaterally agreed limitation or restriction of time.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BilateralTimeLimitType[]
     */
    public $BilateralTimeLimit;
    /**
     * The CabinTypeList
     * Meta information extracted from the WSDL
     * - documentation: List of Cabin Types Technical object only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CabinTypeListType
     */
    public $CabinTypeList;
    /**
     * The CancelRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restrictions that are related to a constrained priced grouping of services for the Cancellation action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CancelRestrictionsType[]
     */
    public $CancelRestrictions;
    /**
     * The ChangeRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restriction that are related to a constrained priced grouping of services for a Change/modification action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangeRestrictionsType[]
     */
    public $ChangeRestrictions;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - documentation: Order Item creation Timestamp. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTime;
    /**
     * The DepositTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date by which a deposit must be paid for an order item. Examples: 2015-01-13T13:59:38Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of
     * second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepositTimeLimitDateTime;
    /**
     * The DiffPrice
     * Meta information extracted from the WSDL
     * - documentation: For each OfferItem, this function allows the airline to inform the seller about amount differential type if this OfferItem is chosen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PriceDifferentialType[]
     */
    public $DiffPrice;
    /**
     * The DisclosureRefID
     * Meta information extracted from the WSDL
     * - documentation: References a Disclosure ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DisclosureRefID;
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareDetailType[]
     */
    public $FareDetail;
    /**
     * The GrandTotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Reflects the Differential Total Amount and the Penalty Total Amount, if netted.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $GrandTotalAmount;
    /**
     * The NamingTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The time by which an Order Item must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute,
     * second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NamingTimeLimitDateTime;
    /**
     * The NetInd
     * Meta information extracted from the WSDL
     * - documentation: The airline informs the seller if the penalty is netted (True) (i.e. taken from any amount that airline will owe to customer consequently to the servicing) or to be paid (False) (i.e. charged to customer upfront any servicing action,
     * and even if customer benefits from a subsequent refund/ residual value). | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NetInd;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The PaymentTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The time limit by which a commitment to pay must be made for the given Order Item. Upon expiry it is expected that the Order item is removed from the Order. If no value is returned, then no advice has been given. For example:
     * PaymentTimeLimitDateTime: 2015-01-01T12:53:12Z - indicates the date time by which payment commitment is required. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and
     * fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTimeLimitDateTime;
    /**
     * The PenaltyRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Penalty ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PenaltyRefID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * The PriceGuaranteeTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time the price of an Order Item is guaranteed. In the absence of the price guarantee time limit, the price is not guaranteed. Upon expiry, the price may no longer be guaranteed and either the Order should be repriced,
     * which may result in a new RepricedOffer, or a new shopping process may begin. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceGuaranteeTimeLimitDateTime;
    /**
     * The ReusableInd
     * Meta information extracted from the WSDL
     * - documentation: If Reusable = true, indicates that part of the value of the OrderItem may be reused for reshopping or refund. Exact reusable amount is unknown until Seller requests to reshop or to process a refund for this OrderItem. | An indicator
     * is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ReusableInd;
    /**
     * The SellerFollowUpAction
     * Meta information extracted from the WSDL
     * - documentation: A seller followup action following involuntary change means a subsequent action required to an Order Item after a schedule change.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SellerFollowUpActionType
     */
    public $SellerFollowUpAction;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: A change to Service specialization of the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a
     * service can be sold to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangeToServiceType[]
     */
    public $Service;
    /**
     * The SpecialServiceList
     * Meta information extracted from the WSDL
     * - documentation: List of Special service types. Technical object only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SpecialServiceListType
     */
    public $SpecialServiceList;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Item Status instance. See ATSB Codeset OrderItem for possible values. | The possible statuses of an Order Item {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Item Status,
     * Coded.{/codeListName} {codeListIdentifier}ORDERITEM{/codeListIdentifier} | represents the status of an Order Item
     * - base: OrderItemStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The WebAddressURI
     * Meta information extracted from the WSDL
     * - documentation: Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer. | A string of characters used to identify a resource. Such identification
     * enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddressURI;
    /**
     * Constructor method for ChangesToOrderItemType
     * @uses ChangesToOrderItemType::setOrderItemID()
     * @uses ChangesToOrderItemType::setAirlineTaxonomy()
     * @uses ChangesToOrderItemType::setBilateralTimeLimit()
     * @uses ChangesToOrderItemType::setCabinTypeList()
     * @uses ChangesToOrderItemType::setCancelRestrictions()
     * @uses ChangesToOrderItemType::setChangeRestrictions()
     * @uses ChangesToOrderItemType::setCommission()
     * @uses ChangesToOrderItemType::setCreationDateTime()
     * @uses ChangesToOrderItemType::setDepositTimeLimitDateTime()
     * @uses ChangesToOrderItemType::setDiffPrice()
     * @uses ChangesToOrderItemType::setDisclosureRefID()
     * @uses ChangesToOrderItemType::setFareDetail()
     * @uses ChangesToOrderItemType::setGrandTotalAmount()
     * @uses ChangesToOrderItemType::setNamingTimeLimitDateTime()
     * @uses ChangesToOrderItemType::setNetInd()
     * @uses ChangesToOrderItemType::setOwnerCode()
     * @uses ChangesToOrderItemType::setPaymentTimeLimitDateTime()
     * @uses ChangesToOrderItemType::setPenaltyRefID()
     * @uses ChangesToOrderItemType::setPrice()
     * @uses ChangesToOrderItemType::setPriceGuaranteeTimeLimitDateTime()
     * @uses ChangesToOrderItemType::setReusableInd()
     * @uses ChangesToOrderItemType::setSellerFollowUpAction()
     * @uses ChangesToOrderItemType::setService()
     * @uses ChangesToOrderItemType::setSpecialServiceList()
     * @uses ChangesToOrderItemType::setStatusCode()
     * @uses ChangesToOrderItemType::setWebAddressURI()
     * @param string $orderItemID
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param \StructType\BilateralTimeLimitType[] $bilateralTimeLimit
     * @param \StructType\CabinTypeListType $cabinTypeList
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @param \StructType\CommissionType[] $commission
     * @param string $creationDateTime
     * @param string $depositTimeLimitDateTime
     * @param \StructType\PriceDifferentialType[] $diffPrice
     * @param string[] $disclosureRefID
     * @param \StructType\FareDetailType[] $fareDetail
     * @param \StructType\AmountType $grandTotalAmount
     * @param string $namingTimeLimitDateTime
     * @param bool $netInd
     * @param string $ownerCode
     * @param string $paymentTimeLimitDateTime
     * @param string[] $penaltyRefID
     * @param \StructType\PriceType $price
     * @param string $priceGuaranteeTimeLimitDateTime
     * @param bool $reusableInd
     * @param \StructType\SellerFollowUpActionType $sellerFollowUpAction
     * @param \StructType\ChangeToServiceType[] $service
     * @param \StructType\SpecialServiceListType $specialServiceList
     * @param string $statusCode
     * @param string $webAddressURI
     */
    public function __construct($orderItemID = null, array $airlineTaxonomy = array(), array $bilateralTimeLimit = array(), \StructType\CabinTypeListType $cabinTypeList = null, array $cancelRestrictions = array(), array $changeRestrictions = array(), array $commission = array(), $creationDateTime = null, $depositTimeLimitDateTime = null, array $diffPrice = array(), array $disclosureRefID = array(), array $fareDetail = array(), \StructType\AmountType $grandTotalAmount = null, $namingTimeLimitDateTime = null, $netInd = null, $ownerCode = null, $paymentTimeLimitDateTime = null, array $penaltyRefID = array(), \StructType\PriceType $price = null, $priceGuaranteeTimeLimitDateTime = null, $reusableInd = null, \StructType\SellerFollowUpActionType $sellerFollowUpAction = null, array $service = array(), \StructType\SpecialServiceListType $specialServiceList = null, $statusCode = null, $webAddressURI = null)
    {
        $this
            ->setOrderItemID($orderItemID)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setBilateralTimeLimit($bilateralTimeLimit)
            ->setCabinTypeList($cabinTypeList)
            ->setCancelRestrictions($cancelRestrictions)
            ->setChangeRestrictions($changeRestrictions)
            ->setCommission($commission)
            ->setCreationDateTime($creationDateTime)
            ->setDepositTimeLimitDateTime($depositTimeLimitDateTime)
            ->setDiffPrice($diffPrice)
            ->setDisclosureRefID($disclosureRefID)
            ->setFareDetail($fareDetail)
            ->setGrandTotalAmount($grandTotalAmount)
            ->setNamingTimeLimitDateTime($namingTimeLimitDateTime)
            ->setNetInd($netInd)
            ->setOwnerCode($ownerCode)
            ->setPaymentTimeLimitDateTime($paymentTimeLimitDateTime)
            ->setPenaltyRefID($penaltyRefID)
            ->setPrice($price)
            ->setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime)
            ->setReusableInd($reusableInd)
            ->setSellerFollowUpAction($sellerFollowUpAction)
            ->setService($service)
            ->setSpecialServiceList($specialServiceList)
            ->setStatusCode($statusCode)
            ->setWebAddressURI($webAddressURI);
    }
    /**
     * Get OrderItemID value
     * @return string
     */
    public function getOrderItemID()
    {
        return $this->OrderItemID;
    }
    /**
     * Set OrderItemID value
     * @param string $orderItemID
     * @return \StructType\ChangesToOrderItemType
     */
    public function setOrderItemID($orderItemID = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemID) && !is_string($orderItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemID, true), gettype($orderItemID)), __LINE__);
        }
        $this->OrderItemID = $orderItemID;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderItemTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$changesToOrderItemTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($changesToOrderItemTypeAirlineTaxonomyItem) ? get_class($changesToOrderItemTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($changesToOrderItemTypeAirlineTaxonomyItem), var_export($changesToOrderItemTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\ChangesToOrderItemType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\ChangesToOrderItemType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get BilateralTimeLimit value
     * @return \StructType\BilateralTimeLimitType[]|null
     */
    public function getBilateralTimeLimit()
    {
        return $this->BilateralTimeLimit;
    }
    /**
     * This method is responsible for validating the values passed to the setBilateralTimeLimit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBilateralTimeLimit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBilateralTimeLimitForArrayConstraintsFromSetBilateralTimeLimit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderItemTypeBilateralTimeLimitItem) {
            // validation for constraint: itemType
            if (!$changesToOrderItemTypeBilateralTimeLimitItem instanceof \StructType\BilateralTimeLimitType) {
                $invalidValues[] = is_object($changesToOrderItemTypeBilateralTimeLimitItem) ? get_class($changesToOrderItemTypeBilateralTimeLimitItem) : sprintf('%s(%s)', gettype($changesToOrderItemTypeBilateralTimeLimitItem), var_export($changesToOrderItemTypeBilateralTimeLimitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BilateralTimeLimit property can only contain items of type \StructType\BilateralTimeLimitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BilateralTimeLimit value
     * @throws \InvalidArgumentException
     * @param \StructType\BilateralTimeLimitType[] $bilateralTimeLimit
     * @return \StructType\ChangesToOrderItemType
     */
    public function setBilateralTimeLimit(array $bilateralTimeLimit = array())
    {
        // validation for constraint: array
        if ('' !== ($bilateralTimeLimitArrayErrorMessage = self::validateBilateralTimeLimitForArrayConstraintsFromSetBilateralTimeLimit($bilateralTimeLimit))) {
            throw new \InvalidArgumentException($bilateralTimeLimitArrayErrorMessage, __LINE__);
        }
        $this->BilateralTimeLimit = $bilateralTimeLimit;
        return $this;
    }
    /**
     * Add item to BilateralTimeLimit value
     * @throws \InvalidArgumentException
     * @param \StructType\BilateralTimeLimitType $item
     * @return \StructType\ChangesToOrderItemType
     */
    public function addToBilateralTimeLimit(\StructType\BilateralTimeLimitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BilateralTimeLimitType) {
            throw new \InvalidArgumentException(sprintf('The BilateralTimeLimit property can only contain items of type \StructType\BilateralTimeLimitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BilateralTimeLimit[] = $item;
        return $this;
    }
    /**
     * Get CabinTypeList value
     * @return \StructType\CabinTypeListType|null
     */
    public function getCabinTypeList()
    {
        return $this->CabinTypeList;
    }
    /**
     * Set CabinTypeList value
     * @param \StructType\CabinTypeListType $cabinTypeList
     * @return \StructType\ChangesToOrderItemType
     */
    public function setCabinTypeList(\StructType\CabinTypeListType $cabinTypeList = null)
    {
        $this->CabinTypeList = $cabinTypeList;
        return $this;
    }
    /**
     * Get CancelRestrictions value
     * @return \StructType\CancelRestrictionsType[]|null
     */
    public function getCancelRestrictions()
    {
        return $this->CancelRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderItemTypeCancelRestrictionsItem) {
            // validation for constraint: itemType
            if (!$changesToOrderItemTypeCancelRestrictionsItem instanceof \StructType\CancelRestrictionsType) {
                $invalidValues[] = is_object($changesToOrderItemTypeCancelRestrictionsItem) ? get_class($changesToOrderItemTypeCancelRestrictionsItem) : sprintf('%s(%s)', gettype($changesToOrderItemTypeCancelRestrictionsItem), var_export($changesToOrderItemTypeCancelRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @return \StructType\ChangesToOrderItemType
     */
    public function setCancelRestrictions(array $cancelRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelRestrictionsArrayErrorMessage = self::validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions($cancelRestrictions))) {
            throw new \InvalidArgumentException($cancelRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->CancelRestrictions = $cancelRestrictions;
        return $this;
    }
    /**
     * Add item to CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType $item
     * @return \StructType\ChangesToOrderItemType
     */
    public function addToCancelRestrictions(\StructType\CancelRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancelRestrictions[] = $item;
        return $this;
    }
    /**
     * Get ChangeRestrictions value
     * @return \StructType\ChangeRestrictionsType[]|null
     */
    public function getChangeRestrictions()
    {
        return $this->ChangeRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderItemTypeChangeRestrictionsItem) {
            // validation for constraint: itemType
            if (!$changesToOrderItemTypeChangeRestrictionsItem instanceof \StructType\ChangeRestrictionsType) {
                $invalidValues[] = is_object($changesToOrderItemTypeChangeRestrictionsItem) ? get_class($changesToOrderItemTypeChangeRestrictionsItem) : sprintf('%s(%s)', gettype($changesToOrderItemTypeChangeRestrictionsItem), var_export($changesToOrderItemTypeChangeRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @return \StructType\ChangesToOrderItemType
     */
    public function setChangeRestrictions(array $changeRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($changeRestrictionsArrayErrorMessage = self::validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions($changeRestrictions))) {
            throw new \InvalidArgumentException($changeRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->ChangeRestrictions = $changeRestrictions;
        return $this;
    }
    /**
     * Add item to ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType $item
     * @return \StructType\ChangesToOrderItemType
     */
    public function addToChangeRestrictions(\StructType\ChangeRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeRestrictions[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderItemTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$changesToOrderItemTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($changesToOrderItemTypeCommissionItem) ? get_class($changesToOrderItemTypeCommissionItem) : sprintf('%s(%s)', gettype($changesToOrderItemTypeCommissionItem), var_export($changesToOrderItemTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\ChangesToOrderItemType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\ChangesToOrderItemType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get CreationDateTime value
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\ChangesToOrderItemType
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get DepositTimeLimitDateTime value
     * @return string|null
     */
    public function getDepositTimeLimitDateTime()
    {
        return $this->DepositTimeLimitDateTime;
    }
    /**
     * Set DepositTimeLimitDateTime value
     * @param string $depositTimeLimitDateTime
     * @return \StructType\ChangesToOrderItemType
     */
    public function setDepositTimeLimitDateTime($depositTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($depositTimeLimitDateTime) && !is_string($depositTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositTimeLimitDateTime, true), gettype($depositTimeLimitDateTime)), __LINE__);
        }
        $this->DepositTimeLimitDateTime = $depositTimeLimitDateTime;
        return $this;
    }
    /**
     * Get DiffPrice value
     * @return \StructType\PriceDifferentialType[]|null
     */
    public function getDiffPrice()
    {
        return $this->DiffPrice;
    }
    /**
     * This method is responsible for validating the values passed to the setDiffPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiffPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiffPriceForArrayConstraintsFromSetDiffPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderItemTypeDiffPriceItem) {
            // validation for constraint: itemType
            if (!$changesToOrderItemTypeDiffPriceItem instanceof \StructType\PriceDifferentialType) {
                $invalidValues[] = is_object($changesToOrderItemTypeDiffPriceItem) ? get_class($changesToOrderItemTypeDiffPriceItem) : sprintf('%s(%s)', gettype($changesToOrderItemTypeDiffPriceItem), var_export($changesToOrderItemTypeDiffPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiffPrice property can only contain items of type \StructType\PriceDifferentialType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiffPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceDifferentialType[] $diffPrice
     * @return \StructType\ChangesToOrderItemType
     */
    public function setDiffPrice(array $diffPrice = array())
    {
        // validation for constraint: array
        if ('' !== ($diffPriceArrayErrorMessage = self::validateDiffPriceForArrayConstraintsFromSetDiffPrice($diffPrice))) {
            throw new \InvalidArgumentException($diffPriceArrayErrorMessage, __LINE__);
        }
        $this->DiffPrice = $diffPrice;
        return $this;
    }
    /**
     * Add item to DiffPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceDifferentialType $item
     * @return \StructType\ChangesToOrderItemType
     */
    public function addToDiffPrice(\StructType\PriceDifferentialType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PriceDifferentialType) {
            throw new \InvalidArgumentException(sprintf('The DiffPrice property can only contain items of type \StructType\PriceDifferentialType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiffPrice[] = $item;
        return $this;
    }
    /**
     * Get DisclosureRefID value
     * @return string[]|null
     */
    public function getDisclosureRefID()
    {
        return $this->DisclosureRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDisclosureRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisclosureRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisclosureRefIDForArrayConstraintsFromSetDisclosureRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderItemTypeDisclosureRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($changesToOrderItemTypeDisclosureRefIDItem)) {
                $invalidValues[] = is_object($changesToOrderItemTypeDisclosureRefIDItem) ? get_class($changesToOrderItemTypeDisclosureRefIDItem) : sprintf('%s(%s)', gettype($changesToOrderItemTypeDisclosureRefIDItem), var_export($changesToOrderItemTypeDisclosureRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DisclosureRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DisclosureRefID value
     * @throws \InvalidArgumentException
     * @param string[] $disclosureRefID
     * @return \StructType\ChangesToOrderItemType
     */
    public function setDisclosureRefID(array $disclosureRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($disclosureRefIDArrayErrorMessage = self::validateDisclosureRefIDForArrayConstraintsFromSetDisclosureRefID($disclosureRefID))) {
            throw new \InvalidArgumentException($disclosureRefIDArrayErrorMessage, __LINE__);
        }
        $this->DisclosureRefID = $disclosureRefID;
        return $this;
    }
    /**
     * Add item to DisclosureRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ChangesToOrderItemType
     */
    public function addToDisclosureRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DisclosureRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DisclosureRefID[] = $item;
        return $this;
    }
    /**
     * Get FareDetail value
     * @return \StructType\FareDetailType[]|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFareDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareDetailForArrayConstraintsFromSetFareDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderItemTypeFareDetailItem) {
            // validation for constraint: itemType
            if (!$changesToOrderItemTypeFareDetailItem instanceof \StructType\FareDetailType) {
                $invalidValues[] = is_object($changesToOrderItemTypeFareDetailItem) ? get_class($changesToOrderItemTypeFareDetailItem) : sprintf('%s(%s)', gettype($changesToOrderItemTypeFareDetailItem), var_export($changesToOrderItemTypeFareDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType[] $fareDetail
     * @return \StructType\ChangesToOrderItemType
     */
    public function setFareDetail(array $fareDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fareDetailArrayErrorMessage = self::validateFareDetailForArrayConstraintsFromSetFareDetail($fareDetail))) {
            throw new \InvalidArgumentException($fareDetailArrayErrorMessage, __LINE__);
        }
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Add item to FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType $item
     * @return \StructType\ChangesToOrderItemType
     */
    public function addToFareDetail(\StructType\FareDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareDetailType) {
            throw new \InvalidArgumentException(sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareDetail[] = $item;
        return $this;
    }
    /**
     * Get GrandTotalAmount value
     * @return \StructType\AmountType|null
     */
    public function getGrandTotalAmount()
    {
        return $this->GrandTotalAmount;
    }
    /**
     * Set GrandTotalAmount value
     * @param \StructType\AmountType $grandTotalAmount
     * @return \StructType\ChangesToOrderItemType
     */
    public function setGrandTotalAmount(\StructType\AmountType $grandTotalAmount = null)
    {
        $this->GrandTotalAmount = $grandTotalAmount;
        return $this;
    }
    /**
     * Get NamingTimeLimitDateTime value
     * @return string|null
     */
    public function getNamingTimeLimitDateTime()
    {
        return $this->NamingTimeLimitDateTime;
    }
    /**
     * Set NamingTimeLimitDateTime value
     * @param string $namingTimeLimitDateTime
     * @return \StructType\ChangesToOrderItemType
     */
    public function setNamingTimeLimitDateTime($namingTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($namingTimeLimitDateTime) && !is_string($namingTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namingTimeLimitDateTime, true), gettype($namingTimeLimitDateTime)), __LINE__);
        }
        $this->NamingTimeLimitDateTime = $namingTimeLimitDateTime;
        return $this;
    }
    /**
     * Get NetInd value
     * @return bool|null
     */
    public function getNetInd()
    {
        return $this->NetInd;
    }
    /**
     * Set NetInd value
     * @param bool $netInd
     * @return \StructType\ChangesToOrderItemType
     */
    public function setNetInd($netInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($netInd) && !is_bool($netInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($netInd, true), gettype($netInd)), __LINE__);
        }
        $this->NetInd = $netInd;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string|null
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\ChangesToOrderItemType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get PaymentTimeLimitDateTime value
     * @return string|null
     */
    public function getPaymentTimeLimitDateTime()
    {
        return $this->PaymentTimeLimitDateTime;
    }
    /**
     * Set PaymentTimeLimitDateTime value
     * @param string $paymentTimeLimitDateTime
     * @return \StructType\ChangesToOrderItemType
     */
    public function setPaymentTimeLimitDateTime($paymentTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTimeLimitDateTime) && !is_string($paymentTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTimeLimitDateTime, true), gettype($paymentTimeLimitDateTime)), __LINE__);
        }
        $this->PaymentTimeLimitDateTime = $paymentTimeLimitDateTime;
        return $this;
    }
    /**
     * Get PenaltyRefID value
     * @return string[]|null
     */
    public function getPenaltyRefID()
    {
        return $this->PenaltyRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderItemTypePenaltyRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($changesToOrderItemTypePenaltyRefIDItem)) {
                $invalidValues[] = is_object($changesToOrderItemTypePenaltyRefIDItem) ? get_class($changesToOrderItemTypePenaltyRefIDItem) : sprintf('%s(%s)', gettype($changesToOrderItemTypePenaltyRefIDItem), var_export($changesToOrderItemTypePenaltyRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string[] $penaltyRefID
     * @return \StructType\ChangesToOrderItemType
     */
    public function setPenaltyRefID(array $penaltyRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyRefIDArrayErrorMessage = self::validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID($penaltyRefID))) {
            throw new \InvalidArgumentException($penaltyRefIDArrayErrorMessage, __LINE__);
        }
        $this->PenaltyRefID = $penaltyRefID;
        return $this;
    }
    /**
     * Add item to PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ChangesToOrderItemType
     */
    public function addToPenaltyRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyRefID[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\ChangesToOrderItemType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PriceGuaranteeTimeLimitDateTime value
     * @return string|null
     */
    public function getPriceGuaranteeTimeLimitDateTime()
    {
        return $this->PriceGuaranteeTimeLimitDateTime;
    }
    /**
     * Set PriceGuaranteeTimeLimitDateTime value
     * @param string $priceGuaranteeTimeLimitDateTime
     * @return \StructType\ChangesToOrderItemType
     */
    public function setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($priceGuaranteeTimeLimitDateTime) && !is_string($priceGuaranteeTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceGuaranteeTimeLimitDateTime, true), gettype($priceGuaranteeTimeLimitDateTime)), __LINE__);
        }
        $this->PriceGuaranteeTimeLimitDateTime = $priceGuaranteeTimeLimitDateTime;
        return $this;
    }
    /**
     * Get ReusableInd value
     * @return bool|null
     */
    public function getReusableInd()
    {
        return $this->ReusableInd;
    }
    /**
     * Set ReusableInd value
     * @param bool $reusableInd
     * @return \StructType\ChangesToOrderItemType
     */
    public function setReusableInd($reusableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($reusableInd) && !is_bool($reusableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reusableInd, true), gettype($reusableInd)), __LINE__);
        }
        $this->ReusableInd = $reusableInd;
        return $this;
    }
    /**
     * Get SellerFollowUpAction value
     * @return \StructType\SellerFollowUpActionType|null
     */
    public function getSellerFollowUpAction()
    {
        return $this->SellerFollowUpAction;
    }
    /**
     * Set SellerFollowUpAction value
     * @param \StructType\SellerFollowUpActionType $sellerFollowUpAction
     * @return \StructType\ChangesToOrderItemType
     */
    public function setSellerFollowUpAction(\StructType\SellerFollowUpActionType $sellerFollowUpAction = null)
    {
        $this->SellerFollowUpAction = $sellerFollowUpAction;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\ChangeToServiceType[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changesToOrderItemTypeServiceItem) {
            // validation for constraint: itemType
            if (!$changesToOrderItemTypeServiceItem instanceof \StructType\ChangeToServiceType) {
                $invalidValues[] = is_object($changesToOrderItemTypeServiceItem) ? get_class($changesToOrderItemTypeServiceItem) : sprintf('%s(%s)', gettype($changesToOrderItemTypeServiceItem), var_export($changesToOrderItemTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\ChangeToServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeToServiceType[] $service
     * @return \StructType\ChangesToOrderItemType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeToServiceType $item
     * @return \StructType\ChangesToOrderItemType
     */
    public function addToService(\StructType\ChangeToServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeToServiceType) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\ChangeToServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get SpecialServiceList value
     * @return \StructType\SpecialServiceListType|null
     */
    public function getSpecialServiceList()
    {
        return $this->SpecialServiceList;
    }
    /**
     * Set SpecialServiceList value
     * @param \StructType\SpecialServiceListType $specialServiceList
     * @return \StructType\ChangesToOrderItemType
     */
    public function setSpecialServiceList(\StructType\SpecialServiceListType $specialServiceList = null)
    {
        $this->SpecialServiceList = $specialServiceList;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\ChangesToOrderItemType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get WebAddressURI value
     * @return string|null
     */
    public function getWebAddressURI()
    {
        return $this->WebAddressURI;
    }
    /**
     * Set WebAddressURI value
     * @param string $webAddressURI
     * @return \StructType\ChangesToOrderItemType
     */
    public function setWebAddressURI($webAddressURI = null)
    {
        // validation for constraint: string
        if (!is_null($webAddressURI) && !is_string($webAddressURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddressURI, true), gettype($webAddressURI)), __LINE__);
        }
        $this->WebAddressURI = $webAddressURI;
        return $this;
    }
}
