<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangedOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: Changed Offer: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is
 * defined as a container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple
 * flight-related Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response]
 * Shopping Response ID - Offer ID - [Carrier] Airline Designator Code
 * @subpackage Structs
 */
class ChangedOfferType extends AbstractStructBase
{
    /**
     * The OfferID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Offer across several messages. Offer ID facilitates the tracking and verification of individually priced offer(s) selected from the shopping response. Only the Offer IDs of the
     * ORA (Offer Responsible Airline) are returned in shopping responses. Offer ID is unique to each individually priced offer in the shopping response even if the offer price is zero. Offer ID may be specific to individual passengers in the offer, and may
     * be associated with a segment or a journey. The set of Offer IDs returned in a response are referenced by a Shopping Response ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme
     * that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The AddedOfferItem
     * Meta information extracted from the WSDL
     * - documentation: A priced grouping of one or more services within an Added Offer. The Offer Item assigns a total price for all included services for all passengers and all segments referenced. Once constructed, the OfferItem cannot be modified.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AddedOfferItemType[]
     */
    public $AddedOfferItem;
    /**
     * The BaggageAssociations
     * Meta information extracted from the WSDL
     * - documentation: An association of baggage allowances to passengers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BaggageAssociationsType[]
     */
    public $BaggageAssociations;
    /**
     * The BaggageDisclosureRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Bag Disclosure ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $BaggageDisclosureRefID;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The DeleteOrderItem
     * Meta information extracted from the WSDL
     * - documentation: OrderItems which the Airline confirms can be deleted in a subsequent OrderChangeRQ. Optionally, a price differential (e.g. refund amounts) can be added to each OrderItem occurrence being deleted. Should not be used for 'replace' type
     * functions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderItemDeletionOfferItemType[]
     */
    public $DeleteOrderItem;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DescType[]
     */
    public $Desc;
    /**
     * The DisclosureRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Disclosure ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisclosureRefID;
    /**
     * The ForfeitedInfoList
     * Meta information extracted from the WSDL
     * - documentation: list of Order Forfeited Information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferForfeitedInfoListType
     */
    public $ForfeitedInfoList;
    /**
     * The JourneyOverview
     * Meta information extracted from the WSDL
     * - documentation: Summary of proposed Journey information in the context of this specific Offer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JourneyOverviewType
     */
    public $JourneyOverview;
    /**
     * The MatchAppText
     * Meta information extracted from the WSDL
     * - documentation: Specifies which type of flight request the match information relate to (examples: Attribute, Affinity, Other). | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MatchAppText;
    /**
     * The MatchPercent
     * Meta information extracted from the WSDL
     * - documentation: Offer match percentage to shopping criteria type. This information should be populated when there is a partial match of the initial shopping criteria. Example: 60 | A percent is a value representing a fraction of one
     * hundred,expressed as a quotient.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MatchPercent;
    /**
     * The MatchTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Offer match to shopping criteria type. Examples: Full, None, Partial, Other Note: An additional percentage qualifier, such as 50%, may be specified for a Partial match. | Data type for Offer Match Result ENUMs.
     * - base: MatchTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MatchTypeCode;
    /**
     * The OfferExpirationTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time an offer will persist in an airline's offer management system for use in subsequent transactions. Upon expiry, the expectation is that the offer is no longer retrievable and the shopping process must begin again.
     * Note the presence of an Offer Time Limit does not indicate either a guarantee of price or inventory against a given Offer item within the Offer. Should the offer time limit expire, any other time limit also expires unless an Order has been created or
     * changed. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfferExpirationTimeLimitDateTime;
    /**
     * The OfferItem
     * Meta information extracted from the WSDL
     * - documentation: A priced grouping of one or more services within an Offer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NameChangeOfferItemType[]
     */
    public $OfferItem;
    /**
     * The PenaltyInfoList
     * Meta information extracted from the WSDL
     * - documentation: list of Offer Penalty Information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferPenaltyInfoListType
     */
    public $PenaltyInfoList;
    /**
     * The PenaltyRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Penalty ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PenaltyRefID;
    /**
     * The PTC_OfferParameters
     * Meta information extracted from the WSDL
     * - documentation: Passenger Type summary information for an offer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PTC_OfferParametersType[]
     */
    public $PTC_OfferParameters;
    /**
     * The RedemptionInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, this Offer must be redeemed, e.g. it cannot be purchased. Note: Taxes may still apply. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RedemptionInd;
    /**
     * The RequestedDateInd
     * Meta information extracted from the WSDL
     * - documentation: Indicator to specify if the offer relates to a requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if
     * airline offer is for another date than requested one. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RequestedDateInd;
    /**
     * The RichMedia
     * Meta information extracted from the WSDL
     * - documentation: An external resource such as an Image, Video, PDF or other which is available for display
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MediaResourceRefType[]
     */
    public $RichMedia;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceType
     */
    public $TotalPrice;
    /**
     * The ValidatingCarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $ValidatingCarrierCode;
    /**
     * Constructor method for ChangedOfferType
     * @uses ChangedOfferType::setOfferID()
     * @uses ChangedOfferType::setOwnerCode()
     * @uses ChangedOfferType::setAddedOfferItem()
     * @uses ChangedOfferType::setBaggageAssociations()
     * @uses ChangedOfferType::setBaggageDisclosureRefID()
     * @uses ChangedOfferType::setCommission()
     * @uses ChangedOfferType::setDeleteOrderItem()
     * @uses ChangedOfferType::setDesc()
     * @uses ChangedOfferType::setDisclosureRefID()
     * @uses ChangedOfferType::setForfeitedInfoList()
     * @uses ChangedOfferType::setJourneyOverview()
     * @uses ChangedOfferType::setMatchAppText()
     * @uses ChangedOfferType::setMatchPercent()
     * @uses ChangedOfferType::setMatchTypeCode()
     * @uses ChangedOfferType::setOfferExpirationTimeLimitDateTime()
     * @uses ChangedOfferType::setOfferItem()
     * @uses ChangedOfferType::setPenaltyInfoList()
     * @uses ChangedOfferType::setPenaltyRefID()
     * @uses ChangedOfferType::setPTC_OfferParameters()
     * @uses ChangedOfferType::setRedemptionInd()
     * @uses ChangedOfferType::setRequestedDateInd()
     * @uses ChangedOfferType::setRichMedia()
     * @uses ChangedOfferType::setTotalPrice()
     * @uses ChangedOfferType::setValidatingCarrierCode()
     * @param string $offerID
     * @param string $ownerCode
     * @param \StructType\AddedOfferItemType[] $addedOfferItem
     * @param \StructType\BaggageAssociationsType[] $baggageAssociations
     * @param string[] $baggageDisclosureRefID
     * @param \StructType\CommissionType[] $commission
     * @param \StructType\OrderItemDeletionOfferItemType[] $deleteOrderItem
     * @param \StructType\DescType[] $desc
     * @param string $disclosureRefID
     * @param \StructType\OfferForfeitedInfoListType $forfeitedInfoList
     * @param \StructType\JourneyOverviewType $journeyOverview
     * @param string $matchAppText
     * @param float $matchPercent
     * @param string $matchTypeCode
     * @param string $offerExpirationTimeLimitDateTime
     * @param \StructType\NameChangeOfferItemType[] $offerItem
     * @param \StructType\OfferPenaltyInfoListType $penaltyInfoList
     * @param string[] $penaltyRefID
     * @param \StructType\PTC_OfferParametersType[] $pTC_OfferParameters
     * @param bool $redemptionInd
     * @param bool $requestedDateInd
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @param \StructType\PriceType $totalPrice
     * @param string $validatingCarrierCode
     */
    public function __construct($offerID = null, $ownerCode = null, array $addedOfferItem = array(), array $baggageAssociations = array(), array $baggageDisclosureRefID = array(), array $commission = array(), array $deleteOrderItem = array(), array $desc = array(), $disclosureRefID = null, \StructType\OfferForfeitedInfoListType $forfeitedInfoList = null, \StructType\JourneyOverviewType $journeyOverview = null, $matchAppText = null, $matchPercent = null, $matchTypeCode = null, $offerExpirationTimeLimitDateTime = null, array $offerItem = array(), \StructType\OfferPenaltyInfoListType $penaltyInfoList = null, array $penaltyRefID = array(), array $pTC_OfferParameters = array(), $redemptionInd = null, $requestedDateInd = null, array $richMedia = array(), \StructType\PriceType $totalPrice = null, $validatingCarrierCode = null)
    {
        $this
            ->setOfferID($offerID)
            ->setOwnerCode($ownerCode)
            ->setAddedOfferItem($addedOfferItem)
            ->setBaggageAssociations($baggageAssociations)
            ->setBaggageDisclosureRefID($baggageDisclosureRefID)
            ->setCommission($commission)
            ->setDeleteOrderItem($deleteOrderItem)
            ->setDesc($desc)
            ->setDisclosureRefID($disclosureRefID)
            ->setForfeitedInfoList($forfeitedInfoList)
            ->setJourneyOverview($journeyOverview)
            ->setMatchAppText($matchAppText)
            ->setMatchPercent($matchPercent)
            ->setMatchTypeCode($matchTypeCode)
            ->setOfferExpirationTimeLimitDateTime($offerExpirationTimeLimitDateTime)
            ->setOfferItem($offerItem)
            ->setPenaltyInfoList($penaltyInfoList)
            ->setPenaltyRefID($penaltyRefID)
            ->setPTC_OfferParameters($pTC_OfferParameters)
            ->setRedemptionInd($redemptionInd)
            ->setRequestedDateInd($requestedDateInd)
            ->setRichMedia($richMedia)
            ->setTotalPrice($totalPrice)
            ->setValidatingCarrierCode($validatingCarrierCode);
    }
    /**
     * Get OfferID value
     * @return string
     */
    public function getOfferID()
    {
        return $this->OfferID;
    }
    /**
     * Set OfferID value
     * @param string $offerID
     * @return \StructType\ChangedOfferType
     */
    public function setOfferID($offerID = null)
    {
        // validation for constraint: string
        if (!is_null($offerID) && !is_string($offerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerID, true), gettype($offerID)), __LINE__);
        }
        $this->OfferID = $offerID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\ChangedOfferType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get AddedOfferItem value
     * @return \StructType\AddedOfferItemType[]|null
     */
    public function getAddedOfferItem()
    {
        return $this->AddedOfferItem;
    }
    /**
     * This method is responsible for validating the values passed to the setAddedOfferItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddedOfferItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddedOfferItemForArrayConstraintsFromSetAddedOfferItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changedOfferTypeAddedOfferItemItem) {
            // validation for constraint: itemType
            if (!$changedOfferTypeAddedOfferItemItem instanceof \StructType\AddedOfferItemType) {
                $invalidValues[] = is_object($changedOfferTypeAddedOfferItemItem) ? get_class($changedOfferTypeAddedOfferItemItem) : sprintf('%s(%s)', gettype($changedOfferTypeAddedOfferItemItem), var_export($changedOfferTypeAddedOfferItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddedOfferItem property can only contain items of type \StructType\AddedOfferItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddedOfferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AddedOfferItemType[] $addedOfferItem
     * @return \StructType\ChangedOfferType
     */
    public function setAddedOfferItem(array $addedOfferItem = array())
    {
        // validation for constraint: array
        if ('' !== ($addedOfferItemArrayErrorMessage = self::validateAddedOfferItemForArrayConstraintsFromSetAddedOfferItem($addedOfferItem))) {
            throw new \InvalidArgumentException($addedOfferItemArrayErrorMessage, __LINE__);
        }
        $this->AddedOfferItem = $addedOfferItem;
        return $this;
    }
    /**
     * Add item to AddedOfferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AddedOfferItemType $item
     * @return \StructType\ChangedOfferType
     */
    public function addToAddedOfferItem(\StructType\AddedOfferItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddedOfferItemType) {
            throw new \InvalidArgumentException(sprintf('The AddedOfferItem property can only contain items of type \StructType\AddedOfferItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddedOfferItem[] = $item;
        return $this;
    }
    /**
     * Get BaggageAssociations value
     * @return \StructType\BaggageAssociationsType[]|null
     */
    public function getBaggageAssociations()
    {
        return $this->BaggageAssociations;
    }
    /**
     * This method is responsible for validating the values passed to the setBaggageAssociations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaggageAssociations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaggageAssociationsForArrayConstraintsFromSetBaggageAssociations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changedOfferTypeBaggageAssociationsItem) {
            // validation for constraint: itemType
            if (!$changedOfferTypeBaggageAssociationsItem instanceof \StructType\BaggageAssociationsType) {
                $invalidValues[] = is_object($changedOfferTypeBaggageAssociationsItem) ? get_class($changedOfferTypeBaggageAssociationsItem) : sprintf('%s(%s)', gettype($changedOfferTypeBaggageAssociationsItem), var_export($changedOfferTypeBaggageAssociationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaggageAssociations property can only contain items of type \StructType\BaggageAssociationsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BaggageAssociations value
     * @throws \InvalidArgumentException
     * @param \StructType\BaggageAssociationsType[] $baggageAssociations
     * @return \StructType\ChangedOfferType
     */
    public function setBaggageAssociations(array $baggageAssociations = array())
    {
        // validation for constraint: array
        if ('' !== ($baggageAssociationsArrayErrorMessage = self::validateBaggageAssociationsForArrayConstraintsFromSetBaggageAssociations($baggageAssociations))) {
            throw new \InvalidArgumentException($baggageAssociationsArrayErrorMessage, __LINE__);
        }
        $this->BaggageAssociations = $baggageAssociations;
        return $this;
    }
    /**
     * Add item to BaggageAssociations value
     * @throws \InvalidArgumentException
     * @param \StructType\BaggageAssociationsType $item
     * @return \StructType\ChangedOfferType
     */
    public function addToBaggageAssociations(\StructType\BaggageAssociationsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BaggageAssociationsType) {
            throw new \InvalidArgumentException(sprintf('The BaggageAssociations property can only contain items of type \StructType\BaggageAssociationsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BaggageAssociations[] = $item;
        return $this;
    }
    /**
     * Get BaggageDisclosureRefID value
     * @return string[]|null
     */
    public function getBaggageDisclosureRefID()
    {
        return $this->BaggageDisclosureRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setBaggageDisclosureRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaggageDisclosureRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaggageDisclosureRefIDForArrayConstraintsFromSetBaggageDisclosureRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changedOfferTypeBaggageDisclosureRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($changedOfferTypeBaggageDisclosureRefIDItem)) {
                $invalidValues[] = is_object($changedOfferTypeBaggageDisclosureRefIDItem) ? get_class($changedOfferTypeBaggageDisclosureRefIDItem) : sprintf('%s(%s)', gettype($changedOfferTypeBaggageDisclosureRefIDItem), var_export($changedOfferTypeBaggageDisclosureRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaggageDisclosureRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BaggageDisclosureRefID value
     * @throws \InvalidArgumentException
     * @param string[] $baggageDisclosureRefID
     * @return \StructType\ChangedOfferType
     */
    public function setBaggageDisclosureRefID(array $baggageDisclosureRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($baggageDisclosureRefIDArrayErrorMessage = self::validateBaggageDisclosureRefIDForArrayConstraintsFromSetBaggageDisclosureRefID($baggageDisclosureRefID))) {
            throw new \InvalidArgumentException($baggageDisclosureRefIDArrayErrorMessage, __LINE__);
        }
        $this->BaggageDisclosureRefID = $baggageDisclosureRefID;
        return $this;
    }
    /**
     * Add item to BaggageDisclosureRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ChangedOfferType
     */
    public function addToBaggageDisclosureRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The BaggageDisclosureRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BaggageDisclosureRefID[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changedOfferTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$changedOfferTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($changedOfferTypeCommissionItem) ? get_class($changedOfferTypeCommissionItem) : sprintf('%s(%s)', gettype($changedOfferTypeCommissionItem), var_export($changedOfferTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\ChangedOfferType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\ChangedOfferType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get DeleteOrderItem value
     * @return \StructType\OrderItemDeletionOfferItemType[]|null
     */
    public function getDeleteOrderItem()
    {
        return $this->DeleteOrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setDeleteOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeleteOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeleteOrderItemForArrayConstraintsFromSetDeleteOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changedOfferTypeDeleteOrderItemItem) {
            // validation for constraint: itemType
            if (!$changedOfferTypeDeleteOrderItemItem instanceof \StructType\OrderItemDeletionOfferItemType) {
                $invalidValues[] = is_object($changedOfferTypeDeleteOrderItemItem) ? get_class($changedOfferTypeDeleteOrderItemItem) : sprintf('%s(%s)', gettype($changedOfferTypeDeleteOrderItemItem), var_export($changedOfferTypeDeleteOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeleteOrderItem property can only contain items of type \StructType\OrderItemDeletionOfferItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeleteOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemDeletionOfferItemType[] $deleteOrderItem
     * @return \StructType\ChangedOfferType
     */
    public function setDeleteOrderItem(array $deleteOrderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($deleteOrderItemArrayErrorMessage = self::validateDeleteOrderItemForArrayConstraintsFromSetDeleteOrderItem($deleteOrderItem))) {
            throw new \InvalidArgumentException($deleteOrderItemArrayErrorMessage, __LINE__);
        }
        $this->DeleteOrderItem = $deleteOrderItem;
        return $this;
    }
    /**
     * Add item to DeleteOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemDeletionOfferItemType $item
     * @return \StructType\ChangedOfferType
     */
    public function addToDeleteOrderItem(\StructType\OrderItemDeletionOfferItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItemDeletionOfferItemType) {
            throw new \InvalidArgumentException(sprintf('The DeleteOrderItem property can only contain items of type \StructType\OrderItemDeletionOfferItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeleteOrderItem[] = $item;
        return $this;
    }
    /**
     * Get Desc value
     * @return \StructType\DescType[]|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * This method is responsible for validating the values passed to the setDesc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDesc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescForArrayConstraintsFromSetDesc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changedOfferTypeDescItem) {
            // validation for constraint: itemType
            if (!$changedOfferTypeDescItem instanceof \StructType\DescType) {
                $invalidValues[] = is_object($changedOfferTypeDescItem) ? get_class($changedOfferTypeDescItem) : sprintf('%s(%s)', gettype($changedOfferTypeDescItem), var_export($changedOfferTypeDescItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType[] $desc
     * @return \StructType\ChangedOfferType
     */
    public function setDesc(array $desc = array())
    {
        // validation for constraint: array
        if ('' !== ($descArrayErrorMessage = self::validateDescForArrayConstraintsFromSetDesc($desc))) {
            throw new \InvalidArgumentException($descArrayErrorMessage, __LINE__);
        }
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Add item to Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType $item
     * @return \StructType\ChangedOfferType
     */
    public function addToDesc(\StructType\DescType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescType) {
            throw new \InvalidArgumentException(sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Desc[] = $item;
        return $this;
    }
    /**
     * Get DisclosureRefID value
     * @return string|null
     */
    public function getDisclosureRefID()
    {
        return $this->DisclosureRefID;
    }
    /**
     * Set DisclosureRefID value
     * @param string $disclosureRefID
     * @return \StructType\ChangedOfferType
     */
    public function setDisclosureRefID($disclosureRefID = null)
    {
        // validation for constraint: string
        if (!is_null($disclosureRefID) && !is_string($disclosureRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disclosureRefID, true), gettype($disclosureRefID)), __LINE__);
        }
        $this->DisclosureRefID = $disclosureRefID;
        return $this;
    }
    /**
     * Get ForfeitedInfoList value
     * @return \StructType\OfferForfeitedInfoListType|null
     */
    public function getForfeitedInfoList()
    {
        return $this->ForfeitedInfoList;
    }
    /**
     * Set ForfeitedInfoList value
     * @param \StructType\OfferForfeitedInfoListType $forfeitedInfoList
     * @return \StructType\ChangedOfferType
     */
    public function setForfeitedInfoList(\StructType\OfferForfeitedInfoListType $forfeitedInfoList = null)
    {
        $this->ForfeitedInfoList = $forfeitedInfoList;
        return $this;
    }
    /**
     * Get JourneyOverview value
     * @return \StructType\JourneyOverviewType|null
     */
    public function getJourneyOverview()
    {
        return $this->JourneyOverview;
    }
    /**
     * Set JourneyOverview value
     * @param \StructType\JourneyOverviewType $journeyOverview
     * @return \StructType\ChangedOfferType
     */
    public function setJourneyOverview(\StructType\JourneyOverviewType $journeyOverview = null)
    {
        $this->JourneyOverview = $journeyOverview;
        return $this;
    }
    /**
     * Get MatchAppText value
     * @return string|null
     */
    public function getMatchAppText()
    {
        return $this->MatchAppText;
    }
    /**
     * Set MatchAppText value
     * @param string $matchAppText
     * @return \StructType\ChangedOfferType
     */
    public function setMatchAppText($matchAppText = null)
    {
        // validation for constraint: string
        if (!is_null($matchAppText) && !is_string($matchAppText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchAppText, true), gettype($matchAppText)), __LINE__);
        }
        $this->MatchAppText = $matchAppText;
        return $this;
    }
    /**
     * Get MatchPercent value
     * @return float|null
     */
    public function getMatchPercent()
    {
        return $this->MatchPercent;
    }
    /**
     * Set MatchPercent value
     * @param float $matchPercent
     * @return \StructType\ChangedOfferType
     */
    public function setMatchPercent($matchPercent = null)
    {
        // validation for constraint: float
        if (!is_null($matchPercent) && !(is_float($matchPercent) || is_numeric($matchPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($matchPercent, true), gettype($matchPercent)), __LINE__);
        }
        $this->MatchPercent = $matchPercent;
        return $this;
    }
    /**
     * Get MatchTypeCode value
     * @return string|null
     */
    public function getMatchTypeCode()
    {
        return $this->MatchTypeCode;
    }
    /**
     * Set MatchTypeCode value
     * @param string $matchTypeCode
     * @return \StructType\ChangedOfferType
     */
    public function setMatchTypeCode($matchTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($matchTypeCode) && !is_string($matchTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchTypeCode, true), gettype($matchTypeCode)), __LINE__);
        }
        $this->MatchTypeCode = $matchTypeCode;
        return $this;
    }
    /**
     * Get OfferExpirationTimeLimitDateTime value
     * @return string|null
     */
    public function getOfferExpirationTimeLimitDateTime()
    {
        return $this->OfferExpirationTimeLimitDateTime;
    }
    /**
     * Set OfferExpirationTimeLimitDateTime value
     * @param string $offerExpirationTimeLimitDateTime
     * @return \StructType\ChangedOfferType
     */
    public function setOfferExpirationTimeLimitDateTime($offerExpirationTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($offerExpirationTimeLimitDateTime) && !is_string($offerExpirationTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerExpirationTimeLimitDateTime, true), gettype($offerExpirationTimeLimitDateTime)), __LINE__);
        }
        $this->OfferExpirationTimeLimitDateTime = $offerExpirationTimeLimitDateTime;
        return $this;
    }
    /**
     * Get OfferItem value
     * @return \StructType\NameChangeOfferItemType[]|null
     */
    public function getOfferItem()
    {
        return $this->OfferItem;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferItemForArrayConstraintsFromSetOfferItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changedOfferTypeOfferItemItem) {
            // validation for constraint: itemType
            if (!$changedOfferTypeOfferItemItem instanceof \StructType\NameChangeOfferItemType) {
                $invalidValues[] = is_object($changedOfferTypeOfferItemItem) ? get_class($changedOfferTypeOfferItemItem) : sprintf('%s(%s)', gettype($changedOfferTypeOfferItemItem), var_export($changedOfferTypeOfferItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferItem property can only contain items of type \StructType\NameChangeOfferItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\NameChangeOfferItemType[] $offerItem
     * @return \StructType\ChangedOfferType
     */
    public function setOfferItem(array $offerItem = array())
    {
        // validation for constraint: array
        if ('' !== ($offerItemArrayErrorMessage = self::validateOfferItemForArrayConstraintsFromSetOfferItem($offerItem))) {
            throw new \InvalidArgumentException($offerItemArrayErrorMessage, __LINE__);
        }
        $this->OfferItem = $offerItem;
        return $this;
    }
    /**
     * Add item to OfferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\NameChangeOfferItemType $item
     * @return \StructType\ChangedOfferType
     */
    public function addToOfferItem(\StructType\NameChangeOfferItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NameChangeOfferItemType) {
            throw new \InvalidArgumentException(sprintf('The OfferItem property can only contain items of type \StructType\NameChangeOfferItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OfferItem[] = $item;
        return $this;
    }
    /**
     * Get PenaltyInfoList value
     * @return \StructType\OfferPenaltyInfoListType|null
     */
    public function getPenaltyInfoList()
    {
        return $this->PenaltyInfoList;
    }
    /**
     * Set PenaltyInfoList value
     * @param \StructType\OfferPenaltyInfoListType $penaltyInfoList
     * @return \StructType\ChangedOfferType
     */
    public function setPenaltyInfoList(\StructType\OfferPenaltyInfoListType $penaltyInfoList = null)
    {
        $this->PenaltyInfoList = $penaltyInfoList;
        return $this;
    }
    /**
     * Get PenaltyRefID value
     * @return string[]|null
     */
    public function getPenaltyRefID()
    {
        return $this->PenaltyRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changedOfferTypePenaltyRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($changedOfferTypePenaltyRefIDItem)) {
                $invalidValues[] = is_object($changedOfferTypePenaltyRefIDItem) ? get_class($changedOfferTypePenaltyRefIDItem) : sprintf('%s(%s)', gettype($changedOfferTypePenaltyRefIDItem), var_export($changedOfferTypePenaltyRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string[] $penaltyRefID
     * @return \StructType\ChangedOfferType
     */
    public function setPenaltyRefID(array $penaltyRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyRefIDArrayErrorMessage = self::validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID($penaltyRefID))) {
            throw new \InvalidArgumentException($penaltyRefIDArrayErrorMessage, __LINE__);
        }
        $this->PenaltyRefID = $penaltyRefID;
        return $this;
    }
    /**
     * Add item to PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ChangedOfferType
     */
    public function addToPenaltyRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyRefID[] = $item;
        return $this;
    }
    /**
     * Get PTC_OfferParameters value
     * @return \StructType\PTC_OfferParametersType[]|null
     */
    public function getPTC_OfferParameters()
    {
        return $this->PTC_OfferParameters;
    }
    /**
     * This method is responsible for validating the values passed to the setPTC_OfferParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPTC_OfferParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePTC_OfferParametersForArrayConstraintsFromSetPTC_OfferParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changedOfferTypePTC_OfferParametersItem) {
            // validation for constraint: itemType
            if (!$changedOfferTypePTC_OfferParametersItem instanceof \StructType\PTC_OfferParametersType) {
                $invalidValues[] = is_object($changedOfferTypePTC_OfferParametersItem) ? get_class($changedOfferTypePTC_OfferParametersItem) : sprintf('%s(%s)', gettype($changedOfferTypePTC_OfferParametersItem), var_export($changedOfferTypePTC_OfferParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PTC_OfferParameters property can only contain items of type \StructType\PTC_OfferParametersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PTC_OfferParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\PTC_OfferParametersType[] $pTC_OfferParameters
     * @return \StructType\ChangedOfferType
     */
    public function setPTC_OfferParameters(array $pTC_OfferParameters = array())
    {
        // validation for constraint: array
        if ('' !== ($pTC_OfferParametersArrayErrorMessage = self::validatePTC_OfferParametersForArrayConstraintsFromSetPTC_OfferParameters($pTC_OfferParameters))) {
            throw new \InvalidArgumentException($pTC_OfferParametersArrayErrorMessage, __LINE__);
        }
        $this->PTC_OfferParameters = $pTC_OfferParameters;
        return $this;
    }
    /**
     * Add item to PTC_OfferParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\PTC_OfferParametersType $item
     * @return \StructType\ChangedOfferType
     */
    public function addToPTC_OfferParameters(\StructType\PTC_OfferParametersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PTC_OfferParametersType) {
            throw new \InvalidArgumentException(sprintf('The PTC_OfferParameters property can only contain items of type \StructType\PTC_OfferParametersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PTC_OfferParameters[] = $item;
        return $this;
    }
    /**
     * Get RedemptionInd value
     * @return bool|null
     */
    public function getRedemptionInd()
    {
        return $this->RedemptionInd;
    }
    /**
     * Set RedemptionInd value
     * @param bool $redemptionInd
     * @return \StructType\ChangedOfferType
     */
    public function setRedemptionInd($redemptionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($redemptionInd) && !is_bool($redemptionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($redemptionInd, true), gettype($redemptionInd)), __LINE__);
        }
        $this->RedemptionInd = $redemptionInd;
        return $this;
    }
    /**
     * Get RequestedDateInd value
     * @return bool|null
     */
    public function getRequestedDateInd()
    {
        return $this->RequestedDateInd;
    }
    /**
     * Set RequestedDateInd value
     * @param bool $requestedDateInd
     * @return \StructType\ChangedOfferType
     */
    public function setRequestedDateInd($requestedDateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($requestedDateInd) && !is_bool($requestedDateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requestedDateInd, true), gettype($requestedDateInd)), __LINE__);
        }
        $this->RequestedDateInd = $requestedDateInd;
        return $this;
    }
    /**
     * Get RichMedia value
     * @return \StructType\MediaResourceRefType[]|null
     */
    public function getRichMedia()
    {
        return $this->RichMedia;
    }
    /**
     * This method is responsible for validating the values passed to the setRichMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRichMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRichMediaForArrayConstraintsFromSetRichMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changedOfferTypeRichMediaItem) {
            // validation for constraint: itemType
            if (!$changedOfferTypeRichMediaItem instanceof \StructType\MediaResourceRefType) {
                $invalidValues[] = is_object($changedOfferTypeRichMediaItem) ? get_class($changedOfferTypeRichMediaItem) : sprintf('%s(%s)', gettype($changedOfferTypeRichMediaItem), var_export($changedOfferTypeRichMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @return \StructType\ChangedOfferType
     */
    public function setRichMedia(array $richMedia = array())
    {
        // validation for constraint: array
        if ('' !== ($richMediaArrayErrorMessage = self::validateRichMediaForArrayConstraintsFromSetRichMedia($richMedia))) {
            throw new \InvalidArgumentException($richMediaArrayErrorMessage, __LINE__);
        }
        $this->RichMedia = $richMedia;
        return $this;
    }
    /**
     * Add item to RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType $item
     * @return \StructType\ChangedOfferType
     */
    public function addToRichMedia(\StructType\MediaResourceRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaResourceRefType) {
            throw new \InvalidArgumentException(sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RichMedia[] = $item;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \StructType\PriceType|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \StructType\PriceType $totalPrice
     * @return \StructType\ChangedOfferType
     */
    public function setTotalPrice(\StructType\PriceType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get ValidatingCarrierCode value
     * @return string|null
     */
    public function getValidatingCarrierCode()
    {
        return $this->ValidatingCarrierCode;
    }
    /**
     * Set ValidatingCarrierCode value
     * @param string $validatingCarrierCode
     * @return \StructType\ChangedOfferType
     */
    public function setValidatingCarrierCode($validatingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($validatingCarrierCode) && !is_string($validatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatingCarrierCode, true), gettype($validatingCarrierCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($validatingCarrierCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $validatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($validatingCarrierCode, true)), __LINE__);
        }
        $this->ValidatingCarrierCode = $validatingCarrierCode;
        return $this;
    }
}
