<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeToServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: A change to Service specialization of the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a
 * service can be sold to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
 * @subpackage Structs
 */
class ChangeToServiceType extends AbstractStructBase
{
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a Service within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceID;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\BookingRefType[]
     */
    public $BookingRef;
    /**
     * The DeliveryStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Service Delivery Service Status instance. See ATSB Codeset DeliveryService for possible values. | Shows the possible statuses of a service delivery item. {codeListAgencyName}IATA Code List{/codeListAgencyName}
     * {codeListName}Delivery Service Status, Coded.{/codeListName} {codeListIdentifier}DELIVERYSERVICE{/codeListIdentifier} | Represents the current status of a service delivery item
     * - base: ServiceDeliveryStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryStatusCode;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Free text for textual description. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The OrderServiceAssociation
     * Meta information extracted from the WSDL
     * - documentation: Order Service Association
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderServiceAssociationType
     */
    public $OrderServiceAssociation;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID within this message | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxRefID;
    /**
     * The ServiceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to another service instance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceRefID;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Service Status instance. See ATSB Codeset OrderService for possible values. | The possible statuses of an Order Service {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Service
     * Status,coded{/codeListName} {codeListIdentifier}ORDERSERVICE{/codeListIdentifier} | represents the statuses of an Order Service
     * - base: OrderServiceStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The UnchangedInd
     * Meta information extracted from the WSDL
     * - documentation: Indicated that this service is unchanged after reshopping. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $UnchangedInd;
    /**
     * The ValidatingCarrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $ValidatingCarrier;
    /**
     * Constructor method for ChangeToServiceType
     * @uses ChangeToServiceType::setServiceID()
     * @uses ChangeToServiceType::setAirlineTaxonomy()
     * @uses ChangeToServiceType::setBookingRef()
     * @uses ChangeToServiceType::setDeliveryStatusCode()
     * @uses ChangeToServiceType::setDescText()
     * @uses ChangeToServiceType::setOrderServiceAssociation()
     * @uses ChangeToServiceType::setPaxRefID()
     * @uses ChangeToServiceType::setServiceRefID()
     * @uses ChangeToServiceType::setStatusCode()
     * @uses ChangeToServiceType::setUnchangedInd()
     * @uses ChangeToServiceType::setValidatingCarrier()
     * @param string $serviceID
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param \StructType\BookingRefType[] $bookingRef
     * @param string $deliveryStatusCode
     * @param string $descText
     * @param \StructType\OrderServiceAssociationType $orderServiceAssociation
     * @param string $paxRefID
     * @param string $serviceRefID
     * @param string $statusCode
     * @param bool $unchangedInd
     * @param \StructType\CarrierType $validatingCarrier
     */
    public function __construct($serviceID = null, array $airlineTaxonomy = array(), array $bookingRef = array(), $deliveryStatusCode = null, $descText = null, \StructType\OrderServiceAssociationType $orderServiceAssociation = null, $paxRefID = null, $serviceRefID = null, $statusCode = null, $unchangedInd = null, \StructType\CarrierType $validatingCarrier = null)
    {
        $this
            ->setServiceID($serviceID)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setBookingRef($bookingRef)
            ->setDeliveryStatusCode($deliveryStatusCode)
            ->setDescText($descText)
            ->setOrderServiceAssociation($orderServiceAssociation)
            ->setPaxRefID($paxRefID)
            ->setServiceRefID($serviceRefID)
            ->setStatusCode($statusCode)
            ->setUnchangedInd($unchangedInd)
            ->setValidatingCarrier($validatingCarrier);
    }
    /**
     * Get ServiceID value
     * @return string
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \StructType\ChangeToServiceType
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changeToServiceTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$changeToServiceTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($changeToServiceTypeAirlineTaxonomyItem) ? get_class($changeToServiceTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($changeToServiceTypeAirlineTaxonomyItem), var_export($changeToServiceTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\ChangeToServiceType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\ChangeToServiceType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return \StructType\BookingRefType[]|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingRefForArrayConstraintsFromSetBookingRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changeToServiceTypeBookingRefItem) {
            // validation for constraint: itemType
            if (!$changeToServiceTypeBookingRefItem instanceof \StructType\BookingRefType) {
                $invalidValues[] = is_object($changeToServiceTypeBookingRefItem) ? get_class($changeToServiceTypeBookingRefItem) : sprintf('%s(%s)', gettype($changeToServiceTypeBookingRefItem), var_export($changeToServiceTypeBookingRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType[] $bookingRef
     * @return \StructType\ChangeToServiceType
     */
    public function setBookingRef(array $bookingRef = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingRefArrayErrorMessage = self::validateBookingRefForArrayConstraintsFromSetBookingRef($bookingRef))) {
            throw new \InvalidArgumentException($bookingRefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($bookingRef) && count($bookingRef) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($bookingRef)), __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Add item to BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType $item
     * @return \StructType\ChangeToServiceType
     */
    public function addToBookingRef(\StructType\BookingRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingRefType) {
            throw new \InvalidArgumentException(sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->BookingRef) && count($this->BookingRef) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->BookingRef)), __LINE__);
        }
        $this->BookingRef[] = $item;
        return $this;
    }
    /**
     * Get DeliveryStatusCode value
     * @return string|null
     */
    public function getDeliveryStatusCode()
    {
        return $this->DeliveryStatusCode;
    }
    /**
     * Set DeliveryStatusCode value
     * @param string $deliveryStatusCode
     * @return \StructType\ChangeToServiceType
     */
    public function setDeliveryStatusCode($deliveryStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryStatusCode) && !is_string($deliveryStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryStatusCode, true), gettype($deliveryStatusCode)), __LINE__);
        }
        $this->DeliveryStatusCode = $deliveryStatusCode;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\ChangeToServiceType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get OrderServiceAssociation value
     * @return \StructType\OrderServiceAssociationType|null
     */
    public function getOrderServiceAssociation()
    {
        return $this->OrderServiceAssociation;
    }
    /**
     * Set OrderServiceAssociation value
     * @param \StructType\OrderServiceAssociationType $orderServiceAssociation
     * @return \StructType\ChangeToServiceType
     */
    public function setOrderServiceAssociation(\StructType\OrderServiceAssociationType $orderServiceAssociation = null)
    {
        $this->OrderServiceAssociation = $orderServiceAssociation;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\ChangeToServiceType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get ServiceRefID value
     * @return string|null
     */
    public function getServiceRefID()
    {
        return $this->ServiceRefID;
    }
    /**
     * Set ServiceRefID value
     * @param string $serviceRefID
     * @return \StructType\ChangeToServiceType
     */
    public function setServiceRefID($serviceRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRefID) && !is_string($serviceRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRefID, true), gettype($serviceRefID)), __LINE__);
        }
        $this->ServiceRefID = $serviceRefID;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\ChangeToServiceType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get UnchangedInd value
     * @return bool|null
     */
    public function getUnchangedInd()
    {
        return $this->UnchangedInd;
    }
    /**
     * Set UnchangedInd value
     * @param bool $unchangedInd
     * @return \StructType\ChangeToServiceType
     */
    public function setUnchangedInd($unchangedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($unchangedInd) && !is_bool($unchangedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unchangedInd, true), gettype($unchangedInd)), __LINE__);
        }
        $this->UnchangedInd = $unchangedInd;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return \StructType\CarrierType|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param \StructType\CarrierType $validatingCarrier
     * @return \StructType\ChangeToServiceType
     */
    public function setValidatingCarrier(\StructType\CarrierType $validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
}
