<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeOrderChoiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Change Order Choice
 * @subpackage Structs
 */
class ChangeOrderChoiceType extends AbstractStructBase
{
    /**
     * The AcceptCancelledOffer
     * Meta information extracted from the WSDL
     * - documentation: A cancellation offer (coming from an offer with deletedorderitems) which instructs the airline to cancel components of an order.
     * - choice: AcceptCancelledOffer | AcceptChange | AcceptOrderItemList | AcceptRepricedOrder | AcceptSelectedQuotedOfferList | CancelUnpaidOrder | UpdatePax
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AcceptCancelOfferType
     */
    public $AcceptCancelledOffer;
    /**
     * The AcceptChange
     * Meta information extracted from the WSDL
     * - documentation: An ability to accept a change ( coming from seller followup actions in OrderChangeNotification ) when requested by the airline.
     * - choice: AcceptCancelledOffer | AcceptChange | AcceptOrderItemList | AcceptRepricedOrder | AcceptSelectedQuotedOfferList | CancelUnpaidOrder | UpdatePax
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SelectedOrderItemType
     */
    public $AcceptChange;
    /**
     * The AcceptOrderItemList
     * Meta information extracted from the WSDL
     * - documentation: A collection of Create Order Item's.
     * - choice: AcceptCancelledOffer | AcceptChange | AcceptOrderItemList | AcceptRepricedOrder | AcceptSelectedQuotedOfferList | CancelUnpaidOrder | UpdatePax
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AcceptOrderItemListType
     */
    public $AcceptOrderItemList;
    /**
     * The AcceptRepricedOrder
     * Meta information extracted from the WSDL
     * - documentation: A function used by seller to inform the airline that it is accepting the proposed Order, as it has been re-priced and returned in the preceding OrderReshopRS.
     * - choice: AcceptCancelledOffer | AcceptChange | AcceptOrderItemList | AcceptRepricedOrder | AcceptSelectedQuotedOfferList | CancelUnpaidOrder | UpdatePax
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AcceptRepricedOrderType
     */
    public $AcceptRepricedOrder;
    /**
     * The AcceptSelectedQuotedOfferList
     * Meta information extracted from the WSDL
     * - documentation: An ability to accept selected offer items from a Quoted Offer.
     * - choice: AcceptCancelledOffer | AcceptChange | AcceptOrderItemList | AcceptRepricedOrder | AcceptSelectedQuotedOfferList | CancelUnpaidOrder | UpdatePax
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AcceptSelectedQuotedOfferListType
     */
    public $AcceptSelectedQuotedOfferList;
    /**
     * The CancelUnpaidOrder
     * Meta information extracted from the WSDL
     * - documentation: An ability to cancel entire un-paid order.
     * - choice: AcceptCancelledOffer | AcceptChange | AcceptOrderItemList | AcceptRepricedOrder | AcceptSelectedQuotedOfferList | CancelUnpaidOrder | UpdatePax
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CancelUnpaidOrderType
     */
    public $CancelUnpaidOrder;
    /**
     * The UpdatePax
     * Meta information extracted from the WSDL
     * - documentation: Specialisation for Order Change of update passenger. Function to Add, Remove or Update the Passenger Details. Providing the New and Previous values together implies an Update.
     * - choice: AcceptCancelledOffer | AcceptChange | AcceptOrderItemList | AcceptRepricedOrder | AcceptSelectedQuotedOfferList | CancelUnpaidOrder | UpdatePax
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderChangeUpdatePaxType
     */
    public $UpdatePax;
    /**
     * Constructor method for ChangeOrderChoiceType
     * @uses ChangeOrderChoiceType::setAcceptCancelledOffer()
     * @uses ChangeOrderChoiceType::setAcceptChange()
     * @uses ChangeOrderChoiceType::setAcceptOrderItemList()
     * @uses ChangeOrderChoiceType::setAcceptRepricedOrder()
     * @uses ChangeOrderChoiceType::setAcceptSelectedQuotedOfferList()
     * @uses ChangeOrderChoiceType::setCancelUnpaidOrder()
     * @uses ChangeOrderChoiceType::setUpdatePax()
     * @param \StructType\AcceptCancelOfferType $acceptCancelledOffer
     * @param \StructType\SelectedOrderItemType $acceptChange
     * @param \StructType\AcceptOrderItemListType $acceptOrderItemList
     * @param \StructType\AcceptRepricedOrderType $acceptRepricedOrder
     * @param \StructType\AcceptSelectedQuotedOfferListType $acceptSelectedQuotedOfferList
     * @param \StructType\CancelUnpaidOrderType $cancelUnpaidOrder
     * @param \StructType\OrderChangeUpdatePaxType $updatePax
     */
    public function __construct(\StructType\AcceptCancelOfferType $acceptCancelledOffer = null, \StructType\SelectedOrderItemType $acceptChange = null, \StructType\AcceptOrderItemListType $acceptOrderItemList = null, \StructType\AcceptRepricedOrderType $acceptRepricedOrder = null, \StructType\AcceptSelectedQuotedOfferListType $acceptSelectedQuotedOfferList = null, \StructType\CancelUnpaidOrderType $cancelUnpaidOrder = null, \StructType\OrderChangeUpdatePaxType $updatePax = null)
    {
        $this
            ->setAcceptCancelledOffer($acceptCancelledOffer)
            ->setAcceptChange($acceptChange)
            ->setAcceptOrderItemList($acceptOrderItemList)
            ->setAcceptRepricedOrder($acceptRepricedOrder)
            ->setAcceptSelectedQuotedOfferList($acceptSelectedQuotedOfferList)
            ->setCancelUnpaidOrder($cancelUnpaidOrder)
            ->setUpdatePax($updatePax);
    }
    /**
     * Get AcceptCancelledOffer value
     * @return \StructType\AcceptCancelOfferType
     */
    public function getAcceptCancelledOffer()
    {
        return isset($this->AcceptCancelledOffer) ? $this->AcceptCancelledOffer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAcceptCancelledOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptCancelledOffer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAcceptCancelledOfferForChoiceConstraintsFromSetAcceptCancelledOffer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AcceptChange',
            'AcceptOrderItemList',
            'AcceptRepricedOrder',
            'AcceptSelectedQuotedOfferList',
            'CancelUnpaidOrder',
            'UpdatePax',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AcceptCancelledOffer can\'t be set as the property %s is already set. Only one property must be set among these properties: AcceptCancelledOffer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AcceptCancelledOffer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptCancelOfferType $acceptCancelledOffer
     * @return \StructType\ChangeOrderChoiceType
     */
    public function setAcceptCancelledOffer(\StructType\AcceptCancelOfferType $acceptCancelledOffer = null)
    {
        // validation for constraint: choice(AcceptCancelledOffer, AcceptChange, AcceptOrderItemList, AcceptRepricedOrder, AcceptSelectedQuotedOfferList, CancelUnpaidOrder, UpdatePax)
        if ('' !== ($acceptCancelledOfferChoiceErrorMessage = self::validateAcceptCancelledOfferForChoiceConstraintsFromSetAcceptCancelledOffer($acceptCancelledOffer))) {
            throw new \InvalidArgumentException($acceptCancelledOfferChoiceErrorMessage, __LINE__);
        }
        if (is_null($acceptCancelledOffer) || (is_array($acceptCancelledOffer) && empty($acceptCancelledOffer))) {
            unset($this->AcceptCancelledOffer);
        } else {
            $this->AcceptCancelledOffer = $acceptCancelledOffer;
        }
        return $this;
    }
    /**
     * Get AcceptChange value
     * @return \StructType\SelectedOrderItemType
     */
    public function getAcceptChange()
    {
        return isset($this->AcceptChange) ? $this->AcceptChange : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAcceptChange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptChange method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAcceptChangeForChoiceConstraintsFromSetAcceptChange($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AcceptCancelledOffer',
            'AcceptOrderItemList',
            'AcceptRepricedOrder',
            'AcceptSelectedQuotedOfferList',
            'CancelUnpaidOrder',
            'UpdatePax',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AcceptChange can\'t be set as the property %s is already set. Only one property must be set among these properties: AcceptChange, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AcceptChange value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOrderItemType $acceptChange
     * @return \StructType\ChangeOrderChoiceType
     */
    public function setAcceptChange(\StructType\SelectedOrderItemType $acceptChange = null)
    {
        // validation for constraint: choice(AcceptCancelledOffer, AcceptChange, AcceptOrderItemList, AcceptRepricedOrder, AcceptSelectedQuotedOfferList, CancelUnpaidOrder, UpdatePax)
        if ('' !== ($acceptChangeChoiceErrorMessage = self::validateAcceptChangeForChoiceConstraintsFromSetAcceptChange($acceptChange))) {
            throw new \InvalidArgumentException($acceptChangeChoiceErrorMessage, __LINE__);
        }
        if (is_null($acceptChange) || (is_array($acceptChange) && empty($acceptChange))) {
            unset($this->AcceptChange);
        } else {
            $this->AcceptChange = $acceptChange;
        }
        return $this;
    }
    /**
     * Get AcceptOrderItemList value
     * @return \StructType\AcceptOrderItemListType
     */
    public function getAcceptOrderItemList()
    {
        return isset($this->AcceptOrderItemList) ? $this->AcceptOrderItemList : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAcceptOrderItemList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptOrderItemList method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAcceptOrderItemListForChoiceConstraintsFromSetAcceptOrderItemList($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AcceptCancelledOffer',
            'AcceptChange',
            'AcceptRepricedOrder',
            'AcceptSelectedQuotedOfferList',
            'CancelUnpaidOrder',
            'UpdatePax',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AcceptOrderItemList can\'t be set as the property %s is already set. Only one property must be set among these properties: AcceptOrderItemList, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AcceptOrderItemList value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptOrderItemListType $acceptOrderItemList
     * @return \StructType\ChangeOrderChoiceType
     */
    public function setAcceptOrderItemList(\StructType\AcceptOrderItemListType $acceptOrderItemList = null)
    {
        // validation for constraint: choice(AcceptCancelledOffer, AcceptChange, AcceptOrderItemList, AcceptRepricedOrder, AcceptSelectedQuotedOfferList, CancelUnpaidOrder, UpdatePax)
        if ('' !== ($acceptOrderItemListChoiceErrorMessage = self::validateAcceptOrderItemListForChoiceConstraintsFromSetAcceptOrderItemList($acceptOrderItemList))) {
            throw new \InvalidArgumentException($acceptOrderItemListChoiceErrorMessage, __LINE__);
        }
        if (is_null($acceptOrderItemList) || (is_array($acceptOrderItemList) && empty($acceptOrderItemList))) {
            unset($this->AcceptOrderItemList);
        } else {
            $this->AcceptOrderItemList = $acceptOrderItemList;
        }
        return $this;
    }
    /**
     * Get AcceptRepricedOrder value
     * @return \StructType\AcceptRepricedOrderType
     */
    public function getAcceptRepricedOrder()
    {
        return isset($this->AcceptRepricedOrder) ? $this->AcceptRepricedOrder : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAcceptRepricedOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptRepricedOrder method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAcceptRepricedOrderForChoiceConstraintsFromSetAcceptRepricedOrder($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AcceptCancelledOffer',
            'AcceptChange',
            'AcceptOrderItemList',
            'AcceptSelectedQuotedOfferList',
            'CancelUnpaidOrder',
            'UpdatePax',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AcceptRepricedOrder can\'t be set as the property %s is already set. Only one property must be set among these properties: AcceptRepricedOrder, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AcceptRepricedOrder value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptRepricedOrderType $acceptRepricedOrder
     * @return \StructType\ChangeOrderChoiceType
     */
    public function setAcceptRepricedOrder(\StructType\AcceptRepricedOrderType $acceptRepricedOrder = null)
    {
        // validation for constraint: choice(AcceptCancelledOffer, AcceptChange, AcceptOrderItemList, AcceptRepricedOrder, AcceptSelectedQuotedOfferList, CancelUnpaidOrder, UpdatePax)
        if ('' !== ($acceptRepricedOrderChoiceErrorMessage = self::validateAcceptRepricedOrderForChoiceConstraintsFromSetAcceptRepricedOrder($acceptRepricedOrder))) {
            throw new \InvalidArgumentException($acceptRepricedOrderChoiceErrorMessage, __LINE__);
        }
        if (is_null($acceptRepricedOrder) || (is_array($acceptRepricedOrder) && empty($acceptRepricedOrder))) {
            unset($this->AcceptRepricedOrder);
        } else {
            $this->AcceptRepricedOrder = $acceptRepricedOrder;
        }
        return $this;
    }
    /**
     * Get AcceptSelectedQuotedOfferList value
     * @return \StructType\AcceptSelectedQuotedOfferListType
     */
    public function getAcceptSelectedQuotedOfferList()
    {
        return isset($this->AcceptSelectedQuotedOfferList) ? $this->AcceptSelectedQuotedOfferList : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAcceptSelectedQuotedOfferList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptSelectedQuotedOfferList method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAcceptSelectedQuotedOfferListForChoiceConstraintsFromSetAcceptSelectedQuotedOfferList($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AcceptCancelledOffer',
            'AcceptChange',
            'AcceptOrderItemList',
            'AcceptRepricedOrder',
            'CancelUnpaidOrder',
            'UpdatePax',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AcceptSelectedQuotedOfferList can\'t be set as the property %s is already set. Only one property must be set among these properties: AcceptSelectedQuotedOfferList, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AcceptSelectedQuotedOfferList value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptSelectedQuotedOfferListType $acceptSelectedQuotedOfferList
     * @return \StructType\ChangeOrderChoiceType
     */
    public function setAcceptSelectedQuotedOfferList(\StructType\AcceptSelectedQuotedOfferListType $acceptSelectedQuotedOfferList = null)
    {
        // validation for constraint: choice(AcceptCancelledOffer, AcceptChange, AcceptOrderItemList, AcceptRepricedOrder, AcceptSelectedQuotedOfferList, CancelUnpaidOrder, UpdatePax)
        if ('' !== ($acceptSelectedQuotedOfferListChoiceErrorMessage = self::validateAcceptSelectedQuotedOfferListForChoiceConstraintsFromSetAcceptSelectedQuotedOfferList($acceptSelectedQuotedOfferList))) {
            throw new \InvalidArgumentException($acceptSelectedQuotedOfferListChoiceErrorMessage, __LINE__);
        }
        if (is_null($acceptSelectedQuotedOfferList) || (is_array($acceptSelectedQuotedOfferList) && empty($acceptSelectedQuotedOfferList))) {
            unset($this->AcceptSelectedQuotedOfferList);
        } else {
            $this->AcceptSelectedQuotedOfferList = $acceptSelectedQuotedOfferList;
        }
        return $this;
    }
    /**
     * Get CancelUnpaidOrder value
     * @return \StructType\CancelUnpaidOrderType
     */
    public function getCancelUnpaidOrder()
    {
        return isset($this->CancelUnpaidOrder) ? $this->CancelUnpaidOrder : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCancelUnpaidOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelUnpaidOrder method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCancelUnpaidOrderForChoiceConstraintsFromSetCancelUnpaidOrder($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AcceptCancelledOffer',
            'AcceptChange',
            'AcceptOrderItemList',
            'AcceptRepricedOrder',
            'AcceptSelectedQuotedOfferList',
            'UpdatePax',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CancelUnpaidOrder can\'t be set as the property %s is already set. Only one property must be set among these properties: CancelUnpaidOrder, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CancelUnpaidOrder value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CancelUnpaidOrderType $cancelUnpaidOrder
     * @return \StructType\ChangeOrderChoiceType
     */
    public function setCancelUnpaidOrder(\StructType\CancelUnpaidOrderType $cancelUnpaidOrder = null)
    {
        // validation for constraint: choice(AcceptCancelledOffer, AcceptChange, AcceptOrderItemList, AcceptRepricedOrder, AcceptSelectedQuotedOfferList, CancelUnpaidOrder, UpdatePax)
        if ('' !== ($cancelUnpaidOrderChoiceErrorMessage = self::validateCancelUnpaidOrderForChoiceConstraintsFromSetCancelUnpaidOrder($cancelUnpaidOrder))) {
            throw new \InvalidArgumentException($cancelUnpaidOrderChoiceErrorMessage, __LINE__);
        }
        if (is_null($cancelUnpaidOrder) || (is_array($cancelUnpaidOrder) && empty($cancelUnpaidOrder))) {
            unset($this->CancelUnpaidOrder);
        } else {
            $this->CancelUnpaidOrder = $cancelUnpaidOrder;
        }
        return $this;
    }
    /**
     * Get UpdatePax value
     * @return \StructType\OrderChangeUpdatePaxType
     */
    public function getUpdatePax()
    {
        return isset($this->UpdatePax) ? $this->UpdatePax : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUpdatePax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUpdatePax method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUpdatePaxForChoiceConstraintsFromSetUpdatePax($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AcceptCancelledOffer',
            'AcceptChange',
            'AcceptOrderItemList',
            'AcceptRepricedOrder',
            'AcceptSelectedQuotedOfferList',
            'CancelUnpaidOrder',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UpdatePax can\'t be set as the property %s is already set. Only one property must be set among these properties: UpdatePax, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UpdatePax value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderChangeUpdatePaxType $updatePax
     * @return \StructType\ChangeOrderChoiceType
     */
    public function setUpdatePax(\StructType\OrderChangeUpdatePaxType $updatePax = null)
    {
        // validation for constraint: choice(AcceptCancelledOffer, AcceptChange, AcceptOrderItemList, AcceptRepricedOrder, AcceptSelectedQuotedOfferList, CancelUnpaidOrder, UpdatePax)
        if ('' !== ($updatePaxChoiceErrorMessage = self::validateUpdatePaxForChoiceConstraintsFromSetUpdatePax($updatePax))) {
            throw new \InvalidArgumentException($updatePaxChoiceErrorMessage, __LINE__);
        }
        if (is_null($updatePax) || (is_array($updatePax) && empty($updatePax))) {
            unset($this->UpdatePax);
        } else {
            $this->UpdatePax = $updatePax;
        }
        return $this;
    }
}
