<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeOperationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Change Operation is an Instruction on addition, replacement or deletion of elements within an Order.
 * @subpackage Structs
 */
class ChangeOperationType extends AbstractStructBase
{
    /**
     * The ChangeDateTime
     * Meta information extracted from the WSDL
     * - documentation: Change Operation Date and Time within an Order. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangeDateTime;
    /**
     * The ChangeTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Refer to IATA ATSB Codeset: CHT Indicates to the Seller the type of change. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangeTypeCode;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - documentation: Refer to ATSB Codeset: CHR Indicating the reason for change. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReasonCode;
    /**
     * The New
     * Meta information extracted from the WSDL
     * - documentation: A Structural node used in messages which contains details of the changes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChangeDetailsType
     */
    public $New;
    /**
     * The Old
     * Meta information extracted from the WSDL
     * - documentation: A Structural node used in messages which contains details of the changes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChangeDetailsType
     */
    public $Old;
    /**
     * Constructor method for ChangeOperationType
     * @uses ChangeOperationType::setChangeDateTime()
     * @uses ChangeOperationType::setChangeTypeCode()
     * @uses ChangeOperationType::setReasonCode()
     * @uses ChangeOperationType::setNew()
     * @uses ChangeOperationType::setOld()
     * @param string $changeDateTime
     * @param string $changeTypeCode
     * @param string $reasonCode
     * @param \StructType\ChangeDetailsType $new
     * @param \StructType\ChangeDetailsType $old
     */
    public function __construct($changeDateTime = null, $changeTypeCode = null, $reasonCode = null, \StructType\ChangeDetailsType $new = null, \StructType\ChangeDetailsType $old = null)
    {
        $this
            ->setChangeDateTime($changeDateTime)
            ->setChangeTypeCode($changeTypeCode)
            ->setReasonCode($reasonCode)
            ->setNew($new)
            ->setOld($old);
    }
    /**
     * Get ChangeDateTime value
     * @return string
     */
    public function getChangeDateTime()
    {
        return $this->ChangeDateTime;
    }
    /**
     * Set ChangeDateTime value
     * @param string $changeDateTime
     * @return \StructType\ChangeOperationType
     */
    public function setChangeDateTime($changeDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($changeDateTime) && !is_string($changeDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeDateTime, true), gettype($changeDateTime)), __LINE__);
        }
        $this->ChangeDateTime = $changeDateTime;
        return $this;
    }
    /**
     * Get ChangeTypeCode value
     * @return string
     */
    public function getChangeTypeCode()
    {
        return $this->ChangeTypeCode;
    }
    /**
     * Set ChangeTypeCode value
     * @param string $changeTypeCode
     * @return \StructType\ChangeOperationType
     */
    public function setChangeTypeCode($changeTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($changeTypeCode) && !is_string($changeTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeTypeCode, true), gettype($changeTypeCode)), __LINE__);
        }
        $this->ChangeTypeCode = $changeTypeCode;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \StructType\ChangeOperationType
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get New value
     * @return \StructType\ChangeDetailsType|null
     */
    public function getNew()
    {
        return $this->New;
    }
    /**
     * Set New value
     * @param \StructType\ChangeDetailsType $new
     * @return \StructType\ChangeOperationType
     */
    public function setNew(\StructType\ChangeDetailsType $new = null)
    {
        $this->New = $new;
        return $this;
    }
    /**
     * Get Old value
     * @return \StructType\ChangeDetailsType|null
     */
    public function getOld()
    {
        return $this->Old;
    }
    /**
     * Set Old value
     * @param \StructType\ChangeDetailsType $old
     * @return \StructType\ChangeOperationType
     */
    public function setOld(\StructType\ChangeDetailsType $old = null)
    {
        $this->Old = $old;
        return $this;
    }
}
