<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeGroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: A node containing change operation group
 * @subpackage Structs
 */
class ChangeGroupType extends AbstractStructBase
{
    /**
     * The ChangeOperationGroup
     * Meta information extracted from the WSDL
     * - documentation: Change Operation Group is a logical grouping of one or more operations that leads to a new Order Version. Should not have multiple change operations to the same element.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ChangeOperationGroupType[]
     */
    public $ChangeOperationGroup;
    /**
     * Constructor method for ChangeGroupType
     * @uses ChangeGroupType::setChangeOperationGroup()
     * @param \StructType\ChangeOperationGroupType[] $changeOperationGroup
     */
    public function __construct(array $changeOperationGroup = array())
    {
        $this
            ->setChangeOperationGroup($changeOperationGroup);
    }
    /**
     * Get ChangeOperationGroup value
     * @return \StructType\ChangeOperationGroupType[]
     */
    public function getChangeOperationGroup()
    {
        return $this->ChangeOperationGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeOperationGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeOperationGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeOperationGroupForArrayConstraintsFromSetChangeOperationGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changeGroupTypeChangeOperationGroupItem) {
            // validation for constraint: itemType
            if (!$changeGroupTypeChangeOperationGroupItem instanceof \StructType\ChangeOperationGroupType) {
                $invalidValues[] = is_object($changeGroupTypeChangeOperationGroupItem) ? get_class($changeGroupTypeChangeOperationGroupItem) : sprintf('%s(%s)', gettype($changeGroupTypeChangeOperationGroupItem), var_export($changeGroupTypeChangeOperationGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeOperationGroup property can only contain items of type \StructType\ChangeOperationGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeOperationGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeOperationGroupType[] $changeOperationGroup
     * @return \StructType\ChangeGroupType
     */
    public function setChangeOperationGroup(array $changeOperationGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($changeOperationGroupArrayErrorMessage = self::validateChangeOperationGroupForArrayConstraintsFromSetChangeOperationGroup($changeOperationGroup))) {
            throw new \InvalidArgumentException($changeOperationGroupArrayErrorMessage, __LINE__);
        }
        $this->ChangeOperationGroup = $changeOperationGroup;
        return $this;
    }
    /**
     * Add item to ChangeOperationGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeOperationGroupType $item
     * @return \StructType\ChangeGroupType
     */
    public function addToChangeOperationGroup(\StructType\ChangeOperationGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeOperationGroupType) {
            throw new \InvalidArgumentException(sprintf('The ChangeOperationGroup property can only contain items of type \StructType\ChangeOperationGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeOperationGroup[] = $item;
        return $this;
    }
}
